/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.astar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;

public class AStarResult {
    public HashMap previousNode = new HashMap();
    public Collection openList;
    public Collection closeList = new HashSet();
    public HashMap pathCost = new HashMap();
    public HashMap estimatedCost = new HashMap();
    public long interations = 0L;
    public Object startNode = null;
    public Object goalNode = null;
    public boolean success = false;
    private ArrayList path = null;

    public Object getPreviousNode(Object node) {
        if (this.previousNode.containsKey(node)) {
            return this.previousNode.get(node);
        }
        return null;
    }

    public void putPreviousNode(Object node, Object previous) {
        this.previousNode.put(node, previous);
    }

    public int getCostToNode(Object node) {
        if (this.pathCost.containsKey(node)) {
            return (Integer)this.pathCost.get(node);
        }
        return -1;
    }

    public void putCostToNode(Object node, Integer cost) {
        this.pathCost.put(node, cost);
    }

    public void putCostToNode(Object node, int cost) {
        this.putCostToNode(node, new Integer(cost));
    }

    public int getEstimatedCostToNode(Object node) {
        if (this.estimatedCost.containsKey(node)) {
            return (Integer)this.estimatedCost.get(node);
        }
        return -1;
    }

    public void putEstimatedCostToNode(Object node, Integer cost) {
        this.estimatedCost.put(node, cost);
    }

    public void putEstimatedCostToNode(Object node, int cost) {
        this.putEstimatedCostToNode(node, new Integer(cost));
    }

    public ArrayList getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (!this.success) {
            return null;
        }
        Stack<Object> tempPath = new Stack<Object>();
        tempPath.push(this.goalNode);
        Object node = this.goalNode;
        while (node != this.startNode) {
            if ((node = this.getPreviousNode(node)) == null) {
                return null;
            }
            tempPath.push(node);
        }
        this.path = new ArrayList();
        while (!tempPath.empty()) {
            this.path.add(tempPath.pop());
        }
        return this.path;
    }

    public int getDistanceToGoal() {
        if (!this.success) {
            return -1;
        }
        return (Integer)this.pathCost.get(this.goalNode);
    }
}

