/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.vertexSpace.vertex3Dspace;

import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.extended.Vertex3D;
import cz.cuni.utils.math.vertexSpace.vertex3Dspace.Vertex3DFactory;
import cz.cuni.utils.math.vertexSpace.vertex3Dspace.Vertex3DFactoryInterface;
import cz.cuni.utils.math.vertexSpace.vertex3Dspace.Vertex3DSpaceCube;
import cz.cuni.utils.math.vertexSpace.vertex3Dspace.Vertex3DSpaceInterface;
import java.util.ArrayList;
import java.util.HashMap;

public class Vertex3DSpace
implements Vertex3DSpaceInterface {
    public static final int MAX_PRECISION = 15;
    public static final int MIN_PRECISION = 2;
    public static final int CUBE_SIZE_MULTI = 4;
    public final double[] cubeTranslation;
    public static final int[] CUBE_TRANSLATION = new int[]{3, 5, 7};
    public final Vertex3DFactoryInterface vertexFactory;
    public final double precision;
    public final int precisionInt;
    public final double cubeSize;
    protected HashMap cubes = new HashMap();
    private int number = 0;

    public Vertex3DSpace(Vertex3DFactoryInterface vf, int iPrecision) {
        this.vertexFactory = vf;
        if (iPrecision < 2) {
            iPrecision = 2;
        }
        if (iPrecision > 15) {
            iPrecision = 15;
        }
        this.precisionInt = iPrecision;
        this.precision = Math.pow(10.0, -iPrecision);
        this.cubeSize = 4.0 * this.precision;
        this.cubeTranslation = new double[]{(double)CUBE_TRANSLATION[0] * this.precision, (double)CUBE_TRANSLATION[1] * this.precision, (double)CUBE_TRANSLATION[2] * this.precision};
    }

    protected Vertex3DSpaceCube getCube(double x, double y, double z) {
        Vertex3DSpaceCube searchingFor = new Vertex3DSpaceCube(x, y, z, this.cubeSize, this.precisionInt);
        if (this.cubes.containsKey(searchingFor)) {
            return (Vertex3DSpaceCube)this.cubes.get(searchingFor);
        }
        this.cubes.put(searchingFor, searchingFor);
        return searchingFor;
    }

    public ArrayList getCubes(Tuple3D t) {
        ArrayList<Vertex3DSpaceCube> al = new ArrayList<Vertex3DSpaceCube>();
        double[] xyz = new double[]{Math.floor((t.xyz[0] + this.cubeTranslation[0]) / this.cubeSize) * this.cubeSize, Math.floor((t.xyz[1] + this.cubeTranslation[1]) / this.cubeSize) * this.cubeSize, Math.floor((t.xyz[2] + this.cubeTranslation[2]) / this.cubeSize) * this.cubeSize};
        al.add(this.getCube(xyz[0], xyz[1], xyz[2]));
        boolean[] near = new boolean[]{false, false, false, false, false, false};
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            near[2 * i] = xyz[i] - this.precision < t.xyz[i] + this.cubeTranslation[i] && xyz[i] + this.precision > t.xyz[i] + this.cubeTranslation[i];
            if (near[2 * i]) {
                ++count;
                continue;
            }
            near[2 * i + 1] = xyz[i] + this.cubeSize - this.precision < t.xyz[i] + this.cubeTranslation[i] && xyz[i] + this.cubeSize + this.precision > t.xyz[i] + this.cubeTranslation[i];
            if (!near[2 * i + 1]) continue;
            ++count;
        }
        if (count == 0) {
            return al;
        }
        if (near[0]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1], xyz[2]));
        }
        if (near[1]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1], xyz[2]));
        }
        if (near[2]) {
            al.add(this.getCube(xyz[0], xyz[1] - this.cubeSize, xyz[2]));
        }
        if (near[3]) {
            al.add(this.getCube(xyz[0], xyz[1] + this.cubeSize, xyz[2]));
        }
        if (near[4]) {
            al.add(this.getCube(xyz[0], xyz[1], xyz[2] - this.cubeSize));
        }
        if (near[5]) {
            al.add(this.getCube(xyz[0], xyz[1], xyz[2] + this.cubeSize));
        }
        if (count == 1) {
            return al;
        }
        if (near[0] && near[2]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1] - this.cubeSize, xyz[2]));
        }
        if (near[0] && near[4]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1], xyz[2] - this.cubeSize));
        }
        if (near[0] && near[3]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1] + this.cubeSize, xyz[2]));
        }
        if (near[0] && near[5]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1], xyz[2] + this.cubeSize));
        }
        if (near[1] && near[2]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1] - this.cubeSize, xyz[2]));
        }
        if (near[1] && near[4]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1], xyz[2] - this.cubeSize));
        }
        if (near[1] && near[3]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1] + this.cubeSize, xyz[2]));
        }
        if (near[1] && near[5]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1], xyz[2] + this.cubeSize));
        }
        if (near[2] && near[4]) {
            al.add(this.getCube(xyz[0], xyz[1] - this.cubeSize, xyz[2] - this.cubeSize));
        }
        if (near[2] && near[5]) {
            al.add(this.getCube(xyz[0], xyz[1] - this.cubeSize, xyz[2] + this.cubeSize));
        }
        if (near[3] && near[4]) {
            al.add(this.getCube(xyz[0], xyz[1] + this.cubeSize, xyz[2] - this.cubeSize));
        }
        if (near[3] && near[5]) {
            al.add(this.getCube(xyz[0], xyz[1] + this.cubeSize, xyz[2] + this.cubeSize));
        }
        if (count == 2) {
            return al;
        }
        if (near[0] && near[2] && near[4]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1] - this.cubeSize, xyz[2] - this.cubeSize));
        }
        if (near[1] && near[2] && near[4]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1] - this.cubeSize, xyz[2] - this.cubeSize));
        }
        if (near[0] && near[3] && near[4]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1] + this.cubeSize, xyz[2] - this.cubeSize));
        }
        if (near[1] && near[3] && near[4]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1] + this.cubeSize, xyz[2] - this.cubeSize));
        }
        if (near[0] && near[2] && near[5]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1] - this.cubeSize, xyz[2] + this.cubeSize));
        }
        if (near[1] && near[2] && near[5]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1] - this.cubeSize, xyz[2] + this.cubeSize));
        }
        if (near[0] && near[3] && near[5]) {
            al.add(this.getCube(xyz[0] - this.cubeSize, xyz[1] + this.cubeSize, xyz[2] + this.cubeSize));
        }
        if (near[1] && near[3] && near[5]) {
            al.add(this.getCube(xyz[0] + this.cubeSize, xyz[1] + this.cubeSize, xyz[2] + this.cubeSize));
        }
        return al;
    }

    public ArrayList getCubes(double x, double y, double z) {
        return this.getCubes(new Tuple3D(x, y, z));
    }

    public ArrayList getCubes(double[] xyz) {
        return this.getCubes(new Tuple3D(xyz));
    }

    public ArrayList checkVertices(Tuple3D t) {
        return this.checkVertices(t, this.getCubes(t));
    }

    public ArrayList checkVertices(double x, double y, double z) {
        Tuple3D t = new Tuple3D(x, y, z);
        return this.checkVertices(t, this.getCubes(t));
    }

    public ArrayList checkVertices(double[] xyz) {
        Tuple3D t = new Tuple3D(xyz);
        return this.checkVertices(t, this.getCubes(t));
    }

    public ArrayList checkVertices(Tuple3D t, ArrayList vertexSpaceCubes) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < vertexSpaceCubes.size(); ++i) {
            result.addAll(((Vertex3DSpaceCube)vertexSpaceCubes.get(i)).check(t));
        }
        for (int i = 0; i < result.size(); ++i) {
            Object vertex = result.get(0);
            int j = i + 1;
            while (j < result.size()) {
                if (vertex == result.get(j)) {
                    result.remove(j);
                    continue;
                }
                ++j;
            }
        }
        return result;
    }

    public Vertex3D get(Tuple3D t) {
        ++this.number;
        ArrayList cubesAL = this.getCubes(t);
        ArrayList verticesAL = this.checkVertices(t, cubesAL);
        if (verticesAL.size() > 1) {
            return null;
        }
        if (verticesAL.size() == 1) {
            return (Vertex3D)verticesAL.get(0);
        }
        Vertex3D v = this.vertexFactory.getNewInstance(t);
        for (int i = 0; i < cubesAL.size(); ++i) {
            ((Vertex3DSpaceCube)cubesAL.get(i)).addReferenceUnsafe(v);
        }
        return v;
    }

    public Vertex3D get(double x, double y, double z) {
        return this.get(new Tuple3D(x, y, z));
    }

    public Vertex3D get(double[] xyz) {
        return this.get(new Tuple3D(xyz));
    }

    public void set(Vertex3D v) {
        ArrayList cubesAL = this.getCubes(v);
        for (int i = 0; i < cubesAL.size(); ++i) {
            ((Vertex3DSpaceCube)cubesAL.get(i)).addReferenceUnsafe(v);
        }
    }

    public void remove(Vertex3D v) {
        ArrayList cubesAL = this.getCubes(v);
        for (int i = 0; i < cubesAL.size(); ++i) {
            ((Vertex3DSpaceCube)cubesAL.get(i)).remove(v);
        }
    }

    public void clear() {
        this.cubes = new HashMap();
    }

    public static Vertex3D[] convert(Vertex3DSpace vs, Tuple3D[] array) {
        Vertex3D[] result = new Vertex3D[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = vs.get(array[i]);
        }
        return result;
    }

    public static void testArrays(Tuple3D[] first, Tuple3D[] same) {
        Vertex3DSpace vs = new Vertex3DSpace(new Vertex3DFactory(), 2);
        Vertex3D[] result1 = Vertex3DSpace.convert(vs, first);
        Vertex3D[] result2 = Vertex3DSpace.convert(vs, same);
        for (int i = 0; i < first.length; ++i) {
            System.out.print(first[i]);
            if (result1[i] == result2[i]) {
                System.out.print(" == ");
            } else {
                System.out.print(" != ");
            }
            System.out.print(same[i]);
            System.out.println();
        }
    }

    public static void main(String[] args) {
        Tuple3D[] first = new Tuple3D[]{new Tuple3D(1.0, 0.0, 0.0), new Tuple3D(0.0, 1.0, 0.0), new Tuple3D(0.0, 0.0, 1.0), new Tuple3D(1.0, 1.0, 0.0), new Tuple3D(0.0, 1.0, 1.0), new Tuple3D(1.0, 0.0, 1.0), new Tuple3D(1.0, 1.0, 1.0)};
        Tuple3D[] same = new Tuple3D[first.length];
        first = new Tuple3D[]{new Tuple3D(1.395, 0.02, 0.02), new Tuple3D(0.02, 1.395, 0.02), new Tuple3D(0.02, 0.02, 1.395), new Tuple3D(1.395, 1.395, 0.02), new Tuple3D(0.02, 1.395, 1.395), new Tuple3D(1.0, 0.02, 1.395), new Tuple3D(1.395, 1.395, 1.395)};
        for (int i = 2; i < 4; ++i) {
            double add = Math.pow(-1.0, i) * 0.003;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int l = 0; l < 3; ++l) {
                        for (int m = 0; m < first.length; ++m) {
                            Tuple3D temp = new Tuple3D(first[m]);
                            int n = j;
                            temp.xyz[n] = temp.xyz[n] + add;
                            int n2 = k;
                            temp.xyz[n2] = temp.xyz[n2] + add;
                            int n3 = l;
                            temp.xyz[n3] = temp.xyz[n3] + add;
                            same[m] = temp;
                        }
                        Vertex3DSpace.testArrays(first, same);
                    }
                }
            }
        }
    }
}

