/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.vertexSpace.vertex2Dspace;

import cz.cuni.utils.math.Tuple2D;
import cz.cuni.utils.math.extended.Vertex2D;
import cz.cuni.utils.math.vertexSpace.vertex2Dspace.Vertex2DFactory;
import cz.cuni.utils.math.vertexSpace.vertex2Dspace.Vertex2DFactoryInterface;
import cz.cuni.utils.math.vertexSpace.vertex2Dspace.Vertex2DSpaceInterface;
import cz.cuni.utils.math.vertexSpace.vertex2Dspace.Vertex2DSpaceSquare;
import java.util.ArrayList;
import java.util.HashMap;

public class Vertex2DSpace
implements Vertex2DSpaceInterface {
    public static final int MAX_PRECISION = 15;
    public static final int MIN_PRECISION = 2;
    public static final int SQUARE_SIZE_MULTI = 4;
    public final double[] squareTranslation;
    public static final int[] SQUARE_TRANSLATION = new int[]{3, 7};
    public final Vertex2DFactoryInterface vertexFactory;
    public final double precision;
    public final int precisionInt;
    public final double squareSize;
    protected HashMap squares = new HashMap();
    private int number = 0;

    public Vertex2DSpace(Vertex2DFactoryInterface vf, int iPrecision) {
        this.vertexFactory = vf;
        if (iPrecision < 2) {
            iPrecision = 2;
        }
        if (iPrecision > 15) {
            iPrecision = 15;
        }
        this.precisionInt = iPrecision;
        this.precision = Math.pow(10.0, -iPrecision);
        this.squareSize = 4.0 * this.precision;
        this.squareTranslation = new double[]{(double)SQUARE_TRANSLATION[0] * this.precision, (double)SQUARE_TRANSLATION[1] * this.precision};
    }

    protected Vertex2DSpaceSquare getSquare(double x, double y) {
        Vertex2DSpaceSquare searchingFor = new Vertex2DSpaceSquare(x, y, this.squareSize, this.precisionInt);
        if (this.squares.containsKey(searchingFor)) {
            return (Vertex2DSpaceSquare)this.squares.get(searchingFor);
        }
        this.squares.put(searchingFor, searchingFor);
        return searchingFor;
    }

    public ArrayList getSquares(Tuple2D t) {
        ArrayList<Vertex2DSpaceSquare> al = new ArrayList<Vertex2DSpaceSquare>();
        double[] xy = new double[]{Math.floor((t.xy[0] + this.squareTranslation[0]) / this.squareSize) * this.squareSize, Math.floor((t.xy[1] + this.squareTranslation[1]) / this.squareSize) * this.squareSize};
        al.add(this.getSquare(xy[0], xy[1]));
        boolean[] near = new boolean[]{false, false, false, false};
        int count = 0;
        for (int i = 0; i < 2; ++i) {
            near[2 * i] = xy[i] - this.precision < t.xy[i] + this.squareTranslation[i] && xy[i] + this.precision > t.xy[i] + this.squareTranslation[i];
            if (near[2 * i]) {
                ++count;
                continue;
            }
            near[2 * i + 1] = xy[i] + this.squareSize - this.precision < t.xy[i] + this.squareTranslation[i] && xy[i] + this.squareSize + this.precision > t.xy[i] + this.squareTranslation[i];
            if (!near[2 * i + 1]) continue;
            ++count;
        }
        if (count == 0) {
            return al;
        }
        if (near[0]) {
            al.add(this.getSquare(xy[0] - this.squareSize, xy[1]));
        }
        if (near[1]) {
            al.add(this.getSquare(xy[0] + this.squareSize, xy[1]));
        }
        if (near[2]) {
            al.add(this.getSquare(xy[0], xy[1] - this.squareSize));
        }
        if (near[3]) {
            al.add(this.getSquare(xy[0], xy[1] + this.squareSize));
        }
        if (count == 1) {
            return al;
        }
        if (near[0] && near[2]) {
            al.add(this.getSquare(xy[0] - this.squareSize, xy[1] - this.squareSize));
        }
        if (near[0] && near[3]) {
            al.add(this.getSquare(xy[0] - this.squareSize, xy[1] + this.squareSize));
        }
        if (near[1] && near[2]) {
            al.add(this.getSquare(xy[0] + this.squareSize, xy[1] - this.squareSize));
        }
        if (near[1] && near[3]) {
            al.add(this.getSquare(xy[0] + this.squareSize, xy[1] + this.squareSize));
        }
        return al;
    }

    public ArrayList getCubes(double x, double y) {
        return this.getSquares(new Tuple2D(x, y));
    }

    public ArrayList getCubes(double[] xy) {
        return this.getSquares(new Tuple2D(xy));
    }

    public ArrayList checkVertices(Tuple2D t) {
        return this.checkVertices(t, this.getSquares(t));
    }

    public ArrayList checkVertices(double x, double y) {
        Tuple2D t = new Tuple2D(x, y);
        return this.checkVertices(t, this.getSquares(t));
    }

    public ArrayList checkVertices(double[] xy) {
        Tuple2D t = new Tuple2D(xy);
        return this.checkVertices(t, this.getSquares(t));
    }

    public ArrayList checkVertices(Tuple2D t, ArrayList vertexSpaceCubes) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < vertexSpaceCubes.size(); ++i) {
            result.addAll(((Vertex2DSpaceSquare)vertexSpaceCubes.get(i)).check(t));
        }
        for (int i = 0; i < result.size(); ++i) {
            Object vertex = result.get(0);
            int j = i + 1;
            while (j < result.size()) {
                if (vertex == result.get(j)) {
                    result.remove(j);
                    continue;
                }
                ++j;
            }
        }
        return result;
    }

    public Vertex2D get(Tuple2D t) {
        ++this.number;
        ArrayList cubesAL = this.getSquares(t);
        ArrayList verticesAL = this.checkVertices(t, cubesAL);
        if (verticesAL.size() > 1) {
            return null;
        }
        if (verticesAL.size() == 1) {
            return (Vertex2D)verticesAL.get(0);
        }
        Vertex2D v = this.vertexFactory.getNewInstance(t);
        for (int i = 0; i < cubesAL.size(); ++i) {
            ((Vertex2DSpaceSquare)cubesAL.get(i)).addReferenceUnsafe(v);
        }
        return v;
    }

    public Vertex2D get(double x, double y) {
        return this.get(new Tuple2D(x, y));
    }

    public Vertex2D get(double[] xy) {
        return this.get(new Tuple2D(xy));
    }

    public void set(Vertex2D v) {
        ArrayList cubesAL = this.getSquares(v);
        for (int i = 0; i < cubesAL.size(); ++i) {
            ((Vertex2DSpaceSquare)cubesAL.get(i)).addReferenceUnsafe(v);
        }
    }

    public void remove(Vertex2D v) {
        ArrayList squaresAL = this.getSquares(v);
        for (int i = 0; i < squaresAL.size(); ++i) {
            ((Vertex2DSpaceSquare)squaresAL.get(i)).remove(v);
        }
    }

    public void clear() {
        this.squares = new HashMap();
    }

    public static Vertex2D[] convert(Vertex2DSpace vs, Tuple2D[] array) {
        Vertex2D[] result = new Vertex2D[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = vs.get(array[i]);
        }
        return result;
    }

    public static void testArrays(Tuple2D[] first, Tuple2D[] same) {
        Vertex2DSpace vs = new Vertex2DSpace(new Vertex2DFactory(), 2);
        Vertex2D[] result1 = Vertex2DSpace.convert(vs, first);
        Vertex2D[] result2 = Vertex2DSpace.convert(vs, same);
        for (int i = 0; i < first.length; ++i) {
            System.out.print(first[i]);
            if (result1[i] == result2[i]) {
                System.out.print(" == ");
            } else {
                System.out.print(" != ");
            }
            System.out.print(same[i]);
            System.out.println();
        }
    }

    public static void main(String[] args) {
        Tuple2D[] first = new Tuple2D[]{new Tuple2D(1.0, 0.0), new Tuple2D(0.0, 1.0), new Tuple2D(1.0, 1.0)};
        Tuple2D[] same = new Tuple2D[first.length];
        first = new Tuple2D[]{new Tuple2D(1.395, 0.02), new Tuple2D(0.02, 1.395), new Tuple2D(1.395, 1.395)};
        for (int i = 2; i < 4; ++i) {
            double add = Math.pow(-1.0, i) * 0.003;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int m = 0; m < first.length; ++m) {
                        Tuple2D temp = new Tuple2D(first[m]);
                        int n = j;
                        temp.xy[n] = temp.xy[n] + add;
                        int n2 = k;
                        temp.xy[n2] = temp.xy[n2] + add;
                        same[m] = temp;
                    }
                    Vertex2DSpace.testArrays(first, same);
                }
            }
        }
    }
}

