/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.extended;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.errorlog.ErrorLog;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple2D;
import cz.cuni.utils.math.extended.Segment2D;
import cz.cuni.utils.math.extended.Vertex2D;
import java.util.HashMap;
import java.util.Iterator;

public class Triangle2D {
    public Vertex2D[] vertices = new Vertex2D[]{null, null, null};
    protected HashMap verticesHM = new HashMap();
    public double[] min = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
    public double[] max = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
    public final int hashCode;

    protected void init() {
    }

    protected void initVertices(Vertex2D v1, Vertex2D v2, Vertex2D v3) {
        this.setVertexAndHS(0, v1);
        this.setVertexAndHS(1, v2);
        this.setVertexAndHS(2, v3);
        this.recountMinMax();
    }

    protected void initVerticesFromEdges(Segment2D s1, Segment2D s2, Segment2D s3) {
        this.verticesHM.put(s1.ab[0], 0);
        this.verticesHM.put(s1.ab[1], 0);
        if (!this.verticesHM.containsKey(s2.ab[0])) {
            this.verticesHM.put(s2.ab[0], 0);
        }
        if (!this.verticesHM.containsKey(s2.ab[1])) {
            this.verticesHM.put(s2.ab[1], 0);
        }
        if (!this.verticesHM.containsKey(s3.ab[0])) {
            this.verticesHM.put(s3.ab[0], 0);
        }
        if (!this.verticesHM.containsKey(s3.ab[1])) {
            this.verticesHM.put(s3.ab[1], 0);
        }
        if (this.verticesHM.size() != 3) {
            ErrorLog.add("Triangle2D.Triangle(edge, edge, edge): wrong edges, they don't form an triangle.", 2);
        }
        Iterator iter = this.verticesHM.keySet().iterator();
        this.setVertex(0, (Vertex2D)iter.next());
        this.setVertex(1, (Vertex2D)iter.next());
        this.setVertex(2, (Vertex2D)iter.next());
        this.recountMinMax();
    }

    public Triangle2D(Vertex2D v1, Vertex2D v2, Vertex2D v3) {
        this.init();
        this.initVertices(v1, v2, v3);
        this.hashCode = this.countHashCode();
    }

    public Triangle2D(Segment2D s1, Segment2D s2, Segment2D s3) {
        this.init();
        this.initVerticesFromEdges(s1, s2, s3);
        this.hashCode = this.countHashCode();
    }

    public String toString() {
        return "Triagle2D(" + this.vertices[0] + ", " + this.vertices[1] + ", " + this.vertices[2] + ")";
    }

    protected int countHashCode() {
        boolean v01 = M.equals(this.vertices[0], this.vertices[1]);
        boolean v02 = M.equals(this.vertices[0], this.vertices[2]);
        if (v01 && v02) {
            return 0;
        }
        boolean v12 = M.equals(this.vertices[1], this.vertices[2]);
        if (v01 || v02 || v12) {
            return 1;
        }
        if (M.isCollinear(this.vertices[0], this.vertices[1], this.vertices[2])) {
            return 1;
        }
        HashCodes hc = HashCodes.getNewCounter();
        Vertex2D[] o01 = M.normalizedOrder(this.vertices[0], this.vertices[1]);
        Vertex2D[] o02 = M.normalizedOrder(this.vertices[0], this.vertices[2]);
        Vertex2D[] o12 = M.normalizedOrder(this.vertices[1], this.vertices[2]);
        if (o01[0] == o02[0]) {
            hc.add(HashCodes.hash(this.vertices[0]));
            hc.add(HashCodes.hash(o12[0]));
            hc.add(HashCodes.hash(o12[1]));
        } else if (o01[0] == o12[0]) {
            hc.add(HashCodes.hash(this.vertices[1]));
            hc.add(HashCodes.hash(o02[0]));
            hc.add(HashCodes.hash(o02[1]));
        } else {
            hc.add(HashCodes.hash(this.vertices[2]));
            hc.add(HashCodes.hash(o01[0]));
            hc.add(HashCodes.hash(o01[1]));
        }
        return hc.getHashCode();
    }

    protected void setVertexAndHS(int index, Vertex2D vertex) {
        this.verticesHM.remove(this.vertices[index]);
        this.vertices[index] = vertex;
        this.verticesHM.put(vertex, index);
    }

    protected void setVertex(int index, Vertex2D vertex) {
        this.vertices[index] = vertex;
    }

    public Vertex2D getVertex2D(int index) {
        return this.vertices[index];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Triangle2D)) {
            return false;
        }
        Triangle2D t = (Triangle2D)o;
        return this.verticesHM.containsKey(t.vertices[0]) && this.verticesHM.containsKey(t.vertices[1]) && this.verticesHM.containsKey(t.vertices[2]);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected void checkMinMax(Vertex2D v) {
        for (int i = 0; i < 2; ++i) {
            if (v.xy[i] < this.min[i]) {
                this.min[i] = v.xy[i];
            }
            if (!(v.xy[i] > this.max[i])) continue;
            this.max[i] = v.xy[i];
        }
    }

    protected void recountMinMax() {
        this.min[0] = Double.POSITIVE_INFINITY;
        this.min[1] = Double.POSITIVE_INFINITY;
        this.max[0] = Double.NEGATIVE_INFINITY;
        this.max[1] = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 2; ++i) {
            this.checkMinMax(this.vertices[i]);
        }
    }

    public boolean hasVertex(Vertex2D v) {
        return this.verticesHM.containsKey(v);
    }

    public boolean swapVertex(Vertex2D toBeSwapped, Vertex2D newVertex) {
        if (this.verticesHM.containsKey(toBeSwapped)) {
            this.setVertex((Integer)this.verticesHM.get(toBeSwapped), newVertex);
            return true;
        }
        return false;
    }

    public Tuple2D getOrthocenter() {
        Tuple2D middle = new Tuple2D(0.0, 0.0);
        for (int i = 0; i < 3; ++i) {
            middle.plus(this.vertices[i]);
        }
        middle = M.multi(middle, 0.3333333333333333);
        return middle;
    }
}

