/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.extended;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.Line3D;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple3D;

public class Line3DExtended
extends Line3D {
    public final int hashCode;

    protected void initLine() {
        this.direction = M.normalizedNormalTestZero(this.direction);
        this.point = this.getCommonPoint();
    }

    public Line3DExtended(Line3D line) {
        super(line.direction, line.point);
        this.initLine();
        this.hashCode = this.countHashCode();
    }

    public Line3DExtended(Tuple3D iDirection, Tuple3D iPoint) {
        super(iDirection, iPoint);
        this.initLine();
        this.hashCode = this.countHashCode();
    }

    protected int countHashCode() {
        HashCodes hc = HashCodes.getNewCounter();
        for (int i = 0; i < 3; ++i) {
            hc.add(HashCodes.hash(M.doubleToLong(this.direction.xyz[i])));
            hc.add(HashCodes.hash(M.doubleToLong(this.point.xyz[i])));
        }
        return hc.getHashCode();
    }

    public boolean equals(Line3DExtended line) {
        return line.inLine(this.point) && this.direction.equals(line.direction);
    }

    public static Line3DExtended line3D(Tuple3D pointA, Tuple3D pointB) {
        return new Line3DExtended(new Tuple3D(pointA, pointB), pointA);
    }

    public String toString() {
        return "Line3DExtended(" + this.point + ", <-> " + this.direction + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }
}

