/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Plane3D;
import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.extended.Vertex3D;
import java.util.AbstractList;
import java.util.ArrayList;

public class Polygon3D {
    public ArrayList vertices = new ArrayList();
    protected Plane3D plane = null;
    public double[] min = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
    public double[] max = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};

    public Polygon3D() {
    }

    public Polygon3D(Vertex3D[] iVertices) {
        this.vertices = new ArrayList();
        for (int i = 0; i < iVertices.length; ++i) {
            this.add(iVertices[i]);
        }
    }

    public Polygon3D(Vertex3D[] iVertices, Tuple3D normal) {
        this.vertices = new ArrayList();
        for (int i = 0; i < iVertices.length; ++i) {
            this.add(iVertices[i]);
        }
        this.recountPlane(normal);
    }

    public Polygon3D(AbstractList iVertices) {
        this.vertices = new ArrayList();
        int size = iVertices.size();
        for (int i = 0; i < size; ++i) {
            this.add((Vertex3D)iVertices.get(i));
        }
    }

    public Polygon3D(ArrayList iVertices) {
        this.vertices = iVertices;
    }

    public Polygon3D(Polygon3D p) {
        this.vertices = new ArrayList();
        int size = p.size();
        for (int i = 0; i < size; ++i) {
            this.add(new Vertex3D(p.get(i)));
        }
        this.recountPlane();
        if (!M.sameWay(p.plane.normal, this.plane.normal)) {
            Tuple3D newNormal = this.plane.normal.getInverse();
            this.recountPlane(newNormal);
        }
    }

    protected void checkAddMinMax(Vertex3D v) {
        for (int i = 0; i < 3; ++i) {
            if (v.xyz[i] < this.min[i]) {
                this.min[i] = v.xyz[i];
            }
            if (!(v.xyz[i] > this.max[i])) continue;
            this.max[i] = v.xyz[i];
        }
    }

    protected void checkRemoveMinMax(Vertex3D v) {
        boolean recount = false;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(v.xyz[i] - this.min[i]) < M.EPSILON)) continue;
            recount = true;
            break;
        }
        if (recount) {
            this.recountMinMax();
        }
    }

    protected void recountMinMax() {
        this.min[0] = Double.POSITIVE_INFINITY;
        this.min[1] = Double.POSITIVE_INFINITY;
        this.min[2] = Double.POSITIVE_INFINITY;
        this.max[0] = Double.NEGATIVE_INFINITY;
        this.max[1] = Double.NEGATIVE_INFINITY;
        this.max[2] = Double.NEGATIVE_INFINITY;
        int size = this.vertices.size();
        for (int i = 0; i < size; ++i) {
            this.checkAddMinMax((Vertex3D)this.vertices.get(i));
        }
    }

    public void add(Vertex3D v) {
        this.vertices.add(v);
        this.checkAddMinMax(v);
    }

    public int size() {
        return this.vertices.size();
    }

    public Vertex3D get(int index) {
        return (Vertex3D)this.vertices.get(index);
    }

    public void swapVertex(int index, Vertex3D newVertex) {
        this.vertices.set(index, newVertex);
    }

    public int getCircularIndex(int index) {
        int verticesSize = this.vertices.size();
        if (index < 0) {
            index += verticesSize * (1 + Math.abs(index) / verticesSize);
            return index;
        }
        if (index >= verticesSize) {
            index -= verticesSize * (index / verticesSize);
            return index;
        }
        return index;
    }

    public Vertex3D getCircular(int index) {
        return this.get(this.getCircularIndex(index));
    }

    public Vertex3D remove(int index) {
        return (Vertex3D)this.vertices.remove(index);
    }

    public boolean remove(Vertex3D v) {
        return this.vertices.remove(v);
    }

    public boolean recountPlane() {
        if (this.vertices.size() > 2) {
            Vertex3D v1 = (Vertex3D)this.vertices.get(0);
            Vertex3D v2 = (Vertex3D)this.vertices.get(1);
            Vertex3D v3 = (Vertex3D)this.vertices.get(2);
            this.plane = new Plane3D(v1, v2, v3);
            return true;
        }
        return false;
    }

    public boolean recountPlane(Tuple3D normal) {
        if (this.vertices.size() > 0) {
            this.plane = new Plane3D(normal, (Vertex3D)this.vertices.get(0));
            return true;
        }
        return false;
    }

    public Plane3D getPlane() {
        if (this.plane == null) {
            this.recountPlane();
        }
        return this.plane;
    }

    public Tuple3D getNormal() {
        return this.plane.normal;
    }

    public void deleteColinear() {
        this.deleteColinear(M.EPSILON);
    }

    public void deleteColinear(double precision) {
        Vertex3D pointC;
        int i;
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        int verticesSize = this.vertices.size();
        Vertex3D pointA = this.get(0);
        Vertex3D pointB = this.get(1);
        for (i = 2; i < verticesSize; ++i) {
            pointC = this.get(i);
            if (M.isCollinear(pointA, pointB, pointC, precision)) {
                toDelete.add(i - 1);
            }
            pointA = pointB;
            pointB = pointC;
        }
        for (i = 0; i < 2; ++i) {
            pointC = this.get(i);
            if (M.isCollinear(pointA, pointB, pointC, precision)) {
                toDelete.add(i - 1);
            }
            pointA = pointB;
            pointB = pointC;
        }
        int toDeleteSize = toDelete.size();
        for (i = 0; i < toDeleteSize; ++i) {
            this.vertices.remove((Integer)toDelete.get(i));
        }
    }

    public Tuple3D getEstimatedMiddlePoint() {
        int size = this.vertices.size();
        Tuple3D middle = new Tuple3D(0.0, 0.0, 0.0);
        for (int i = 0; i < size; ++i) {
            middle.plus((Tuple3D)this.vertices.get(i));
        }
        middle = M.multi(middle, 1.0 / (double)size);
        return middle;
    }
}

