/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.Line3D;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.Tuple4D;

public class Plane3D {
    public Tuple3D normal;
    public Tuple4D t4d;

    public Plane3D() {
        this.t4d = null;
    }

    public Plane3D(double x, double y, double z, double d) {
        this.t4d = new Tuple4D(x, y, z, d);
        this.normal = new Tuple3D(x, y, z);
    }

    public String toString() {
        return "Plane3D(" + this.t4d.xyzd[0] + "x+" + this.t4d.xyzd[1] + "y+" + this.t4d.xyzd[2] + "z+" + this.t4d.xyzd[3] + ")";
    }

    public Plane3D(Tuple3D iNormal, double d) {
        this.normal = new Tuple3D(iNormal);
        this.t4d = new Tuple4D(this.normal.xyz[0], this.normal.xyz[1], this.normal.xyz[2], d);
    }

    public Plane3D(Tuple3D iNormal, Tuple3D point) {
        this.normal = new Tuple3D(iNormal);
        this.t4d = new Tuple4D(this.normal.xyz[0], this.normal.xyz[1], this.normal.xyz[2], -this.normal.xyz[0] * point.xyz[0] - this.normal.xyz[1] * point.xyz[1] - this.normal.xyz[2] * point.xyz[2]);
    }

    public Plane3D(Tuple3D a, Tuple3D b, Tuple3D c) {
        Tuple3D vec1 = M.vector(a, b);
        Tuple3D vec2 = M.vector(c, b);
        this.normal = M.multi(vec1, vec2).normalize();
        this.t4d = new Tuple4D(this.normal.xyz[0], this.normal.xyz[1], this.normal.xyz[2], -this.normal.xyz[0] * a.xyz[0] - this.normal.xyz[1] * a.xyz[1] - this.normal.xyz[2] * a.xyz[2]);
    }

    public Plane3D(Plane3D a) {
        this.normal = new Tuple3D(a.normal);
        this.t4d = new Tuple4D(a.t4d);
    }

    public void countPlane(Tuple3D iNormal, double d) {
        this.normal = new Tuple3D(iNormal);
        this.t4d = new Tuple4D(this.normal.xyz[0], this.normal.xyz[1], this.normal.xyz[2], d);
    }

    public void countPlane(Tuple3D iNormal, Tuple3D point) {
        this.normal = new Tuple3D(iNormal);
        this.t4d = new Tuple4D(this.normal.xyz[0], this.normal.xyz[1], this.normal.xyz[2], -this.normal.xyz[0] * point.xyz[0] - this.normal.xyz[1] * point.xyz[1] - this.normal.xyz[2] * point.xyz[2]);
    }

    public void countPlane(Tuple3D a, Tuple3D b, Tuple3D c) {
        this.normal = M.multi(M.vector(a, b), M.vector(b, c));
        this.t4d = new Tuple4D(this.normal.xyz[0], this.normal.xyz[1], this.normal.xyz[2], -this.normal.xyz[0] * a.xyz[0] - this.normal.xyz[1] * a.xyz[1] - this.normal.xyz[2] * a.xyz[2]);
    }

    public void recountPlane(Tuple3D newNormal) {
        this.countPlane(newNormal, this.getCommonPoint());
    }

    public Tuple3D getCommonPoint() {
        if (!M.equals(this.t4d.xyzd[0], 0.0)) {
            return new Tuple3D((-this.t4d.xyzd[1] - this.t4d.xyzd[2] - this.t4d.xyzd[3]) / this.t4d.xyzd[0], 1.0, 1.0);
        }
        if (!M.equals(this.t4d.xyzd[1], 0.0)) {
            return new Tuple3D(1.0, (-this.t4d.xyzd[0] - this.t4d.xyzd[2] - this.t4d.xyzd[3]) / this.t4d.xyzd[1], 1.0);
        }
        if (!M.equals(this.t4d.xyzd[2], 0.0)) {
            return new Tuple3D(1.0, 1.0, (-this.t4d.xyzd[0] - this.t4d.xyzd[1] - this.t4d.xyzd[3]) / this.t4d.xyzd[2]);
        }
        return null;
    }

    public Tuple3D getCommonPoint(double arg) {
        if (!M.equals(this.t4d.xyzd[0], 0.0)) {
            return new Tuple3D((-arg * this.t4d.xyzd[1] - arg * this.t4d.xyzd[2] - this.t4d.xyzd[3]) / this.t4d.xyzd[0], arg, arg);
        }
        if (!M.equals(this.t4d.xyzd[1], 0.0)) {
            return new Tuple3D(arg, (-arg * this.t4d.xyzd[0] - arg * this.t4d.xyzd[2] - this.t4d.xyzd[3]) / this.t4d.xyzd[1], arg);
        }
        if (!M.equals(this.t4d.xyzd[2], 0.0)) {
            return new Tuple3D(arg, arg, (-arg * this.t4d.xyzd[0] - arg * this.t4d.xyzd[1] - this.t4d.xyzd[3]) / this.t4d.xyzd[2]);
        }
        return null;
    }

    public Tuple3D getCommonVector() {
        return new Tuple3D(this.getCommonPoint(1.0), this.getCommonPoint(2.0));
    }

    public Line3D getCommonLine() {
        return Line3D.line3D(this.getCommonPoint(1.0), this.getCommonPoint(2.0));
    }

    public Tuple3D project(Tuple3D point) {
        double t = (-this.t4d.xyzd[3] - this.normal.xyz[0] * point.xyz[0] - this.normal.xyz[1] * point.xyz[1] - this.normal.xyz[2] * point.xyz[2]) / this.normal.sqrLength();
        return new Tuple3D(point.xyz[0] + this.normal.xyz[0] * t, point.xyz[1] + this.normal.xyz[1] * t, point.xyz[2] + this.normal.xyz[2] * t);
    }

    public double distance(Tuple3D point) {
        return new Tuple3D(point, this.project(point)).length();
    }

    public boolean inPlane(Tuple3D point) {
        return this.distance(point) < M.EPSILON;
    }

    public Tuple3D perpendicularVector(Tuple3D vectorInPlane) {
        return M.multi(vectorInPlane, this.normal);
    }

    public void inverseNormal() {
        this.normal.inverse();
        this.t4d.xyzd[0] = -this.t4d.xyzd[0];
        this.t4d.xyzd[1] = -this.t4d.xyzd[1];
        this.t4d.xyzd[2] = -this.t4d.xyzd[2];
    }
}

