/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.extended.Line3DExtended;

public class Line3D {
    public Tuple3D direction;
    public Tuple3D point;

    public Line3D() {
        this.direction = null;
        this.point = null;
    }

    public Line3D(Tuple3D iDirection, Tuple3D iPoint) {
        this.direction = new Tuple3D(iDirection);
        this.point = new Tuple3D(iPoint);
    }

    public String toString() {
        return "Line3D(" + this.point + ", <-> " + this.direction + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Line3D)) {
            return false;
        }
        return this.equals((Line3D)o);
    }

    public boolean equals(Line3D line) {
        Line3DExtended thisLine = new Line3DExtended(this);
        Line3DExtended lineExt = new Line3DExtended(line);
        return thisLine.equals(lineExt);
    }

    public boolean equals(Line3DExtended line) {
        Line3DExtended thisLine = new Line3DExtended(this);
        return thisLine.equals(line);
    }

    public static Line3D line3D(Tuple3D pointA, Tuple3D pointB) {
        return new Line3D(new Tuple3D(pointA, pointB), pointA);
    }

    public void assign(Tuple3D iDirection, Tuple3D iPoint) {
        this.direction = iDirection;
        this.point = iPoint;
    }

    public void countLine(Tuple3D pointA, Tuple3D pointB) {
        this.direction = new Tuple3D(pointA, pointB);
        this.point = new Tuple3D(pointA);
    }

    public Tuple3D getCommonPoint() {
        if (!M.equals(this.direction.xyz[0], 0.0)) {
            double t = M.linearEq(this.direction.xyz[0], this.point.xyz[0], 1.0);
            return new Tuple3D(1.0, this.direction.xyz[1] * t + this.point.xyz[1], this.direction.xyz[2] * t + this.point.xyz[2]);
        }
        if (!M.equals(this.direction.xyz[1], 0.0)) {
            double t = M.linearEq(this.direction.xyz[1], this.point.xyz[1], 1.0);
            return new Tuple3D(this.direction.xyz[0] * t + this.point.xyz[0], 1.0, this.direction.xyz[2] * t + this.point.xyz[2]);
        }
        if (!M.equals(this.direction.xyz[2], 0.0)) {
            double t = M.linearEq(this.direction.xyz[2], this.point.xyz[2], 1.0);
            return new Tuple3D(this.direction.xyz[0] * t + this.point.xyz[0], this.direction.xyz[1] * t + this.point.xyz[1], 1.0);
        }
        return new Tuple3D(0.0, 0.0, 0.0);
    }

    public boolean inLine(Tuple3D testedPoint) {
        return this.inLine(testedPoint, M.EPSILON);
    }

    public boolean inLine(Tuple3D testedPoint, double precision) {
        if (!M.equals(this.direction.xyz[0], 0.0)) {
            double t = M.linearEq(this.direction.xyz[0], this.point.xyz[0], testedPoint.xyz[0]);
            double res1 = this.direction.xyz[1] * t + this.point.xyz[1];
            double res2 = this.direction.xyz[2] * t + this.point.xyz[2];
            return M.equals(testedPoint.xyz[1], res1, precision) && M.equals(testedPoint.xyz[2], res2, precision);
        }
        if (!M.equals(this.direction.xyz[1], 0.0)) {
            double t = M.linearEq(this.direction.xyz[1], this.point.xyz[1], testedPoint.xyz[1]);
            double res0 = this.direction.xyz[0] * t + this.point.xyz[0];
            double res2 = this.direction.xyz[2] * t + this.point.xyz[2];
            return M.equals(testedPoint.xyz[0], res0, precision) && M.equals(testedPoint.xyz[2], res2, precision);
        }
        if (!M.equals(this.direction.xyz[2], 0.0)) {
            double t = M.linearEq(this.direction.xyz[2], this.point.xyz[2], testedPoint.xyz[2]);
            double res0 = this.direction.xyz[0] * t + this.point.xyz[0];
            double res1 = this.direction.xyz[1] * t + this.point.xyz[1];
            return M.equals(testedPoint.xyz[0], res0, precision) && M.equals(testedPoint.xyz[1], res1, precision);
        }
        return false;
    }
}

