/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple3D;

public class HalfLine3D {
    public Tuple3D direction;
    public Tuple3D pointBegin;
    public Tuple3D pointDirection;

    public HalfLine3D(Tuple3D iPointBegin, Tuple3D iPointDirection) {
        this.pointBegin = iPointBegin;
        this.pointDirection = iPointDirection;
        this.direction = new Tuple3D(iPointDirection, iPointBegin);
    }

    public String toString() {
        return "HalfLine3D(" + this.pointBegin + ", " + this.pointDirection + ")";
    }

    public boolean inHalfLine(Tuple3D testedPoint) {
        return this.inHalfLine(testedPoint, M.EPSILON);
    }

    public boolean inHalfLine(Tuple3D testedPoint, double precision) {
        if (!M.equals(this.direction.xyz[0], 0.0)) {
            double t = M.linearEq(this.direction.xyz[0], this.pointBegin.xyz[0], testedPoint.xyz[0]);
            if (t < 0.0) {
                return false;
            }
            double res1 = this.direction.xyz[1] * t + this.pointBegin.xyz[1];
            double res2 = this.direction.xyz[2] * t + this.pointBegin.xyz[2];
            return M.equals(testedPoint.xyz[1], res1, precision) && M.equals(testedPoint.xyz[2], res2, precision);
        }
        if (!M.equals(this.direction.xyz[1], 0.0)) {
            double t = M.linearEq(this.direction.xyz[1], this.pointBegin.xyz[1], testedPoint.xyz[1]);
            if (t < 0.0) {
                return false;
            }
            double res0 = this.direction.xyz[0] * t + this.pointBegin.xyz[0];
            double res2 = this.direction.xyz[2] * t + this.pointBegin.xyz[2];
            return M.equals(testedPoint.xyz[0], res0, precision) && M.equals(testedPoint.xyz[2], res2, precision);
        }
        if (!M.equals(this.direction.xyz[2], 0.0)) {
            double t = M.linearEq(this.direction.xyz[2], this.pointBegin.xyz[2], testedPoint.xyz[2]);
            if (t < 0.0) {
                return false;
            }
            double res0 = this.direction.xyz[0] * t + this.pointBegin.xyz[0];
            double res1 = this.direction.xyz[1] * t + this.pointBegin.xyz[1];
            return M.equals(testedPoint.xyz[0], res0, precision) && M.equals(testedPoint.xyz[1], res1, precision);
        }
        return false;
    }
}

