/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.utils.Config;
import cz.cuni.utils.DirectoryClassLoader;
import cz.cuni.utils.Settings;
import java.io.File;
import java.io.IOException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class PogamutPlatformClassLoader
extends DirectoryClassLoader {
    public static final String ENGINES_DIR = "scriptEngines";
    protected static ClassLoader instance = null;
    private static boolean changed = false;

    protected static File getPlatformDir() {
        String path = Config.getPlatformPath() + File.separator + ENGINES_DIR;
        return new File(path);
    }

    protected PogamutPlatformClassLoader() throws IOException {
        super(PogamutPlatformClassLoader.getPlatformDir());
        Preferences.userNodeForPackage(Agent.class).addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey().equals(Settings.Setting.PLATFORM_DIR.key)) {
                    PogamutPlatformClassLoader.setChanged(true);
                }
            }
        });
    }

    public static ClassLoader getInstance() {
        if (instance == null || PogamutPlatformClassLoader.isChanged()) {
            try {
                instance = new PogamutPlatformClassLoader();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                instance = ClassLoader.getSystemClassLoader();
            }
            PogamutPlatformClassLoader.setChanged(false);
        }
        return instance;
    }

    public static synchronized boolean isChanged() {
        return changed;
    }

    public static synchronized void setChanged(boolean aChanged) {
        changed = aChanged;
    }
}

