/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerManager {
    private HashMap<Object, Logger> owners = new HashMap();
    public static LoggerManager instance = new LoggerManager();

    private LoggerManager() {
    }

    public void setLevelToAll(Level level) {
        Iterator<Object> iterator = this.owners.keySet().iterator();
        while (iterator.hasNext()) {
            this.owners.get(iterator.next()).setLevel(level);
        }
    }

    public Logger getLoggerForObject(Object owner) {
        if (this.owners.containsKey(owner)) {
            return this.owners.get(owner);
        }
        return null;
    }

    public Logger getNewLoggerForObject(Object owner, String loggerName) {
        this.owners.put(owner, Logger.getLogger(loggerName));
        return this.owners.get(owner);
    }

    public Logger getNewLoggerForObject(Object owner) {
        this.owners.put(owner, Logger.getAnonymousLogger());
        return this.owners.get(owner);
    }

    public void logAll() {
        Iterator<Object> iterator = this.owners.keySet().iterator();
        while (iterator.hasNext()) {
            this.owners.get(iterator.next()).setLevel(Level.ALL);
        }
    }

    public void stopLogging() {
        Iterator<Object> iterator = this.owners.keySet().iterator();
        while (iterator.hasNext()) {
            this.owners.get(iterator.next()).setLevel(Level.OFF);
        }
    }
}

