/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.introspection.java;

import cz.cuni.pogamut.introspection.DefaultIntrospectableProxy;
import cz.cuni.pogamut.introspection.Introspectable;
import cz.cuni.pogamut.introspection.IntrospectableProxy;
import cz.cuni.pogamut.introspection.IntrospectableProxyChangeListener;
import cz.cuni.pogamut.introspection.PogProp;
import cz.cuni.pogamut.introspection.Property;
import cz.cuni.pogamut.introspection.java.JavaProperty;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReflectionProxy
extends DefaultIntrospectableProxy<Object> {
    private Set<IntrospectableProxyChangeListener> listeners = new HashSet<IntrospectableProxyChangeListener>();

    public JavaReflectionProxy(Object object) {
        super(object);
    }

    protected Collection<Property> getDeclaredProperties(Class cls, Object object) {
        Field[] fields;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Field field : fields = cls.getDeclaredFields()) {
            field.setAccessible(true);
            if (PropertyEditorManager.findEditor(field.getType()) == null || !field.isAnnotationPresent(PogProp.class)) continue;
            list.add(new JavaProperty(object, field));
        }
        return list;
    }

    protected Collection<IntrospectableProxy> getDeclaredProxies(Class cls, Object object) {
        Field[] fields;
        ArrayList<IntrospectableProxy> list = new ArrayList<IntrospectableProxy>();
        for (Field field : fields = cls.getFields()) {
            field.setAccessible(true);
            try {
                Introspectable intro;
                IntrospectableProxy proxy;
                Object obj = field.get(object);
                if (!Introspectable.class.isInstance(obj) || (proxy = (intro = (Introspectable)obj).getIntrospectableProxy()) == null) continue;
                list.add(proxy);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    @Override
    protected Property[] computeProperties(Object object) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Class<?> objClass = object.getClass(); objClass != null; objClass = objClass.getSuperclass()) {
            list.addAll(this.getDeclaredProperties(objClass, object));
        }
        return list.toArray(new Property[0]);
    }

    @Override
    protected IntrospectableProxy[] computeChildren(Object object) {
        ArrayList<IntrospectableProxy> list = new ArrayList<IntrospectableProxy>();
        for (Class<?> objClass = object.getClass(); objClass != null; objClass = objClass.getSuperclass()) {
            list.addAll(this.getDeclaredProxies(objClass, object));
        }
        return list.toArray(new IntrospectableProxy[0]);
    }

    @Override
    public void closeIntrospection() {
        this.listeners.clear();
    }
}

