/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter
implements Serializable {
    private String name = null;
    private Object value = null;

    public Parameter(String key, Object value) {
        this.name = key;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public static Parameter[] getParameters(Map map) {
        ArrayList<Parameter> params = new ArrayList<Parameter>(map.size());
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) continue;
            params.add(new Parameter((String)key, map.get(key)));
        }
        return params.toArray(new Parameter[0]);
    }

    public static Parameter[] getParametersCheckTypes(Map<Object, Object> map) {
        ArrayList<Parameter> params = new ArrayList<Parameter>(map.size());
        String value = null;
        Integer intValue = null;
        Double doubleValue = null;
        for (Object mapKey : map.keySet()) {
            value = map.get(mapKey).toString();
            if (value == null) {
                params.add(new Parameter((String)mapKey, null));
            }
            try {
                intValue = Integer.valueOf(value);
                params.add(new Parameter((String)mapKey, intValue));
            }
            catch (NumberFormatException e) {
                if (value.equalsIgnoreCase("true")) {
                    params.add(new Parameter((String)mapKey, new Boolean(true)));
                    continue;
                }
                if (value.equalsIgnoreCase("false")) {
                    params.add(new Parameter((String)mapKey, new Boolean(false)));
                    continue;
                }
                try {
                    doubleValue = Double.valueOf(value);
                    params.add(new Parameter((String)mapKey, doubleValue));
                }
                catch (NumberFormatException e2) {
                    params.add(new Parameter((String)mapKey, value));
                }
            }
        }
        return params.toArray(new Parameter[0]);
    }
}

