/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import cz.cuni.pogamut.experiments.ExecutorException;
import cz.cuni.pogamut.experiments.Experiment;
import cz.cuni.pogamut.experiments.ExperimentDescriptor;
import cz.cuni.pogamut.experiments.ExperimentExecutionState;
import cz.cuni.pogamut.experiments.LocalExperimentHandle;
import cz.cuni.pogamut.experiments.SerialExperimentExecutor;
import cz.cuni.pogamut.server.UTServer;
import cz.cuni.utils.FlagListener;

public class ExperimentsUTServer
extends SerialExperimentExecutor {
    protected UTServer server = null;
    protected Experiment actualExperiment = null;
    protected FlagListener<ExperimentExecutionState> experimentListener = null;

    protected ExperimentsUTServer(UTServer server) {
        this.server = server;
    }

    public static ExperimentsUTServer create(UTServer server) {
        return new ExperimentsUTServer(server);
    }

    protected boolean isActualExperimentRunning() {
        if (this.actualExperiment == null) {
            return false;
        }
        return !this.actualExperiment.getExperimentExecutionFlag().getFlag().isEndState();
    }

    public synchronized LocalExperimentHandle execute(ExperimentDescriptor experimentDescriptor) throws ExecutorException {
        Experiment experiment = experimentDescriptor.createExperiment(this.getServer());
        if (this.isActualExperimentRunning()) {
            throw new ExecutorException();
        }
        this.actualExperiment = experiment;
        this.experimentListener = new FlagListener<ExperimentExecutionState>(){

            @Override
            public void flagChanged(ExperimentExecutionState changedValue, int listenerParam) {
                if (changedValue != null && changedValue.isEndState()) {
                    ExperimentsUTServer.this.removeExperiment();
                }
            }
        };
        experiment.getExperimentExecutionFlag().addListener(this.experimentListener);
        experiment.runExperiment();
        return experiment;
    }

    protected void removeExperiment() {
        this.actualExperiment.getExperimentExecutionFlag().removeListener(this.experimentListener);
        this.experimentListener = null;
        this.actualExperiment = null;
    }

    public Experiment getActualExperiment() {
        return this.actualExperiment;
    }

    public UTServer getServer() {
        return this.server;
    }
}

