/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Parser;

import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.utils.ExceptionToString;
import cz.cuni.utils.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;

public class GameBotConnection {
    public static final String DEFAULT_ADDRESS = "localhost";
    public static final int DEFAULT_PORT = 3000;
    public static final int SOCKET_TIMEOUT = 10000;
    protected InetAddress serverAddress = null;
    protected int serverPort;
    private Socket socket = null;
    protected BufferedReader input = null;
    private PrintWriter output = null;
    private Logger log = null;
    private Logger rawDataLog = Logger.getAnonymousLogger();
    private BufferedReaderForLog readerForLog = null;

    public Logger getRawDataLog() {
        return this.rawDataLog;
    }

    public GameBotConnection(String netAddress, int port, Logger log) throws UnknownHostException {
        this(netAddress, port, log, null);
    }

    public GameBotConnection(String netAddress, int port, Logger log, Logger rawDataLog) throws UnknownHostException {
        this.serverAddress = InetAddress.getByName(netAddress);
        this.serverPort = port;
        this.log = log;
        this.log.setLevel(Level.ALL);
        this.rawDataLog = rawDataLog;
        if (rawDataLog != null) {
            this.rawDataLog.setLevel(Level.SEVERE);
        }
    }

    public GameBotConnection(String netAddress, int port) throws UnknownHostException {
        this(netAddress, port, Logger.getAnonymousLogger());
    }

    public GameBotConnection(String netAddress) throws UnknownHostException {
        this(netAddress, 3000, Logger.getAnonymousLogger());
    }

    public GameBotConnection(String netAddress, Logger rawDataLog) throws UnknownHostException {
        this(netAddress, 3000, Logger.getAnonymousLogger(), rawDataLog);
    }

    public GameBotConnection() throws UnknownHostException {
        this(DEFAULT_ADDRESS, 3000, Logger.getAnonymousLogger());
    }

    public void connect() throws ConnectException {
        try {
            this.log.info("Connecting to GB: " + this.serverAddress + ":" + this.serverPort);
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.serverAddress, this.serverPort), 10000);
            this.readerForLog = new BufferedReaderForLog(new InputStreamReader(this.socket.getInputStream()));
            this.input = this.readerForLog;
            this.output = new PrintWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.log.severe(ExceptionToString.process("Can't connect to GameBot (" + this.serverAddress + ":" + this.serverPort + ")", e));
            throw new ConnectException("Can't connect to GameBot (" + this.serverAddress + ":" + this.serverPort + ") -> " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CantCloseConnectionException {
        if (!this.isConnected()) {
            return;
        }
        this.log.info("Disconnecting from GameBots.");
        this.readerForLog.end();
        try {
            Socket socket = this.socket;
            synchronized (socket) {
                if (this.socket.isClosed()) {
                    return;
                }
                this.socket.close();
            }
            this.output.close();
            this.input.close();
            this.readerForLog.close();
        }
        catch (IOException e) {
            this.log.severe(ExceptionToString.process("Unable to disconnect from Gamebot", e));
            this.input = null;
            this.output = null;
            this.socket = null;
            throw new CantCloseConnectionException("Unable to disconnect from Gamebot -> " + e.getMessage(), e);
        }
        this.input = null;
        this.output = null;
        this.socket = null;
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        return !this.socket.isClosed();
    }

    public synchronized void send(String msg) throws CantWriteException {
        try {
            if (this.rawDataLog != null) {
                this.rawDataLog.info(">>> " + msg);
            }
            msg = msg + "\r\n";
            this.output.print(msg);
            this.output.flush();
        }
        catch (NullPointerException e) {
            this.log.severe(ExceptionToString.process("Unable to send data to GameBot, connection closed.", e));
            throw new CantWriteException("Unable to send data to GameBot, connection closed.");
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process("Unable to send data to GameBot.", e));
            throw new CantWriteException("Unable to send data to GameBot -> " + e.getMessage(), e);
        }
    }

    private class BufferedReaderForLog
    extends BufferedReader
    implements PreferenceChangeListener {
        private StringBuffer lastLine;
        private String lineSeparator;
        private boolean shouldLog;

        public BufferedReaderForLog(InputStreamReader stream) {
            super(stream);
            this.lastLine = new StringBuffer(255);
            this.lineSeparator = System.getProperty("line.separator");
            this.shouldLog = (Boolean)Settings.get(Settings.Setting.PLATFORM_DEBUG);
            this.shouldLogChanged();
            Settings.getPrefecences().addPreferenceChangeListener(this);
        }

        public void end() {
            Settings.getPrefecences().removePreferenceChangeListener(this);
        }

        private void shouldLogChanged() {
            if (GameBotConnection.this.rawDataLog != null) {
                if (this.shouldLog) {
                    GameBotConnection.this.rawDataLog.warning("Starting GB logging...");
                } else {
                    GameBotConnection.this.rawDataLog.warning("Terminating GB logging...");
                }
            }
        }

        public void preferenceChange(PreferenceChangeEvent arg0) {
            if (arg0.getKey().equals(Settings.Setting.PLATFORM_DEBUG.key)) {
                this.shouldLog = (Boolean)Settings.get(Settings.Setting.PLATFORM_DEBUG);
                this.shouldLogChanged();
            }
        }

        public int read(char[] cbuf, int offset, int length) throws IOException {
            int result = super.read(cbuf, offset, length);
            if (!this.shouldLog) {
                return result;
            }
            if (result < 0) {
                return result;
            }
            StringBuffer strBuff = new StringBuffer(length);
            strBuff.append(cbuf, offset, result);
            String str = strBuff.toString();
            int index = str.indexOf(this.lineSeparator);
            while (index != -1) {
                this.lastLine.append(str.substring(0, index));
                if (GameBotConnection.this.rawDataLog != null) {
                    GameBotConnection.this.rawDataLog.info("<<< " + this.lastLine.toString());
                }
                this.lastLine.delete(0, this.lastLine.length());
                str = str.substring(index + this.lineSeparator.length(), str.length());
                index = str.indexOf(this.lineSeparator);
            }
            this.lastLine.append(str);
            return result;
        }
    }
}

