/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.MessageObjects.Triple;

public class AgentInitializer {
    private String name = null;
    private int team = 0;
    private boolean manualSpawn = false;
    private Triple location = null;
    private Triple rotation = null;
    private String skin = null;
    private double accuracy = 1.0;
    private boolean targetLead = true;
    private int botSkillLevel = 7;
    private Boolean autoTrace = null;

    public String constructInitMessage() {
        String message = "INIT";
        if (this.name != null) {
            message = message + " {Name " + this.name + "}";
        }
        if (this.team != 0) {
            message = message + " {Team " + this.team + "}";
        }
        if (this.manualSpawn) {
            message = message + " {ManualSpawn True}";
        }
        if (this.location != null) {
            message = message + " {Location " + this.location + "}";
        }
        if (this.rotation != null) {
            message = message + " {Rotation " + this.rotation + "}";
        }
        if (this.skin != null) {
            message = message + " {Skin " + this.skin.toString() + "}";
        }
        if (this.botSkillLevel != 7) {
            message = message + " {DesiredSkill " + this.botSkillLevel + "}";
        }
        if (this.accuracy != 1.0) {
            message = message + " {Accuracy " + this.accuracy + "}";
        }
        if (!this.targetLead) {
            message = message + " {TargetLead False}";
        }
        if (this.autoTrace != null) {
            message = message + " {AutoTrace " + (this.autoTrace != false ? "True" : "False") + "}";
        }
        return message;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTeam() {
        return this.team;
    }

    public void setTeam(int team) {
        this.team = team;
    }

    public boolean isManualSpawn() {
        return this.manualSpawn;
    }

    public void setManualSpawn(boolean manualSpawn) {
        this.manualSpawn = manualSpawn;
    }

    public Triple getLocation() {
        return this.location;
    }

    public void setLocation(Triple location) {
        this.location = location;
    }

    public Triple getRotation() {
        return this.rotation;
    }

    public void setRotation(Triple rotation) {
        this.rotation = rotation;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        if (!(accuracy >= 0.0) || !(accuracy <= 1.0)) {
            throw new IllegalArgumentException("Wrong argument in set accuracy - should be between 0 and 1 - [0-1]");
        }
        this.accuracy = accuracy;
    }

    public boolean isTargetLead() {
        return this.targetLead;
    }

    public void setTargetLead(boolean targetLead) {
        this.targetLead = targetLead;
    }

    public int getBotSkillLevel() {
        return this.botSkillLevel;
    }

    public void setBotSkillLevel(int botSkillLevel) {
        this.botSkillLevel = botSkillLevel;
        if (this.botSkillLevel > 7) {
            this.botSkillLevel = 7;
        }
        if (this.botSkillLevel < 1) {
            this.botSkillLevel = 1;
        }
    }

    public void setAutoTrace(boolean b) {
        this.autoTrace = b;
    }
}

