/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.BuiltinFunctions;
import org.python.core.ClassDictInit;
import org.python.core.CompilerFlags;
import org.python.core.ImportFunction;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyXRange;
import org.python.core.codecs;
import org.python.core.imp;

public class __builtin__
implements ClassDictInit {
    private static PyStringMap internedStrings;
    public static PyString __doc__zip;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("None", Py.None);
        dict.__setitem__("NotImplemented", Py.NotImplemented);
        dict.__setitem__("Ellipsis", Py.Ellipsis);
        dict.__setitem__("__debug__", (PyObject)Py.One);
        dict.__setitem__("chr", (PyObject)new BuiltinFunctions("chr", 0, 1));
        dict.__setitem__("len", (PyObject)new BuiltinFunctions("len", 1, 1));
        dict.__setitem__("range", (PyObject)new BuiltinFunctions("range", 2, 1, 3));
        dict.__setitem__("ord", (PyObject)new BuiltinFunctions("ord", 3, 1));
        dict.__setitem__("globals", (PyObject)new BuiltinFunctions("globals", 4, 0));
        dict.__setitem__("hash", (PyObject)new BuiltinFunctions("hash", 5, 1));
        dict.__setitem__("cmp", (PyObject)new BuiltinFunctions("cmp", 6, 2));
        dict.__setitem__("list", (PyObject)new BuiltinFunctions("list", 7, 1));
        dict.__setitem__("tuple", (PyObject)new BuiltinFunctions("tuple", 8, 1));
        dict.__setitem__("apply", (PyObject)new BuiltinFunctions("apply", 9, 2, 3));
        dict.__setitem__("isinstance", (PyObject)new BuiltinFunctions("isinstance", 10, 2));
        dict.__setitem__("id", (PyObject)new BuiltinFunctions("id", 11, 1));
        dict.__setitem__("__import__", (PyObject)new ImportFunction());
        dict.__delitem__("execfile_flags");
    }

    public static PyObject abs(PyObject o) {
        return o.__abs__();
    }

    public static PyObject apply(PyObject o, PyObject args) {
        return o.__call__(__builtin__.make_array(args));
    }

    public static PyObject apply(PyObject o, PyObject args, PyDictionary kws) {
        Hashtable table = kws.table;
        if (table.size() > 0) {
            Enumeration ek = table.keys();
            Enumeration ev = table.elements();
            int n = table.size();
            String[] kw = new String[n];
            PyObject[] aargs = __builtin__.make_array(args);
            PyObject[] a = new PyObject[n + aargs.length];
            System.arraycopy(aargs, 0, a, 0, aargs.length);
            int offset = aargs.length;
            int i = 0;
            while (i < n) {
                kw[i] = ((PyString)ek.nextElement()).internedString();
                a[i + offset] = (PyObject)ev.nextElement();
                ++i;
            }
            return o.__call__(a, kw);
        }
        return __builtin__.apply(o, args);
    }

    public static boolean callable(PyObject o) {
        return o.__findattr__("__call__") != null;
    }

    public static char unichr(int i) {
        return __builtin__.chr(i);
    }

    public static char chr(int i) {
        if (i < 0 || i > 65535) {
            throw Py.ValueError("chr() arg not in range(65535)");
        }
        return (char)i;
    }

    public static int cmp(PyObject x, PyObject y) {
        return x._cmp(y);
    }

    public static PyTuple coerce(PyObject o1, PyObject o2) {
        if (o1.__class__ == o2.__class__) {
            return new PyTuple(new PyObject[]{o1, o2});
        }
        Object ctmp = o1.__coerce_ex__(o2);
        if (ctmp != null && ctmp != Py.None) {
            if (ctmp instanceof PyObject[]) {
                return new PyTuple((PyObject[])ctmp);
            }
            return new PyTuple(new PyObject[]{o1, (PyObject)ctmp});
        }
        ctmp = o2.__coerce_ex__(o1);
        if (ctmp != null && ctmp != Py.None) {
            if (ctmp instanceof PyObject[]) {
                return new PyTuple((PyObject[])ctmp);
            }
            return new PyTuple(new PyObject[]{(PyObject)ctmp, o2});
        }
        throw Py.TypeError("number coercion failed");
    }

    public static PyCode compile(String data, String filename, String type) {
        return Py.compile_flags(data, filename, type, Py.getCompilerFlags());
    }

    public static PyComplex complex(PyObject real, PyObject imag) {
        return (PyComplex)real.__complex__().__add__(imag.__complex__().__mul__(PyComplex.J));
    }

    public static PyComplex complex(PyObject real) {
        return real.__complex__();
    }

    public static void delattr(PyObject o, PyString n) {
        o.__delattr__(n);
    }

    public static PyObject dir(PyObject o) {
        PyList ret = (PyList)o.__dir__();
        ret.sort();
        return ret;
    }

    public static PyObject dir() {
        PyList pyList;
        PyObject l = __builtin__.locals();
        if (l instanceof PyStringMap) {
            pyList = ((PyStringMap)l).keys();
        }
        if (l instanceof PyDictionary) {
            pyList = ((PyDictionary)l).keys();
        }
        PyList ret = (PyList)l.invoke("keys");
        ret.sort();
        return ret;
    }

    public static PyObject divmod(PyObject x, PyObject y) {
        return x._divmod(y);
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject eval(PyObject o, PyObject globals, PyObject locals) {
        void code;
        PyCode pyCode;
        if (o instanceof PyCode) {
            pyCode = (PyCode)o;
        } else if (o instanceof PyString) {
            pyCode = Py.compile_flags(((PyString)o).toString(), "<string>", "eval", null);
        } else {
            throw Py.TypeError("eval: argument 1 must be string or code object");
        }
        return Py.runCode((PyCode)code, locals, globals);
    }

    public static PyObject eval(PyObject o, PyObject globals) {
        return __builtin__.eval(o, globals, globals);
    }

    public static PyObject eval(PyObject o) {
        return __builtin__.eval(o, null, null);
    }

    public static void execfile(String name, PyObject globals, PyObject locals) {
        __builtin__.execfile_flags(name, globals, locals, Py.getCompilerFlags());
    }

    /*
     * WARNING - void declaration
     */
    public static void execfile_flags(String name, PyObject globals, PyObject locals, CompilerFlags cflags) {
        void code;
        void file;
        try {
            FileInputStream fileInputStream = new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            throw Py.IOError(e);
        }
        try {
            PyCode e = Py.compile_flags((InputStream)file, name, "exec", cflags);
        }
        finally {
            Object var7_7 = null;
            try {
                file.close();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
        }
        Py.runCode((PyCode)code, locals, globals);
    }

    public static void execfile(String name, PyObject globals) {
        __builtin__.execfile(name, globals, globals);
    }

    public static void execfile(String name) {
        __builtin__.execfile(name, null, null);
    }

    public static PyObject filter(PyObject f, PyString s) {
        if (f == Py.None) {
            return s;
        }
        PyObject[] args = new PyObject[1];
        char[] chars = s.toString().toCharArray();
        int n = chars.length;
        int i = 0;
        int j = 0;
        while (i < n) {
            args[0] = Py.makeCharacter(chars[i]);
            if (f.__call__(args).__nonzero__()) {
                chars[j++] = chars[i];
            }
            ++i;
        }
        return new PyString(new String(chars, 0, j));
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject filter(PyObject f, PyObject l) {
        PyObject element;
        int i = 0;
        PyList list = new PyList();
        while ((element = l.__finditem__(i++)) != null) {
            void var3_4;
            if (f == Py.None ? !var3_4.__nonzero__() : !f.__call__((PyObject)var3_4).__nonzero__()) continue;
            list.append((PyObject)var3_4);
        }
        return list;
    }

    public static PyFloat float$(PyObject o) {
        return o.__float__();
    }

    public static PyObject getattr(PyObject o, PyString n) {
        return o.__getattr__(n);
    }

    public static PyObject getattr(PyObject o, PyString n, PyObject def) {
        PyObject val = o.__findattr__(n);
        if (val != null) {
            return val;
        }
        return def;
    }

    public static PyObject globals() {
        return Py.getFrame().f_globals;
    }

    public static boolean hasattr(PyObject o, PyString n) {
        try {
            return o.__findattr__(n) != null;
        }
        catch (PyException exc) {
            if (Py.matchException(exc, Py.AttributeError)) {
                return false;
            }
            throw exc;
        }
    }

    public static PyInteger hash(PyObject o) {
        return o.__hash__();
    }

    public static PyString hex(PyObject o) {
        return o.__hex__();
    }

    public static int id(PyObject o) {
        return Py.id(o);
    }

    public static PyObject input(PyObject prompt) {
        String line = __builtin__.raw_input(prompt);
        return __builtin__.eval(new PyString(line));
    }

    public static PyObject input() {
        return __builtin__.input(new PyString(""));
    }

    public static PyInteger int$(PyString o, int base) {
        return Py.newInteger(o.__str__().atoi(base));
    }

    public static PyInteger int$(PyObject o) {
        return o.__int__();
    }

    public static PyString intern(PyString s) {
        String istring;
        PyObject ret;
        if (internedStrings == null) {
            internedStrings = new PyStringMap();
        }
        if ((ret = internedStrings.__finditem__(istring = s.internedString())) != null) {
            return (PyString)ret;
        }
        internedStrings.__setitem__(istring, (PyObject)s);
        return s;
    }

    public static boolean isinstance(PyObject obj, PyClass myClass) {
        return __builtin__.issubclass(obj.__class__, myClass);
    }

    public static boolean issubclass(PyClass subClass, PyClass superClass) {
        if (subClass == null || superClass == null) {
            throw Py.TypeError("arguments must be classes");
        }
        if (subClass == superClass) {
            return true;
        }
        if (subClass.proxyClass != null && superClass.proxyClass != null && superClass.proxyClass.isAssignableFrom(subClass.proxyClass)) {
            return true;
        }
        if (subClass.__bases__ == null || superClass.__bases__ == null) {
            return false;
        }
        PyObject[] bases = subClass.__bases__.list;
        int n = bases.length;
        int i = 0;
        while (i < n) {
            PyClass c = (PyClass)bases[i];
            if (__builtin__.issubclass(c, superClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int len(PyObject o) {
        try {
            return o.__len__();
        }
        catch (PyException e) {
            if (e.type == Py.AttributeError && !(o instanceof PyInstance)) {
                throw Py.TypeError("len() of unsized object");
            }
            throw e;
        }
    }

    public static PyList list(PyObject o) {
        if (o instanceof PyList) {
            return (PyList)o;
        }
        if (o instanceof PyTuple) {
            PyTuple t = (PyTuple)o;
            PyObject[] a = new PyObject[t.__len__()];
            System.arraycopy(t.list, 0, a, 0, a.length);
            return new PyList(a);
        }
        return new PyList(__builtin__.make_array(o));
    }

    public static PyObject locals() {
        return Py.getFrame().getf_locals();
    }

    public static PyLong long$(PyObject o) {
        return o.__long__();
    }

    public static PyLong long$(PyString o, int base) {
        return o.__str__().atol(base);
    }

    public static PyObject map(PyObject[] argstar) {
        int i = 0;
        int n = argstar.length - 1;
        if (n < 1) {
            throw Py.TypeError("map requires at least two arguments");
        }
        PyObject f = argstar[0];
        PyList list = new PyList();
        PyObject[] args = new PyObject[n];
        while (true) {
            boolean any_items = false;
            int j = 0;
            while (j < n) {
                PyObject element = argstar[j + 1].__finditem__(i);
                if (element != null) {
                    args[j] = element;
                    any_items = true;
                } else {
                    args[j] = Py.None;
                }
                ++j;
            }
            if (!any_items) break;
            if (f == Py.None) {
                if (n == 1) {
                    list.append(args[0]);
                } else {
                    list.append(new PyTuple((PyObject[])args.clone()));
                }
            } else {
                list.append(f.__call__(args));
            }
            ++i;
        }
        return list;
    }

    public static PyObject max(PyObject[] l) {
        if (l.length == 1) {
            return __builtin__.max(l[0]);
        }
        return __builtin__.max(new PyTuple(l));
    }

    /*
     * WARNING - void declaration
     */
    private static final PyObject max(PyObject o) {
        PyObject element;
        PyObject max = o.__finditem__(0);
        if (max == null) {
            throw Py.ValueError("max of empty sequence");
        }
        int i = 1;
        while ((element = o.__finditem__(i++)) != null) {
            void var2_3;
            if (!var2_3._gt(max).__nonzero__()) continue;
            max = var2_3;
        }
        return max;
    }

    public static PyObject min(PyObject[] l) {
        if (l.length == 1) {
            return __builtin__.min(l[0]);
        }
        return __builtin__.min(new PyTuple(l));
    }

    /*
     * WARNING - void declaration
     */
    private static final PyObject min(PyObject o) {
        PyObject element;
        PyObject min = o.__finditem__(0);
        if (min == null) {
            throw Py.ValueError("min of empty sequence");
        }
        int i = 1;
        while ((element = o.__finditem__(i++)) != null) {
            void var2_3;
            if (!var2_3._lt(min).__nonzero__()) continue;
            min = var2_3;
        }
        return min;
    }

    public static PyString oct(PyObject o) {
        return o.__oct__();
    }

    public static PyFile open(String name) throws IOException {
        return new PyFile(name, "r", -1);
    }

    public static PyFile open(String name, String mode) throws IOException {
        return new PyFile(name, mode, -1);
    }

    public static PyFile open(String name, String mode, int bufsize) throws IOException {
        return new PyFile(name, mode, bufsize);
    }

    public static final int ord(char c) {
        return c;
    }

    public static PyObject pow(PyObject x, PyObject y) {
        return x._pow(y);
    }

    private static final boolean coerce(PyObject[] objs) {
        PyObject x = objs[0];
        PyObject y = objs[1];
        if (x.__class__ == y.__class__) {
            return true;
        }
        Object ctmp = x.__coerce_ex__(y);
        if (ctmp != null && ctmp != Py.None) {
            if (ctmp instanceof PyObject[]) {
                x = ((PyObject[])ctmp)[0];
                y = ((PyObject[])ctmp)[1];
            } else {
                y = (PyObject)ctmp;
            }
        }
        objs[0] = x;
        objs[1] = y;
        if (x.__class__ == y.__class__) {
            return true;
        }
        ctmp = y.__coerce_ex__(x);
        if (ctmp != null && ctmp != Py.None) {
            if (ctmp instanceof PyObject[]) {
                y = ((PyObject[])ctmp)[0];
                x = ((PyObject[])ctmp)[1];
            } else {
                x = (PyObject)ctmp;
            }
        }
        objs[0] = x;
        objs[1] = y;
        return x.__class__ == y.__class__;
    }

    public static PyObject pow(PyObject xi, PyObject yi, PyObject zi) {
        PyObject x = xi;
        PyObject y = yi;
        PyObject z = zi;
        boolean doit = false;
        PyObject[] tmp = new PyObject[]{x, y};
        if (__builtin__.coerce(tmp)) {
            x = tmp[0];
            y = tmp[1];
            tmp[1] = z;
            if (__builtin__.coerce(tmp)) {
                x = tmp[0];
                z = tmp[1];
                tmp[0] = y;
                if (__builtin__.coerce(tmp)) {
                    z = tmp[1];
                    y = tmp[0];
                    doit = true;
                }
            }
        } else {
            tmp[1] = z;
            if (__builtin__.coerce(tmp)) {
                x = tmp[0];
                z = tmp[1];
                tmp[0] = y;
                if (__builtin__.coerce(tmp)) {
                    y = tmp[0];
                    z = tmp[1];
                    tmp[1] = x;
                    if (__builtin__.coerce(tmp)) {
                        x = tmp[1];
                        y = tmp[0];
                        doit = true;
                    }
                }
            }
        }
        if (x.__class__ == y.__class__ && x.__class__ == z.__class__ && (x = x.__pow__(y, z)) != null) {
            return x;
        }
        throw Py.TypeError("__pow__ not defined for these operands");
    }

    public static PyObject range(int start, int stop, int step) {
        int n;
        if (step == 0) {
            throw Py.ValueError("zero step for range()");
        }
        if (step > 0) {
            int n2 = (stop - start + step - 1) / step;
        } else {
            n = (stop - start + step + 1) / step;
        }
        if (n <= 0) {
            return new PyList();
        }
        PyObject[] l = new PyObject[n];
        int j = start;
        int i = 0;
        while (i < n) {
            l[i] = Py.newInteger(j);
            j += step;
            ++i;
        }
        return new PyList(l);
    }

    public static PyObject range(int n) {
        return __builtin__.range(0, n, 1);
    }

    public static PyObject range(int start, int stop) {
        return __builtin__.range(start, stop, 1);
    }

    private static final PyString readline(PyObject file) {
        if (file instanceof PyFile) {
            return ((PyFile)file).readline();
        }
        PyObject ret = file.invoke("readline");
        if (!(ret instanceof PyString)) {
            throw Py.TypeError("object.readline() returned non-string");
        }
        return (PyString)ret;
    }

    public static String raw_input(PyObject prompt) {
        Py.print(prompt);
        PyObject stdin = Py.getSystemState().stdin;
        String data = __builtin__.readline(stdin).toString();
        if (data.endsWith("\n")) {
            return data.substring(0, data.length() - 1);
        }
        if (data.length() == 0) {
            throw Py.EOFError("raw_input()");
        }
        return data;
    }

    public static String raw_input() {
        return __builtin__.raw_input(new PyString(""));
    }

    /*
     * Unable to fully structure code
     */
    public static PyObject reduce(PyObject f, PyObject l, PyObject z) {
        i = 0;
        result = z;
        if (result != null || (result = l.__finditem__(i++)) != null) ** GOTO lbl6
        throw Py.TypeError("reduce of empty sequence with no initial value");
lbl-1000:
        // 1 sources

        {
            result = f.__call__(result, (PyObject)var4_5);
lbl6:
            // 2 sources

            ** while ((element = l.__finditem__((int)i++)) != null)
        }
lbl7:
        // 1 sources

        return result;
    }

    public static PyObject reduce(PyObject f, PyObject l) {
        return __builtin__.reduce(f, l, null);
    }

    public static PyObject reload(PyModule o) {
        return imp.reload(o);
    }

    public static PyObject reload(PyJavaClass o) {
        return imp.reload(o);
    }

    public static PyString repr(PyObject o) {
        return o.__repr__();
    }

    public static PyFloat round(double f, int digits) {
        boolean neg = f < 0.0;
        double multiple = Math.pow(10.0, digits);
        if (neg) {
            f = -f;
        }
        double tmp = Math.floor(f * multiple + 0.5);
        if (neg) {
            tmp = -tmp;
        }
        return new PyFloat(tmp / multiple);
    }

    public static PyFloat round(double f) {
        return __builtin__.round(f, 0);
    }

    public static void setattr(PyObject o, PyString n, PyObject v) {
        o.__setattr__(n, v);
    }

    public static PySlice slice(PyObject start, PyObject stop, PyObject step) {
        return new PySlice(start, stop, step);
    }

    public static PySlice slice(PyObject start, PyObject stop) {
        return __builtin__.slice(start, stop, Py.None);
    }

    public static PySlice slice(PyObject stop) {
        return __builtin__.slice(Py.None, stop, Py.None);
    }

    public static PyString str(PyObject o) {
        return o.__str__();
    }

    public static PyString unicode(PyObject v) {
        return __builtin__.unicode(v.__str__(), null, null);
    }

    public static PyString unicode(PyString v, String encoding) {
        return __builtin__.unicode(v, encoding, null);
    }

    public static PyString unicode(PyString v, String encoding, String errors) {
        return codecs.decode(v, encoding, errors);
    }

    public static PyTuple tuple(PyObject o) {
        if (o instanceof PyTuple) {
            return (PyTuple)o;
        }
        if (o instanceof PyList) {
            PyList l = (PyList)o;
            PyObject[] a = new PyObject[l.length];
            System.arraycopy(l.list, 0, a, 0, a.length);
            return new PyTuple(a);
        }
        return new PyTuple(__builtin__.make_array(o));
    }

    public static PyClass type(PyObject o) {
        if (o instanceof PyInstance) {
            return PyJavaClass.lookup(o.getClass());
        }
        return o.__class__;
    }

    public static PyObject vars(PyObject o) {
        return o.__getattr__("__dict__");
    }

    public static PyObject vars() {
        return __builtin__.locals();
    }

    public static PyObject xrange(int start, int stop, int step) {
        return new PyXRange(start, stop, step);
    }

    public static PyObject xrange(int n) {
        return __builtin__.xrange(0, n, 1);
    }

    public static PyObject xrange(int start, int stop) {
        return __builtin__.xrange(start, stop, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject zip(PyObject[] argstar) {
        int itemsize = argstar.length;
        if (itemsize < 1) {
            throw Py.TypeError("zip requires at least one sequence");
        }
        PyObject[] getitems = new PyObject[itemsize];
        int j = 0;
        while (j < itemsize) {
            PyObject getitem = argstar[j].__findattr__("__getitem__");
            if (getitem == null) {
                if (argstar[j] instanceof PyInstance) {
                    argstar[j].__getattr__("__getitem__");
                }
                throw Py.TypeError("unindexable object");
            }
            getitems[j] = getitem;
            ++j;
        }
        PyList ret = new PyList();
        int i = 0;
        while (true) {
            PyObject[] next = new PyObject[itemsize];
            PyInteger index = new PyInteger(i);
            int j2 = 0;
            while (j2 < itemsize) {
                void item;
                try {
                    PyObject pyObject = getitems[j2].__call__(index);
                }
                catch (PyException e) {
                    if (Py.matchException(e, Py.IndexError)) {
                        return ret;
                    }
                    throw e;
                }
                next[j2] = item;
                ++j2;
            }
            ret.append(new PyTuple(next));
            ++i;
        }
    }

    public static PyObject __import__(String name) {
        return __builtin__.__import__(name, null, null, null);
    }

    public static PyObject __import__(String name, PyObject globals) {
        return __builtin__.__import__(name, globals, null, null);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals) {
        return __builtin__.__import__(name, globals, locals, null);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals, PyObject fromlist) {
        PyObject __import__;
        PyFrame frame = Py.getFrame();
        if (frame == null) {
            return null;
        }
        PyObject builtins = frame.f_builtins;
        if (builtins == null) {
            builtins = Py.getSystemState().builtins;
        }
        if ((__import__ = builtins.__finditem__("__import__")) == null) {
            return null;
        }
        PyObject module = __import__.__call__(new PyObject[]{Py.newString(name), globals, locals, fromlist});
        return module;
    }

    private static final PyObject[] make_array(PyObject o) {
        if (o instanceof PyTuple) {
            return ((PyTuple)o).list;
        }
        int n = o.__len__();
        PyObject[] objs = new PyObject[n];
        int i = 0;
        while (i < n) {
            objs[i] = o.__finditem__(i);
            ++i;
        }
        return objs;
    }

    static {
        __doc__zip = new PyString("zip(seq1 [, seq2 [...]]) -> [(seq1[0], seq2[0] ...), (...)]\n\nReturn a list of tuples, where each tuple contains the i-th element\nfrom each of the argument sequences.  The returned list is\ntruncated in length to the length of the shortest argument sequence.");
    }
}

