/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.extended;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.Line2D;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple2D;
import cz.cuni.utils.math.extended.Line2DExtended;
import cz.cuni.utils.math.extended.Vertex2D;

public class Segment2D {
    public Line2D line;
    public Vertex2D[] ab = new Vertex2D[]{null, null};
    public Vertex2D[] abN;
    public double length;
    protected final int hashCode;

    public Segment2D(Vertex2D a, Vertex2D b) {
        this.ab[0] = a;
        this.ab[1] = b;
        this.abN = M.normalizedOrder(a, b);
        this.line = Line2DExtended.line2D(a, b);
        this.length = M.distance((Tuple2D)this.ab[0], this.ab[1]);
        this.hashCode = this.countHashCode();
    }

    protected int countHashCode() {
        HashCodes hc = HashCodes.getNewCounter();
        hc.add(HashCodes.hash(this.abN[0]));
        hc.add(HashCodes.hash(this.abN[1]));
        return hc.getHashCode();
    }

    public String toString() {
        return "Segment2D(" + this.abN[0] + ", " + this.abN[1] + ")";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Segment2D)) {
            return false;
        }
        return this.equals((Segment2D)o);
    }

    public boolean equals(Segment2D s) {
        if (this.hashCode != s.hashCode) {
            return false;
        }
        return this.abN[0].equals(s.abN[0]) && this.abN[1].equals(s.abN[1]);
    }

    public Tuple2D[] segmentPoints(Tuple2D point, double distance) {
        Tuple2D vector = M.multi(this.line.direction.normalize(), distance);
        Tuple2D a = M.plus(point, vector);
        Tuple2D b = M.plus(point, vector.inverse());
        if (M.inSegment(this.ab[0], (Tuple2D)this.ab[1], a)) {
            if (M.inSegment(this.ab[0], (Tuple2D)this.ab[1], b)) {
                return new Tuple2D[]{a, b};
            }
            return new Tuple2D[]{a};
        }
        if (M.inSegment(this.ab[0], (Tuple2D)this.ab[1], b)) {
            return new Tuple2D[]{b};
        }
        return null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public double length() {
        return this.length;
    }

    public boolean hasVertex(Vertex2D v) {
        return this.ab[0] != null && this.ab[0].equals(v) || this.ab[1] != null && this.ab[1].equals(v);
    }

    public Vertex2D getOtherVertex(Vertex2D previousVertex) {
        if (this.ab[0].equals(previousVertex)) {
            return this.ab[1];
        }
        return this.ab[0];
    }

    public Vertex2D sharedVertex(Segment2D s) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (!this.ab[i].equals(s.ab[j])) continue;
                return this.ab[i];
            }
        }
        return null;
    }
}

