/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.errorlog;

public class ErrorMessage {
    protected static final int MIN_SEVERITY = -1;
    public static final int SEVERITY_UNKNOWN = -1;
    public static final int SEVERITY_INFO = 0;
    public static final int SEVERITY_FIXED_ERROR = 1;
    public static final int SEVERITY_UNRECOVERED_ERROR = 2;
    public static final int SEVERITY_UNEXPECTED_ERROR = 3;
    protected static final int MAX_SEVERITY = 3;
    protected int severity = -1;
    protected String message;

    public ErrorMessage(String iMessage, int iSeverity) {
        if (iSeverity < -1 || iSeverity > 3) {
            iSeverity = -1;
        }
        this.severity = iSeverity;
        if (iMessage == null) {
            iMessage = new String("(null)");
        }
        this.message = iMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public static String toString(int severity) {
        switch (severity) {
            case -1: {
                return "SEVERITY_UNKNOWN";
            }
            case 0: {
                return "SEVERITY_INFO";
            }
            case 1: {
                return "SEVERITY_FIXED_ERROR";
            }
            case 2: {
                return "SEVERITY_UNRECOVERED_ERROR";
            }
            case 3: {
                return "SEVERITY_UNEXPECTED_ERROR";
            }
        }
        return "(null)";
    }

    public static String toStringHuman(int severity) {
        switch (severity) {
            case -1: {
                return "Unknown";
            }
            case 0: {
                return "Info";
            }
            case 1: {
                return "Fixed error";
            }
            case 2: {
                return "Unrecovered error";
            }
            case 3: {
                return "Unexpected error";
            }
        }
        return "(null)";
    }
}

