/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.errorlog;

import cz.cuni.utils.errorlog.ErrorMessage;
import java.awt.Frame;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.JOptionPane;

public class ErrorLog {
    public static boolean logging = false;
    public static boolean logToScreen = false;
    protected static ErrorLog thisClass = new ErrorLog();
    protected static Queue errors = new LinkedList();
    protected static boolean containsErrors = false;

    protected ErrorLog() {
    }

    public static ErrorLog getInstance() {
        return thisClass;
    }

    public static void showAllErrors(Frame owner) {
        StringBuffer sb = new StringBuffer();
        ErrorMessage em = ErrorLog.poll();
        if (em == null) {
            return;
        }
        sb.append(ErrorMessage.toStringHuman(em.severity));
        sb.append(": ");
        sb.append(em.message);
        while ((em = ErrorLog.poll()) != null) {
            sb.append("\n");
            sb.append(ErrorMessage.toStringHuman(em.severity));
            sb.append(": ");
            sb.append(em.message);
        }
        if (containsErrors) {
            JOptionPane.showMessageDialog(owner, sb.toString(), "Errors", 0);
        } else {
            JOptionPane.showMessageDialog(owner, sb.toString(), "Info", 1);
        }
        containsErrors = false;
    }

    public static int size() {
        return errors.size();
    }

    public static ErrorMessage peek() {
        if (errors.size() == 0) {
            return null;
        }
        return (ErrorMessage)errors.peek();
    }

    public static ErrorMessage poll() {
        return (ErrorMessage)errors.poll();
    }

    public static boolean add(String message, int severity) {
        return ErrorLog.add(new ErrorMessage(message, severity));
    }

    protected static void checkError(ErrorMessage em) {
        if (em.severity == 3 || em.severity == 2) {
            containsErrors = true;
        }
    }

    public static boolean add(ErrorMessage em) {
        if (em == null) {
            return false;
        }
        if (logToScreen) {
            System.out.println(ErrorMessage.toStringHuman(em.severity) + ": " + em.message);
        }
        if (logging) {
            ErrorLog.checkError(em);
            return errors.add(em);
        }
        return true;
    }

    public static boolean add(Object o) {
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        return errors.add((ErrorMessage)o);
    }

    public static boolean addAll(Collection c) {
        return errors.addAll(c);
    }

    public static void clear() {
        errors.clear();
    }

    public static boolean contains(Object o) {
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        return errors.contains(o);
    }

    public static boolean containsAll(Collection c) {
        return errors.containsAll(c);
    }

    public static boolean isEmpty() {
        return errors.isEmpty();
    }

    public static Iterator iterator() {
        return errors.iterator();
    }

    public static boolean remove(Object o) {
        return errors.remove(o);
    }

    public static boolean removeAll(Collection c) {
        return errors.removeAll(c);
    }

    public static boolean retainAll(Collection c) {
        return errors.retainAll(c);
    }

    public static Object[] toArray() {
        return errors.toArray();
    }

    public static Object[] toArray(Object[] a) {
        return errors.toArray(a);
    }
}

