/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments.util;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentStats;
import cz.cuni.pogamut.experiments.Experiment;
import cz.cuni.pogamut.experiments.ExperimentDescriptor;
import cz.cuni.pogamut.experiments.ExperimentResult;
import cz.cuni.pogamut.experiments.TimerTask;
import cz.cuni.pogamut.experiments.util.BasicExperimentDescriptor;
import cz.cuni.pogamut.server.UTServer;
import cz.cuni.utils.Settings;

public class BasicExperiment
extends Experiment {
    protected Agent[] agents = null;
    protected AgentStats[] stats = null;

    protected void stageOneInit() throws Exception {
    }

    public BasicExperiment(ExperimentDescriptor descriptor, UTServer server) {
        super(descriptor, server);
    }

    protected void stageTwoStart() throws Exception {
        Settings.set(Settings.Setting.PLATFORM_DEBUG, false);
        BasicExperimentDescriptor desc = (BasicExperimentDescriptor)this.getDescriptor();
        this.agents = desc.botCreator.createBots(this.getServer());
        this.stats = new AgentStats[this.agents.length];
        for (int i = 0; i < this.agents.length; ++i) {
            this.agents[i].logicFrequency *= desc.getExperimentSpeed();
            this.stats[i] = new AgentStats(this.agents[i]);
            this.getServer().connectBot(this.agents[i]);
        }
        this.stageTwoPostAgentConnect();
        this.schedule(new TimerTask(){

            public void run() {
                BasicExperiment.this.terminate();
            }
        }, ((BasicExperimentDescriptor)this.getDescriptor()).experimentLength);
    }

    protected void terminate() {
        this.setResultAndTerminate(new StatResult(this.stats));
    }

    protected void stageThreeFinish() {
        for (Agent agent : this.agents) {
            agent.disconnect();
        }
        this.getServer().disconnectAllBots();
        this.getServer().getConnection().sendCommandToGB("CLEAR");
    }

    protected void stageTwoPostAgentConnect() {
    }

    public static class StatResult
    extends ExperimentResult {
        public AgentStats[] stats = null;

        public StatResult(AgentStats[] stats) {
            this.stats = stats;
        }

        public String toString() {
            return super.toString() + " " + this.stats.toString();
        }
    }
}

