/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import cz.cuni.pogamut.exceptions.UCCStartException;
import cz.cuni.pogamut.experiments.ExecutorException;
import cz.cuni.pogamut.experiments.ExperimentDescriptor;
import cz.cuni.pogamut.experiments.ExperimentExecutionState;
import cz.cuni.pogamut.experiments.ExperimentHandle;
import cz.cuni.pogamut.experiments.ExperimentsUTServer;
import cz.cuni.pogamut.experiments.LocalExperimentExecutor;
import cz.cuni.pogamut.experiments.LocalExperimentHandle;
import cz.cuni.pogamut.experiments.SerialExperimentExecutor;
import cz.cuni.pogamut.server.UCCWrapper;
import cz.cuni.utils.FlagListener;
import java.util.List;
import java.util.Random;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalExperimentExecutorImpl
extends LocalExperimentExecutor {
    static final int maxFailedStarts = 300;
    static final int randomStartInterval = 15000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalExperimentHandle execute(ExperimentDescriptor experimentDescriptor, int failedStarts) throws ExecutorException {
        try {
            Logger log = Logger.getAnonymousLogger();
            log.addHandler(new Handler(){

                public void publish(LogRecord record) {
                    System.err.println("UCCLOG " + record.getMessage());
                }

                public void flush() {
                }

                public void close() throws SecurityException {
                }
            });
            final UCCWrapper ucc = UCCWrapper.create(0L, log);
            ExperimentsUTServer expServer = ExperimentsUTServer.create(ucc.getUTServer());
            LocalExperimentHandle handle = expServer.execute(experimentDescriptor);
            handle.getExperimentExecutionFlag().addListener(new FlagListener<ExperimentExecutionState>(){

                @Override
                public void flagChanged(ExperimentExecutionState changedValue, int listenerParam) {
                    if (changedValue.isEndState()) {
                        ucc.release();
                        System.gc();
                    }
                }
            });
            return handle;
        }
        catch (UCCStartException ex) {
            Logger.getLogger(LocalExperimentExecutorImpl.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            if (++failedStarts == 300) {
                throw new ExecutorException("Failed to start the UCC server.");
            }
            try {
                Random r = new Random();
                Thread.sleep(r.nextInt(15000));
            }
            catch (InterruptedException ex1) {
                Logger.getLogger(LocalExperimentExecutorImpl.class.getName()).log(Level.SEVERE, null, ex1);
            }
            finally {
                return this.execute(experimentDescriptor, failedStarts);
            }
        }
    }

    @Override
    public LocalExperimentHandle execute(ExperimentDescriptor experimentDescriptor) throws ExecutorException {
        return this.execute(experimentDescriptor, 0);
    }

    @Override
    public ExperimentHandle[] execute(List<ExperimentDescriptor> experimentDescriptors) {
        ExperimentHandle[] handles = new ExperimentHandle[experimentDescriptors.size()];
        for (int i = 0; i < experimentDescriptors.size(); ++i) {
            try {
                handles[i] = this.execute(experimentDescriptors.get(i));
                try {
                    handles[i].getResult();
                }
                catch (Exception ex) {}
                continue;
            }
            catch (ExecutorException ex) {
                Logger.getLogger(SerialExperimentExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return handles;
    }
}

