/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.GameMap;
import cz.cuni.pogamut.Client.GameMapSettings;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.FallEdge;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Mover;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Path;
import cz.cuni.pogamut.MessageObjects.Spawn;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.WallCollision;
import cz.cuni.utils.math.Line3D;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathManager
implements RcvMsgListener {
    public static final long PATH_REQUEST_TIMEOUT = 5000L;
    private static final int PATH_ID_START_COUNTER = 9999999;
    protected HashMap<String, ArrayList<NavPoint>> pathsFromGB = new HashMap();
    private boolean pathRequestSent = false;
    private int pathId = 9999999;
    private Triple pathToLocation = null;
    private ArrayList<NavPoint> path = null;
    private long lastPathRequestSent = 0L;
    private GameMap gameMap = null;
    private AgentBody body = null;
    private Logger log;
    private RunAlongPathState runningState = RunAlongPathState.PATH_RESTARTED;
    private NavPoint fromNavPoint = null;
    private NavPoint toNavPoint = null;
    private NeighNav edge = null;
    private int runningToNavPointIndex = -1;
    private String logPrefix = "PathManager: ";
    private Mover myMover = null;
    private boolean waitingForLift = false;
    private long waitingForLiftStartedMillis = 0L;
    private boolean returningToLiftExit = false;
    private int liftAttempts = 0;
    private double zCoordWhenLiftCenterReached = 0.0;
    private List<Triple> agentLocationHistory = new ArrayList<Triple>();
    private long lastAgentLocationAddedMillis = 0L;
    private long lastJumpMillis = 0L;

    public PathManager(GameMap gameMap, AgentBody body, Logger platformLog) {
        this.gameMap = gameMap;
        this.body = body;
        this.body.addRcvMsgListener((RcvMsgListener)this, new MessageType[]{MessageType.PATH, MessageType.SPAWN, MessageType.WALL_COLLISION, MessageType.FALL});
        this.log = platformLog;
        this.restartPathManager();
    }

    public void restartPathManager() {
        this.pathRequestSent = false;
        this.lastPathRequestSent = 0L;
        this.path = null;
        this.pathToLocation = null;
        this.restartRunAlongPath();
    }

    public PathResult retrievePathGB(Triple location) {
        if (location == null) {
            this.restartPathManager();
            return PathResult.NO_PATH;
        }
        if (this.pathToLocation == null || Triple.distanceInSpace(location, this.pathToLocation) > 20.0) {
            this.restartPathManager();
            this.pathToLocation = (Triple)location.clone();
            if (!this.pathRequestSent) {
                if (this.pathId == Integer.MAX_VALUE) {
                    this.pathId = 9999999;
                }
                this.gameMap.sendGetPathToLocation(this.pathId, location);
                this.pathRequestSent = true;
            }
            this.lastPathRequestSent = System.currentTimeMillis();
            return PathResult.OBTAINING_PATH;
        }
        this.path = this.pathsFromGB.get(String.valueOf(this.pathId));
        if (this.path != null) {
            if (this.path.size() > 0) {
                return PathResult.PATH_FOUND;
            }
            this.restartPathManager();
            return PathResult.NO_PATH;
        }
        if (System.currentTimeMillis() - this.lastPathRequestSent > 5000L) {
            this.restartPathManager();
            return PathResult.NO_PATH;
        }
        return PathResult.OBTAINING_PATH;
    }

    public PathResult retrievePathAStar(NavPoint target) {
        AStarResult result = this.gameMap.getPathAStar(target);
        if (result.success) {
            this.path = this.gameMap.getNavPointsAStar(result);
            return PathResult.PATH_FOUND;
        }
        return PathResult.NO_PATH;
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        if (e.getMessage() instanceof Path) {
            Path path = (Path)e.getMessage();
            this.pathsFromGB.put(path.pongID, path.nodes);
        } else if (e.getMessage() instanceof Spawn) {
            this.restartPathManager();
        } else if (e.getMessage() instanceof FallEdge || e.getMessage() instanceof WallCollision) {
            // empty if block
        }
    }

    public ArrayList<NavPoint> getPath() {
        return this.path;
    }

    public void restartRunAlongPath() {
        this.runningState = RunAlongPathState.PATH_RESTARTED;
        this.fromNavPoint = null;
        this.toNavPoint = null;
        this.edge = null;
        this.runningToNavPointIndex = -1;
        this.myMover = null;
        this.waitingForLift = false;
        this.waitingForLiftStartedMillis = 0L;
        this.returningToLiftExit = false;
        this.liftAttempts = 0;
        this.zCoordWhenLiftCenterReached = 0.0;
        this.agentLocationHistory.clear();
        this.lastAgentLocationAddedMillis = 0L;
        this.lastJumpMillis = 0L;
    }

    private double deviationFromTheRunningLine(Triple agentLocation) {
        if (this.fromNavPoint == null) {
            return 0.0;
        }
        if (this.toNavPoint == null) {
            return 1.0;
        }
        Tuple3D loc1 = this.fromNavPoint.location.asTuple3D();
        Tuple3D loc2 = this.toNavPoint.location.asTuple3D();
        Tuple3D agent = agentLocation.asTuple3D();
        Line3D line = Line3D.line3D(loc1, loc2);
        double distance = M.distance(line, agent);
        return distance;
    }

    private NavPoint getNavPointFromMemory(NavPoint np) {
        if (np == null) {
            return np;
        }
        NavPoint memoryNavPoint = this.gameMap.memory.getKnownNavPoints(new String[]{np.UnrealID}).get(np.UnrealID);
        if (memoryNavPoint != null) {
            return memoryNavPoint;
        }
        return np;
    }

    private void switchToNextNavPoint() {
        ++this.runningToNavPointIndex;
        this.fromNavPoint = this.toNavPoint;
        this.toNavPoint = this.getNavPointFromMemory(this.path.size() > this.runningToNavPointIndex ? this.path.get(this.runningToNavPointIndex) : null);
        if (this.toNavPoint != null) {
            if (this.fromNavPoint.neighboursMap != null) {
                this.edge = this.fromNavPoint.neighboursMap.get(this.toNavPoint.ID);
                this.log.info(this.logPrefix + "next navpoint " + this.toNavPoint.UnrealID);
            }
            if (this.edge != null && this.edge.neededJump != null) {
                this.log.info(this.logPrefix + "next edge needs jump!");
            }
        }
    }

    private NavPoint getNextNavPoint() {
        return this.path.size() > this.runningToNavPointIndex + 1 ? this.path.get(this.runningToNavPointIndex + 1) : null;
    }

    private Lift isNavpointLift(NavPoint np) {
        if (np.UnrealID.contains("LiftExit")) {
            return Lift.LIFT_EXIT;
        }
        if (np.UnrealID.contains("LiftCenter")) {
            return Lift.LIFT_CENTER;
        }
        return Lift.NO_LIFT;
    }

    public ArrayList<NavPoint> getPath(String pathId) {
        return this.pathsFromGB.get(pathId);
    }

    private double maxDistanceInAgentLocationHistory() {
        double distance = Double.MIN_VALUE;
        for (int i = 0; i < this.agentLocationHistory.size(); ++i) {
            Triple location1 = this.agentLocationHistory.get(i);
            for (int j = i + 1; j < this.agentLocationHistory.size(); ++j) {
                Triple location2 = this.agentLocationHistory.get(j);
                double d = Triple.distanceInPlane(location1, location2);
                if (!(d > distance)) continue;
                distance = d;
            }
        }
        return distance;
    }

    private boolean isStucked() {
        if (this.agentLocationHistory.size() < GameMapSettings.agentHistoryLength) {
            return false;
        }
        return this.maxDistanceInAgentLocationHistory() < GameMapSettings.minDistanceInAgentHistory;
    }

    private void jumpCheck(Triple agentLocation) {
        if (System.currentTimeMillis() - this.lastJumpMillis > GameMapSettings.jumpIntervalMillis && this.fromNavPoint != null && Triple.distanceInSpace(agentLocation, this.fromNavPoint.location) > GameMapSettings.allowJumpWhenFurtherThen && this.deviationFromTheRunningLine(agentLocation) > GameMapSettings.runningDeviation) {
            this.body.jump();
            this.lastJumpMillis = System.currentTimeMillis();
        }
    }

    public RunResult runAlongPath() {
        try {
            this.log.finer(this.logPrefix + "called, state " + (Object)((Object)this.runningState));
            Triple agentLocation = this.gameMap.memory.getAgentLocation();
            if (agentLocation == null) {
                this.log.severe(this.logPrefix + "can't get agent location!");
                this.restartPathManager();
                return RunResult.PATH_BROKEN;
            }
            if (this.agentLocationHistory.size() == 0 || Triple.distanceInSpace(agentLocation, this.agentLocationHistory.get(this.agentLocationHistory.size() - 1)) > 20.0) {
                this.agentLocationHistory.add(agentLocation);
                this.lastAgentLocationAddedMillis = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.lastAgentLocationAddedMillis > GameMapSettings.agentLocationHistoryTimeout) {
                this.agentLocationHistory.add(agentLocation);
                this.lastAgentLocationAddedMillis = System.currentTimeMillis();
            }
            if (this.agentLocationHistory.size() > GameMapSettings.agentHistoryLength) {
                this.agentLocationHistory.remove(0);
            }
            if (this.path == null) {
                this.log.severe(this.logPrefix + "can't run along the path as the path is null");
                this.restartPathManager();
                return RunResult.PATH_BROKEN;
            }
            if (this.path.size() == 0) {
                this.log.severe(this.logPrefix + "can't run along the path as the path doesn't contain any navpoints");
                this.restartPathManager();
                return RunResult.PATH_BROKEN;
            }
            switch (this.runningState) {
                case PATH_RESTARTED: {
                    return this.runAlongPath_PathRestartedState(agentLocation);
                }
                case RUNNING_TO_NAVPOINT: {
                    return this.runAlongPath_RunningToNavpointState(agentLocation);
                }
                case ENTERING_LIFT: {
                    return this.runAlongPath_EnteringLiftState(agentLocation);
                }
                case IN_CENTER_OF_THE_LIFT: {
                    return this.runAlongPath_InCenterOfTheLiftState(agentLocation);
                }
                case EXITING_LIFT: {
                    return this.runAlongPath_ExitingLift(agentLocation);
                }
            }
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        catch (Exception e) {
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
    }

    private RunResult runAlongPath_PathRestartedState(Triple agentLocation) {
        if (this.toNavPoint == null) {
            this.runningToNavPointIndex = 0;
            this.toNavPoint = this.getNavPointFromMemory(this.path.get(this.runningToNavPointIndex));
        }
        if (Triple.distanceInPlane(agentLocation, this.toNavPoint.location) < (double)GameMapSettings.switchingDistance) {
            this.log.info(this.logPrefix + "reached " + this.toNavPoint.UnrealID);
            this.switchToNextNavPoint();
            if (this.toNavPoint == null) {
                this.restartPathManager();
                this.log.info(this.logPrefix + " path ended");
                return RunResult.PATH_ENDED;
            }
            switch (this.isNavpointLift(this.fromNavPoint)) {
                case LIFT_EXIT: {
                    this.runningState = this.isNavpointLift(this.toNavPoint) == Lift.LIFT_CENTER ? RunAlongPathState.ENTERING_LIFT : RunAlongPathState.RUNNING_TO_NAVPOINT;
                    return this.runAlongPath();
                }
                case LIFT_CENTER: {
                    this.runningState = RunAlongPathState.IN_CENTER_OF_THE_LIFT;
                    return this.runAlongPath();
                }
            }
            this.runningState = RunAlongPathState.RUNNING_TO_NAVPOINT;
            return this.runAlongPath();
        }
        NavPoint nextNavPoint = this.getNextNavPoint();
        if (this.isNavpointLift(this.toNavPoint) == Lift.NO_LIFT) {
            this.body.move(1.0, this.toNavPoint.location, nextNavPoint != null ? nextNavPoint.location : null);
        } else {
            this.body.strafeToLocation(this.toNavPoint.location, nextNavPoint.location);
        }
        if (this.isStucked()) {
            this.log.severe(this.logPrefix + "STUCKED!");
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        return RunResult.RUNNING_ALONG;
    }

    private RunResult runAlongPath_RunningToNavpointState(Triple agentLocation) {
        if (Triple.distanceInSpace(agentLocation, this.toNavPoint.location) < (double)GameMapSettings.switchingDistance) {
            this.log.info(this.logPrefix + "arrived at " + this.toNavPoint.UnrealID);
            if (this.edge == null) {
                this.log.severe(this.logPrefix + "bot has followed an unknown edge, moving between navpoints:" + String.valueOf(this.fromNavPoint) + ", " + String.valueOf(this.toNavPoint));
            } else if (this.edge.neededJump != null) {
                double distance = Triple.distanceInPlane(agentLocation, this.edge.neededJump);
                this.log.info(this.logPrefix + "following edge where I need to " + (this.edge.forceDoubleJump ? "DOUBLE jump" : "jump") + " at " + this.edge.neededJump + ", current location " + agentLocation + ", disance " + distance);
                if (this.edge.forceDoubleJump) {
                    this.log.info(this.logPrefix + "double jump!");
                    this.body.doubleJump();
                } else {
                    this.log.info(this.logPrefix + "jump!");
                    this.body.jump();
                }
            }
            this.switchToNextNavPoint();
            if (this.toNavPoint == null) {
                this.restartPathManager();
                this.log.info(this.logPrefix + " path ended");
                return RunResult.PATH_ENDED;
            }
            switch (this.isNavpointLift(this.fromNavPoint)) {
                case LIFT_EXIT: {
                    this.runningState = this.isNavpointLift(this.toNavPoint) == Lift.LIFT_CENTER ? RunAlongPathState.ENTERING_LIFT : RunAlongPathState.RUNNING_TO_NAVPOINT;
                    return this.runAlongPath();
                }
                case LIFT_CENTER: {
                    this.log.severe(this.logPrefix + "we're in the LIFT_CENTER but we're not suppose to!");
                    this.restartPathManager();
                    return RunResult.PATH_BROKEN;
                }
            }
            this.runningState = RunAlongPathState.RUNNING_TO_NAVPOINT;
            return this.runAlongPath();
        }
        this.log.finer(this.logPrefix + "continuing movement");
        NavPoint nextNavPoint = this.getNextNavPoint();
        if (this.isNavpointLift(this.toNavPoint) == Lift.NO_LIFT) {
            this.body.move(1.0, this.toNavPoint.location, nextNavPoint != null ? nextNavPoint.location : null);
        } else if (nextNavPoint == null) {
            this.body.runToLocation(this.toNavPoint.location);
        } else {
            this.body.strafeToLocation(this.toNavPoint.location, nextNavPoint.location);
        }
        this.jumpCheck(agentLocation);
        if (this.isStucked()) {
            this.log.severe(this.logPrefix + "STUCKED!");
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        return RunResult.RUNNING_ALONG;
    }

    private Mover locateMover(Triple location) {
        ArrayList<Mover> movers = this.gameMap.memory.getSeeMovers();
        for (Mover mover : movers) {
            if (!(Triple.distanceInPlane(location, mover.location) < (double)GameMapSettings.switchingDistance)) continue;
            return mover;
        }
        return null;
    }

    private RunResult runAlongPath_EnteringLiftState(Triple agentLocation) {
        if (this.isNavpointLift(this.fromNavPoint) != Lift.LIFT_EXIT) {
            this.log.severe(this.logPrefix + "current navpoint is not LIFT_EXIT!");
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        if (this.isNavpointLift(this.toNavPoint) != Lift.LIFT_CENTER) {
            this.log.severe(this.logPrefix + "next navpoint is not LIFT_CENTER!");
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        if (!this.gameMap.memory.getSeeAnyMover()) {
            this.log.severe(this.logPrefix + "can't see any mover");
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        if (this.myMover == null) {
            this.myMover = this.locateMover(this.toNavPoint.location);
            if (this.myMover == null) {
                this.log.severe(this.logPrefix + "can't see mover I need to get onto");
                this.restartPathManager();
                return RunResult.PATH_BROKEN;
            }
        } else {
            this.myMover = this.gameMap.memory.getSeeMover(this.myMover.ID);
            if (this.myMover == null) {
                this.log.severe(this.logPrefix + "I've lost the mover from my field of view");
                this.restartPathManager();
                return RunResult.PATH_BROKEN;
            }
        }
        if (Math.abs(this.myMover.location.z - agentLocation.z) < (double)GameMapSettings.levelForEnteringLift) {
            if (this.waitingForLift) {
                this.waitingForLift = false;
                this.waitingForLiftStartedMillis = 0L;
            }
            if (Triple.distanceInPlane(agentLocation, this.toNavPoint.location) < (double)GameMapSettings.switchingDistance) {
                this.switchToNextNavPoint();
                this.runningState = RunAlongPathState.IN_CENTER_OF_THE_LIFT;
                this.zCoordWhenLiftCenterReached = agentLocation.z;
                this.returningToLiftExit = false;
                this.liftAttempts = 0;
                return this.runAlongPath();
            }
            NavPoint nextNavPoint = this.getNextNavPoint();
            if (nextNavPoint != null) {
                this.body.strafeToLocation(this.toNavPoint.location, nextNavPoint.location);
            } else {
                this.body.runToNavPoint(this.toNavPoint);
            }
            return RunResult.RUNNING_ALONG;
        }
        if (Triple.distanceInSpace(agentLocation, this.fromNavPoint.location) > (double)GameMapSettings.switchingDistance) {
            if (this.returningToLiftExit) {
                return RunResult.RUNNING_ALONG;
            }
            this.body.strafeToLocation(this.fromNavPoint.location, this.toNavPoint.location);
            this.returningToLiftExit = true;
            ++this.liftAttempts;
            if (this.liftAttempts > GameMapSettings.maxLiftAttempts) {
                this.restartPathManager();
                return RunResult.PATH_BROKEN;
            }
            return RunResult.RUNNING_ALONG;
        }
        if (this.returningToLiftExit) {
            this.returningToLiftExit = false;
        }
        if (!this.waitingForLift) {
            this.waitingForLift = true;
            this.waitingForLiftStartedMillis = System.currentTimeMillis();
            return RunResult.RUNNING_ALONG;
        }
        if (System.currentTimeMillis() - this.waitingForLiftStartedMillis > GameMapSettings.maxLiftWaitTimeMillis) {
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        return RunResult.RUNNING_ALONG;
    }

    private RunResult runAlongPath_InCenterOfTheLiftState(Triple agentLocation) {
        if (Math.abs(agentLocation.z - this.toNavPoint.location.z) < (double)GameMapSettings.levelForLeavingLift) {
            NavPoint nextNavPoint = this.getNextNavPoint();
            if (this.isNavpointLift(this.toNavPoint) == Lift.NO_LIFT) {
                this.body.move(1.0, this.toNavPoint.location, nextNavPoint != null ? nextNavPoint.location : null);
            } else {
                this.body.strafeToLocation(this.toNavPoint.location, nextNavPoint.location);
            }
            this.switchToNextNavPoint();
            this.runningState = RunAlongPathState.EXITING_LIFT;
            this.waitingForLift = false;
            this.waitingForLiftStartedMillis = 0L;
            return this.runAlongPath();
        }
        if (!this.waitingForLift) {
            this.waitingForLift = true;
            this.waitingForLiftStartedMillis = System.currentTimeMillis();
            return RunResult.RUNNING_ALONG;
        }
        if (System.currentTimeMillis() - this.waitingForLiftStartedMillis > GameMapSettings.maxLiftWaitTimeMillis) {
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        if (Math.abs(this.zCoordWhenLiftCenterReached - agentLocation.z) < 20.0) {
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        return RunResult.RUNNING_ALONG;
    }

    private RunResult runAlongPath_ExitingLift(Triple agentLocation) {
        if (Triple.distanceInSpace(agentLocation, this.fromNavPoint.location) < (double)GameMapSettings.switchingDistance) {
            this.log.info(this.logPrefix + "arrived at " + this.toNavPoint.UnrealID);
            if (this.toNavPoint == null) {
                this.restartPathManager();
                this.log.info(this.logPrefix + " path ended");
                return RunResult.PATH_ENDED;
            }
            switch (this.isNavpointLift(this.toNavPoint)) {
                case LIFT_EXIT: {
                    this.runningState = this.isNavpointLift(this.toNavPoint) == Lift.LIFT_CENTER ? RunAlongPathState.ENTERING_LIFT : RunAlongPathState.RUNNING_TO_NAVPOINT;
                    return this.runAlongPath();
                }
                case LIFT_CENTER: {
                    this.log.severe(this.logPrefix + "we're in the LIFT_CENTER but we're not suppose to!");
                    this.restartPathManager();
                    return RunResult.PATH_BROKEN;
                }
            }
            this.runningState = RunAlongPathState.RUNNING_TO_NAVPOINT;
            return this.runAlongPath();
        }
        this.log.finer(this.logPrefix + "continuing movement");
        if (this.toNavPoint == null) {
            this.body.runToLocation(this.fromNavPoint.location);
            return RunResult.RUNNING_ALONG;
        }
        switch (this.isNavpointLift(this.fromNavPoint)) {
            case LIFT_EXIT: {
                if (this.isNavpointLift(this.toNavPoint) == Lift.LIFT_CENTER) {
                    this.body.strafeToLocation(this.fromNavPoint.location, this.toNavPoint.location);
                } else {
                    this.body.move(1.0, this.fromNavPoint.location, this.toNavPoint.location);
                }
                if (this.isStucked()) {
                    this.log.severe(this.logPrefix + "STUCKED!");
                    this.restartPathManager();
                    return RunResult.PATH_BROKEN;
                }
                return RunResult.RUNNING_ALONG;
            }
            case LIFT_CENTER: {
                this.log.severe(this.logPrefix + "we're in the LIFT_CENTER but we're not suppose to!");
                this.restartPathManager();
                return RunResult.PATH_BROKEN;
            }
        }
        this.body.move(1.0, this.fromNavPoint.location, this.toNavPoint.location);
        if (this.isStucked()) {
            this.log.severe(this.logPrefix + "STUCKED!");
            this.restartPathManager();
            return RunResult.PATH_BROKEN;
        }
        return RunResult.RUNNING_ALONG;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Lift {
        LIFT_EXIT,
        LIFT_CENTER,
        NO_LIFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunResult {
        RUNNING_ALONG,
        PATH_ENDED,
        PATH_BROKEN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RunAlongPathState {
        PATH_RESTARTED,
        RUNNING_TO_NAVPOINT,
        ENTERING_LIFT,
        IN_CENTER_OF_THE_LIFT,
        EXITING_LIFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathResult {
        OBTAINING_PATH,
        NO_PATH,
        PATH_FOUND;

    }
}

