/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.vertexSpace.vertex3Dspace;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.extended.Vertex3D;
import java.util.ArrayList;
import java.util.HashSet;

public class Vertex3DSpaceCube {
    protected double[] x;
    protected double[] y;
    protected double[] z;
    protected int precisionInt;
    protected double precision;
    protected final int hashCode;
    HashSet vertices = new HashSet();

    public static int getHash(double x, double y, double z, double size, int precisionInt) {
        long precision = Math.round(Math.pow(10.0, precisionInt));
        HashCodes hc = HashCodes.getNewCounter();
        long iX = Math.round(x * (double)precision);
        long iY = Math.round(y * (double)precision);
        long iZ = Math.round(z * (double)precision);
        hc.add(HashCodes.hash(iX));
        hc.add(HashCodes.hash(iY));
        hc.add(HashCodes.hash(iZ));
        long iPrec = Math.round(size * (double)precision);
        hc.add(HashCodes.hash(iPrec));
        return hc.getHashCode();
    }

    public Vertex3DSpaceCube(double iX, double iY, double iZ, double iSize, int iPrecisionInt) {
        this.precisionInt = iPrecisionInt;
        this.precision = Math.pow(10.0, -this.precisionInt);
        long temp = Math.round(Math.pow(10.0, this.precisionInt));
        iX = (double)Math.round(iX * (double)temp) * this.precision;
        iY = (double)Math.round(iY * (double)temp) * this.precision;
        iZ = (double)Math.round(iZ * (double)temp) * this.precision;
        this.x = new double[]{iX, iX + iSize};
        this.y = new double[]{iY, iY + iSize};
        this.z = new double[]{iZ, iZ + iSize};
        this.hashCode = Vertex3DSpaceCube.getHash(iX, iY, iZ, iSize, this.precisionInt);
    }

    public Vertex3DSpaceCube(double[] xyz, double iSize, int iPrecisionInt) {
        this.x = new double[]{xyz[0], xyz[0] + iSize};
        this.y = new double[]{xyz[1], xyz[1] + iSize};
        this.z = new double[]{xyz[2], xyz[2] + iSize};
        this.precisionInt = iPrecisionInt;
        this.precision = Math.pow(10.0, -this.precisionInt);
        this.hashCode = Vertex3DSpaceCube.getHash(xyz[0], xyz[1], xyz[2], iSize, this.precisionInt);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vertex3DSpaceCube)) {
            return false;
        }
        Vertex3DSpaceCube vsc = (Vertex3DSpaceCube)obj;
        if (vsc.precisionInt != this.precisionInt) {
            return false;
        }
        return M.equals(vsc.x[0], this.x[0], this.precision) && M.equals(vsc.x[1], this.x[1], this.precision) && M.equals(vsc.y[0], this.y[0], this.precision) && M.equals(vsc.z[0], this.z[0], this.precision);
    }

    public ArrayList check(Tuple3D tuple) {
        ArrayList<Tuple3D> al = new ArrayList<Tuple3D>();
        for (Tuple3D t : this.vertices) {
            if (!M.equals(tuple, t, this.precision)) continue;
            al.add(t);
        }
        return al;
    }

    public void remove(Vertex3D vertex) {
        this.vertices.remove(vertex);
    }

    public Vertex3D addReferenceUnsafe(Vertex3D v) {
        this.vertices.add(v);
        return v;
    }
}

