/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.extended;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Plane3D;
import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.extended.Segment3D;
import cz.cuni.utils.math.extended.Vertex3D;
import java.util.HashMap;
import java.util.Iterator;

public class Triangle3D {
    public Vertex3D[] vertices = new Vertex3D[]{null, null, null};
    protected HashMap verticesHM = new HashMap();
    public double[] min = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
    public double[] max = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
    public Plane3D plane = null;
    protected Tuple3D orthocenter = null;
    public final int hashCode;

    protected void init() {
    }

    protected void initVertices(Vertex3D v1, Vertex3D v2, Vertex3D v3) {
        this.setVertexAndHM(0, v1);
        this.setVertexAndHM(1, v2);
        this.setVertexAndHM(2, v3);
        this.recountMinMax();
    }

    protected void initVerticesFromEdges(Segment3D s1, Segment3D s2, Segment3D s3) {
        this.verticesHM.put(s1.ab[0], 0);
        this.verticesHM.put(s1.ab[1], 0);
        if (!this.verticesHM.containsKey(s2.ab[0])) {
            this.verticesHM.put(s2.ab[0], 0);
        }
        if (!this.verticesHM.containsKey(s2.ab[1])) {
            this.verticesHM.put(s2.ab[1], 0);
        }
        if (!this.verticesHM.containsKey(s3.ab[0])) {
            this.verticesHM.put(s3.ab[0], 0);
        }
        if (!this.verticesHM.containsKey(s3.ab[1])) {
            this.verticesHM.put(s3.ab[1], 0);
        }
        if (this.verticesHM.size() != 3) {
            System.out.println("Triangle3D.Triangle(edge, edge, edge): wrong edges, they don't form an triangle.");
        }
        Iterator iter = this.verticesHM.keySet().iterator();
        this.setVertex(0, (Vertex3D)iter.next());
        this.setVertex(1, (Vertex3D)iter.next());
        this.setVertex(2, (Vertex3D)iter.next());
        this.recountMinMax();
    }

    public Triangle3D(Vertex3D v1, Vertex3D v2, Vertex3D v3) {
        this.init();
        this.initVertices(v1, v2, v3);
        this.hashCode = this.countHashCode();
        this.recountPlane();
    }

    public Triangle3D(Segment3D s1, Segment3D s2, Segment3D s3) {
        this.init();
        this.initVerticesFromEdges(s1, s2, s3);
        this.hashCode = this.countHashCode();
        this.recountPlane();
    }

    public String toString() {
        return "Triangle3D(" + this.vertices[0] + ", " + this.vertices[1] + ", " + this.vertices[2] + ")";
    }

    protected int countHashCode() {
        boolean v01 = M.equals(this.vertices[0], this.vertices[1]);
        boolean v02 = M.equals(this.vertices[0], this.vertices[2]);
        if (v01 && v02) {
            return 0;
        }
        boolean v12 = M.equals(this.vertices[1], this.vertices[2]);
        if (v01 || v02 || v12) {
            return 1;
        }
        if (M.isCollinear(this.vertices[0], this.vertices[1], this.vertices[2])) {
            return 1;
        }
        HashCodes hc = HashCodes.getNewCounter();
        Vertex3D[] o01 = M.normalizedOrder(this.vertices[0], this.vertices[1]);
        Vertex3D[] o02 = M.normalizedOrder(this.vertices[0], this.vertices[2]);
        Vertex3D[] o12 = M.normalizedOrder(this.vertices[1], this.vertices[2]);
        if (o01[0] == o02[0]) {
            hc.add(HashCodes.hash(this.vertices[0]));
            hc.add(HashCodes.hash(o12[0]));
            hc.add(HashCodes.hash(o12[1]));
        } else if (o01[0] == o12[0]) {
            hc.add(HashCodes.hash(this.vertices[1]));
            hc.add(HashCodes.hash(o02[0]));
            hc.add(HashCodes.hash(o02[1]));
        } else {
            hc.add(HashCodes.hash(this.vertices[2]));
            hc.add(HashCodes.hash(o01[0]));
            hc.add(HashCodes.hash(o01[1]));
        }
        return hc.getHashCode();
    }

    protected void setVertexAndHM(int index, Vertex3D vertex) {
        this.verticesHM.remove(this.vertices[index]);
        this.vertices[index] = vertex;
        this.verticesHM.put(vertex, index);
    }

    protected void setVertex(int index, Vertex3D vertex) {
        this.vertices[index] = vertex;
    }

    public Vertex3D getVertex3D(int index) {
        return this.vertices[index];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Triangle3D)) {
            return false;
        }
        Triangle3D t = (Triangle3D)o;
        return this.verticesHM.containsKey(t.vertices[0]) && this.verticesHM.containsKey(t.vertices[1]) && this.verticesHM.containsKey(t.vertices[2]);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected void checkMinMax(Vertex3D v) {
        for (int i = 0; i < 3; ++i) {
            if (v.xyz[i] < this.min[i]) {
                this.min[i] = v.xyz[i];
            }
            if (!(v.xyz[i] > this.max[i])) continue;
            this.max[i] = v.xyz[i];
        }
    }

    protected void recountMinMax() {
        this.min[0] = Double.POSITIVE_INFINITY;
        this.min[1] = Double.POSITIVE_INFINITY;
        this.min[2] = Double.POSITIVE_INFINITY;
        this.max[0] = Double.NEGATIVE_INFINITY;
        this.max[1] = Double.NEGATIVE_INFINITY;
        this.max[2] = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 3; ++i) {
            this.checkMinMax(this.vertices[i]);
        }
    }

    public void recountPlane() {
        this.plane = new Plane3D(this.vertices[0], this.vertices[1], this.vertices[2]);
    }

    public void recountPlane(Tuple3D normal) {
        this.plane = new Plane3D(normal, this.vertices[0]);
    }

    public boolean hasVertex(Vertex3D v) {
        return this.verticesHM.containsKey(v);
    }

    public boolean swapVertex(Vertex3D toBeSwapped, Vertex3D newVertex) {
        if (this.verticesHM.containsKey(toBeSwapped)) {
            this.setVertex((Integer)this.verticesHM.get(toBeSwapped), newVertex);
            return true;
        }
        return false;
    }

    public Tuple3D getOrthocenter() {
        if (this.orthocenter != null) {
            return new Tuple3D(this.orthocenter);
        }
        Tuple3D middle = new Tuple3D(0.0, 0.0, 0.0);
        for (int i = 0; i < 3; ++i) {
            middle.plus(this.vertices[i]);
        }
        this.orthocenter = middle = M.multi(middle, 0.3333333333333333);
        return new Tuple3D(this.orthocenter);
    }
}

