/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.extended;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.Line3D;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.extended.Line3DExtended;
import cz.cuni.utils.math.extended.Vertex3D;

public class Segment3D {
    public Line3DExtended line;
    public Vertex3D[] ab = new Vertex3D[]{null, null};
    public Vertex3D[] abN = new Vertex3D[]{null, null};
    public double length;
    public final int hashCode;

    public Segment3D(Vertex3D a, Vertex3D b) {
        this.ab[0] = a;
        this.ab[1] = b;
        this.abN = M.normalizedOrder(a, b);
        this.line = Line3DExtended.line3D(a, b);
        this.length = M.distance((Tuple3D)this.ab[0], (Tuple3D)this.ab[1]);
        this.hashCode = this.countHashCode();
    }

    public Segment3D(Segment3D s) {
        this.ab[0] = (Vertex3D)s.ab[0].clone();
        this.ab[1] = (Vertex3D)s.ab[1].clone();
        this.abN = M.normalizedOrder(this.ab[0], this.ab[1]);
        this.line = Line3DExtended.line3D(this.ab[0], this.ab[1]);
        this.length = M.distance((Tuple3D)this.ab[0], (Tuple3D)this.ab[1]);
        this.hashCode = this.countHashCode();
    }

    protected int countHashCode() {
        if (this.abN == null) {
            return 0;
        }
        HashCodes hc = HashCodes.getNewCounter();
        hc.add(HashCodes.hash(this.abN[0]));
        hc.add(HashCodes.hash(this.abN[1]));
        return hc.getHashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Segment3D)) {
            return false;
        }
        return this.equals((Segment3D)o);
    }

    public boolean equals(Segment3D s) {
        if (s == null) {
            return false;
        }
        if (this.hashCode != s.hashCode) {
            return false;
        }
        return this.abN[0].equals(s.abN[0]) && this.abN[1].equals(s.abN[1]);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public double length() {
        return this.length;
    }

    public boolean hasVertex(Vertex3D v) {
        return this.ab[0] != null && this.ab[0].equals(v) || this.ab[1] != null && this.ab[1].equals(v);
    }

    public String toString() {
        return "Segment3D(" + this.abN[0] + "," + this.abN[1] + ")";
    }

    public boolean inLine(Line3D iLine) {
        return M.equals(M.normalizedNormal(this.line.direction), M.normalizedNormal(iLine.direction));
    }

    public Vertex3D getOtherVertex(Vertex3D previousVertex) {
        if (this.ab[0].equals(previousVertex)) {
            return this.ab[1];
        }
        return this.ab[0];
    }

    public Vertex3D sharedVertex(Segment3D s) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (!this.ab[i].equals(s.ab[j])) continue;
                return this.ab[i];
            }
        }
        return null;
    }
}

