/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple2D;
import cz.cuni.utils.math.Tuple3D;

public class Line2D {
    public Tuple2D direction;
    public Tuple2D point;
    public Tuple2D normal;
    public Tuple3D equation;

    public Line2D() {
        this.direction = null;
        this.point = null;
    }

    public Line2D(Tuple2D iDirection, Tuple2D iPoint) {
        this.direction = new Tuple2D(iDirection);
        this.point = new Tuple2D(iPoint);
        this.normal = M.perpendicular(this.direction);
        this.recountEquationFromNormal();
    }

    public String toString() {
        return "Line2D(" + this.point + ", <-> " + this.direction + ")";
    }

    public static Line2D line2D(Tuple2D pointA, Tuple2D pointB) {
        return new Line2D(new Tuple2D(pointA, pointB), pointA);
    }

    public void assign(Tuple2D iDirection, Tuple2D iPoint) {
        this.direction = iDirection;
        this.point = iPoint;
        this.normal = M.perpendicular(this.direction);
        this.recountEquationFromNormal();
    }

    public void countLine(Tuple2D pointA, Tuple2D pointB) {
        this.direction = new Tuple2D(pointA, pointB);
        this.point = pointA;
        this.normal = M.perpendicular(this.direction);
        this.equation = new Tuple3D(this.normal.xy[0], this.normal.xy[1], -this.normal.xy[0] * this.point.xy[0] - this.normal.xy[1] * this.point.xy[1]);
    }

    public Tuple2D getCommonPoint() {
        if (!M.equals(this.direction.xy[0], 0.0)) {
            double t = M.linearEq(this.direction.xy[0], this.point.xy[0], 1.0);
            return new Tuple2D(1.0, this.direction.xy[1] * t + this.point.xy[1]);
        }
        if (!M.equals(this.direction.xy[1], 0.0)) {
            double t = M.linearEq(this.direction.xy[1], this.point.xy[1], 1.0);
            return new Tuple2D(this.direction.xy[0] * t + this.point.xy[0], 1.0);
        }
        return new Tuple2D(0.0, 0.0);
    }

    public boolean inLine(Tuple2D testedPoint) {
        return this.inLine(testedPoint, M.EPSILON);
    }

    public boolean inLine(Tuple2D testedPoint, double precision) {
        if (!M.equals(this.direction.xy[0], 0.0)) {
            double t = M.linearEq(this.direction.xy[0], this.point.xy[0], testedPoint.xy[0]);
            double y = this.direction.xy[1] * t + this.point.xy[1];
            return M.equals(testedPoint.xy[1], y, precision);
        }
        if (!M.equals(this.direction.xy[1], 0.0)) {
            double t = M.linearEq(this.direction.xy[1], this.point.xy[1], testedPoint.xy[1]);
            double x = this.direction.xy[0] * t + this.point.xy[0];
            return M.equals(testedPoint.xy[0], x, precision);
        }
        return false;
    }

    public void recountEquationFromNormal() {
        this.equation = new Tuple3D(this.normal.xy[0], this.normal.xy[1], -this.normal.xy[0] * this.point.xy[0] - this.normal.xy[1] * this.point.xy[1]);
    }
}

