/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Armor;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.introspection.PogProp;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

public class TestBot
extends Agent {
    protected Item choosenItem = null;
    protected ArrayList<Item> choosenMedKits = null;
    private ArrayList<Item> itemsToRunAround = null;
    private Player lastEnemy = null;
    private Player enemy = null;
    protected final int MAX_ATTEMPTS = 10;
    protected Item previousChoosenItem = null;
    protected int walkingAttempts = 0;
    private boolean jumped;
    @PogProp
    public boolean useAStar = false;
    @PogProp
    public boolean shouldEngage = true;
    @PogProp
    public boolean shouldPursue = true;
    @PogProp
    public boolean shouldRearm = true;
    @PogProp
    public boolean shouldCollectItems = true;
    @PogProp
    public boolean shouldCollectHealth = true;
    @PogProp
    public int healthLevel = 90;
    @PogProp
    public int frags = 0;
    @PogProp
    public int deaths = 0;

    public TestBot() {
        this.log.setLevel(Level.INFO);
        this.platformLog.setLevel(Level.INFO);
    }

    protected void prePrepareAgent() {
        this.body.initializer.setTeam(1);
    }

    protected void postPrepareAgent() {
        this.itemsToRunAround = new ArrayList();
        for (Weapon weapon : this.memory.getKnownWeapons()) {
            this.itemsToRunAround.add(weapon);
        }
        for (Armor armor : this.memory.getKnownArmors()) {
            this.itemsToRunAround.add(armor);
        }
        Collections.shuffle(this.itemsToRunAround);
        this.body.initializer.setBotSkillLevel(4);
        if (this.memory.getGameInfo().gameType.contains("CTF")) {
            int n;
            int red = this.memory.getPlayerCount(0);
            if (red > (n = this.memory.getPlayerCount(1))) {
                this.body.initializer.setTeam(1);
            } else if (red < n) {
                this.body.initializer.setTeam(0);
            } else if (this.random.nextInt(2) == 0) {
                this.body.initializer.setTeam(0);
            } else {
                this.body.initializer.setTeam(1);
            }
        }
    }

    protected void doLogic() {
        if (this.shouldRearm && this.memory.getSeeAnyEnemy() && this.hasBetterWeapon()) {
            this.stateChangeToBetterWeapon();
            return;
        }
        if (this.shouldEngage && this.memory.getSeeAnyEnemy() && this.memory.hasAnyLoadedWeapon()) {
            this.stateEngage();
            return;
        }
        if (this.memory.isShooting()) {
            this.stateStopShooting();
            return;
        }
        if (this.memory.isBeingDamaged()) {
            this.stateHit();
            return;
        }
        if (this.lastEnemy != null && this.shouldPursue && this.memory.hasAnyLoadedWeapon()) {
            this.stateGoAtLastEnemyPosition();
            return;
        }
        if (this.memory.isColliding()) {
            this.stateWalking();
            return;
        }
        if (this.shouldCollectItems && this.seeAnyReachableItemAndWantIt()) {
            this.stateSeeItem();
            return;
        }
        if (this.memory.getAgentHealth() < this.healthLevel && this.canRunAlongMedKit()) {
            this.stateMedKit();
            return;
        }
        this.stateRunAroundItems();
    }

    protected void stateChangeToBetterWeapon() {
        this.log.log(Level.INFO, "Decision is: CHANGE WEAPON");
        if (this.memory.getAgentLocation() == null || this.memory.getSeeEnemy() == null || this.memory.getSeeEnemy().location == null) {
            return;
        }
        AddWeapon weapon = this.memory.getBetterWeapon(this.memory.getAgentLocation(), this.memory.getSeeEnemy().location);
        if (weapon != null) {
            this.body.changeWeapon(weapon);
        }
    }

    protected boolean hasBetterWeapon() {
        Player enemy = this.memory.getSeeEnemy();
        if (this.memory.getAgentLocation() == null || enemy == null || enemy.location == null) {
            return false;
        }
        AddWeapon weapon = this.memory.getBetterWeapon(this.memory.getAgentLocation(), enemy.location);
        return weapon != null;
    }

    protected void stateEngage() {
        this.log.log(Level.INFO, "Decision is: ENGAGE");
        if (this.enemy != null) {
            this.lastEnemy = this.enemy;
            this.enemy = this.memory.getSeePlayer(this.enemy.ID);
            if (this.enemy == null) {
                if (this.memory.isShooting()) {
                    this.body.stopShoot();
                }
                return;
            }
        }
        if (this.enemy == null) {
            this.enemy = this.memory.getSeeEnemy();
            if (this.enemy == null) {
                this.body.stop();
                this.body.stopShoot();
                return;
            }
        }
        AddWeapon weapon = null;
        if (!this.memory.hasLoadedWeapon() && this.memory.hasAnyLoadedWeapon()) {
            this.platformLog.info("no ammo - switching weapon " + this.memory.hasLoadedWeapon() + " " + this.memory.getAnyWeapon() + "\nCurrent Weapon:" + this.memory.getCurrentWeapon() + "\nWeapons : " + this.memory.getAllWeapons().toString());
            weapon = this.memory.getAnyWeapon();
            if (weapon != null && (this.memory.getCurrentWeapon() == null || this.memory.getCurrentWeapon() != null && !weapon.weaponType.equals((Object)this.memory.getCurrentWeapon().weaponType))) {
                this.platformLog.info("no ammo - switching weapon: " + weapon);
                this.body.changeWeapon(weapon);
            }
        }
        double distance = Triple.distanceInSpace(this.memory.getAgentLocation(), this.enemy.location);
        if (this.memory.getCurrentWeapon() != null && (double)this.memory.getCurrentWeapon().maxDist > distance) {
            this.platformLog.info("Would like to shoot at enemy!!!");
            if (!this.memory.isShooting()) {
                this.body.shoot(this.enemy);
            } else {
                this.body.turnToTarget(this.enemy);
            }
        }
        int decentDistance = Math.round(this.random.nextFloat() * 800.0f) + 200;
        if (this.memory.getAgentLocation() != null && this.enemy != null && this.enemy.location != null && Triple.distanceInSpace(this.memory.getAgentLocation(), this.enemy.location) < (double)decentDistance) {
            if (this.memory.isMoving()) {
                this.body.stop();
            }
        } else {
            this.body.runToTarget(this.enemy);
            this.jumped = false;
        }
    }

    protected void stateStopShooting() {
        this.log.log(Level.INFO, "Decision is: STOP_SHOOTING");
        this.body.stopShoot();
    }

    protected void stateHit() {
        this.log.log(Level.INFO, "Decision is: HIT");
        this.body.turnHorizontal(55);
    }

    protected void stateWalking() {
        this.log.log(Level.INFO, "Decision is: WALKING");
        if (this.memory.isColliding()) {
            if (!this.jumped) {
                this.body.doubleJump();
                this.jumped = true;
            } else {
                this.body.stop();
                this.jumped = false;
            }
        }
        if (this.memory.isFalling()) {
            this.body.sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ...");
        }
        if (this.memory.isBumpingToAnotherActor()) {
            this.body.stop();
        }
    }

    protected void stateGoAtLastEnemyPosition() {
        this.log.log(Level.INFO, "Decision is: PURSUE");
        if (!this.gameMap.safeRunToLocation(this.lastEnemy.location)) {
            this.log.info("Ended at the enemy possition or failed - > STOP THE CHASE.");
            this.previousChoosenItem = this.choosenItem;
            this.lastEnemy = null;
        }
    }

    protected boolean canRunAlongMedKit() {
        if (this.choosenMedKits == null) {
            this.choosenMedKits = this.gameMap.nearestHealth(4, 8);
        }
        if (this.choosenMedKits.isEmpty()) {
            this.choosenMedKits = null;
            return false;
        }
        if (Triple.distanceInSpace(this.choosenMedKits.get((int)0).location, this.memory.getAgentLocation()) < 15.0) {
            if (this.choosenMedKits.size() > 2) {
                this.choosenMedKits.remove(0);
            } else {
                this.choosenItem = null;
                return false;
            }
        }
        return true;
    }

    protected void stateMedKit() {
        this.log.log(Level.INFO, "Decision is: RUN_MED_KITS");
        this.gameMap.runAroundItemsInTheMap(this.choosenMedKits, this.useAStar);
    }

    private Weapon chooseWeapon() {
        ArrayList<Weapon> weapons = this.memory.getSeeReachableWeapons();
        for (Weapon weapon : weapons) {
            if (this.memory.getCurrentWeapon() == null) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee && !weapon.isMelee() && !this.memory.hasWeaponOfType(weapon.weaponType)) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee || !weapon.isMelee() || this.memory.hasWeaponOfType(weapon.weaponType)) continue;
            return weapon;
        }
        Weapon chosen = this.memory.getSeeReachableWeapon();
        if (!this.memory.hasWeaponOfType(chosen.weaponType)) {
            return chosen;
        }
        return null;
    }

    private Item chooseItem() {
        if (this.memory.getSeeAnyReachableWeapon()) {
            return this.chooseWeapon();
        }
        if (this.memory.getSeeAnyReachableArmor()) {
            return this.memory.getSeeReachableArmor();
        }
        if (this.memory.getSeeAnyReachableHealth()) {
            Health health = this.memory.getSeeReachableHealth();
            if (this.memory.getAgentHealth() < 100) {
                return health;
            }
            if (health.boostable) {
                return health;
            }
        }
        if (this.memory.getSeeAnyReachableAmmo() && this.memory.isAmmoSuitable(this.memory.getSeeReachableAmmo())) {
            return this.memory.getSeeReachableAmmo();
        }
        return null;
    }

    private boolean seeAnyReachableItemAndWantIt() {
        if (this.memory.getSeeAnyReachableItem()) {
            this.choosenItem = this.chooseItem();
            if (this.choosenItem != null) {
                this.log.info("NEW ITEM CHOSEN: " + this.choosenItem);
                this.log.info("LAST CHOOSEN ITEM: " + this.previousChoosenItem);
            }
        } else {
            this.choosenItem = null;
        }
        return this.choosenItem != null && !this.choosenItem.equals(this.previousChoosenItem);
    }

    protected void stateSeeItem() {
        this.log.log(Level.INFO, "Decision is: SEE_ITEM --- Running for: " + this.choosenItem.toString());
        if (!this.gameMap.safeRunToLocation(this.choosenItem.location)) {
            this.log.info("unable to REACH the choosen item");
            this.previousChoosenItem = this.choosenItem;
            this.choosenItem = null;
        }
        this.jumped = false;
    }

    protected void stateRunAroundItems() {
        this.log.log(Level.INFO, "Decision is: RUN_AROUND_ITEMS");
        this.gameMap.runAroundItemsInTheMap(this.itemsToRunAround, this.useAStar);
    }

    public void receiveMessage(RcvMsgEvent e) {
        super.receiveMessage(e);
        switch (e.getMessage().type) {
            case PLAYER_KILLED: {
                ++this.frags;
                break;
            }
            case BOT_KILLED: {
                ++this.deaths;
            }
        }
    }

    public static void main(String[] Args) throws URISyntaxException, InterruptedException {
        for (int i = 0; i < 4; ++i) {
            TestBot bot = new TestBot();
            AgentLauncher agent = new AgentLauncher(bot, new URI("ut://localhost:3000"), true);
            agent.launch();
        }
    }
}

