/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.BeginMessage;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.server.BotEnteredWorldListener;
import cz.cuni.pogamut.server.BotLeftWorldListener;
import cz.cuni.pogamut.server.UTServer;
import cz.cuni.utils.Flag;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTServerLagObserver {
    protected Logger log = Logger.getAnonymousLogger();
    protected Flag<Boolean> inLag = new Flag<Boolean>(false);
    boolean first = true;
    protected BotEnteredWorldListener botEnteredListener = new BotEnteredWorldListener(){

        public void botEnteredWorld(String unrealId) {
        }

        public void botEnteredWorld(Agent bot) {
            if (UTServerLagObserver.this.first) {
                UTServerLagObserver.this.first = false;
                bot.getBody().addRcvMsgListener(new RcvMsgListener(){
                    long lastTime = System.currentTimeMillis();
                    double lastGameTime = 0.0;

                    public synchronized void receiveMessage(RcvMsgEvent e) {
                        if (e.getMessage().getType().equals((Object)MessageType.BEGIN)) {
                            BeginMessage beg = (BeginMessage)e.getMessage();
                            double gameLag = beg.time - this.lastGameTime;
                            long cur = System.currentTimeMillis();
                            long lag = cur - this.lastTime;
                            UTServerLagObserver.this.log.info(Long.toString(lag) + " " + gameLag);
                            this.lastTime = cur;
                            this.lastGameTime = beg.time;
                        }
                    }
                });
            }
        }
    };
    protected BotLeftWorldListener botLeftListener = new BotLeftWorldListener(){

        public void botLeftWorld(String unrealId) {
        }

        public void botLeftWorld(Agent bot) {
        }
    };

    public Logger getLog() {
        return this.log;
    }

    public UTServerLagObserver(UTServer server) {
        server.addBotEnteredWorldListener(this.botEnteredListener);
    }

    public Flag<Boolean> isInLag() {
        return this.isInLag();
    }
}

