/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.astar.AStarGoal;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.NeighNavFlag;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.util.Collection;

public class GameMapAStarGoal
implements AStarGoal {
    private NavPoint goalNode;

    private NavPoint getNavPoint(Object node) {
        if (node instanceof NavPoint) {
            return (NavPoint)node;
        }
        if (node instanceof NeighNav) {
            return ((NeighNav)node).neighbour;
        }
        System.out.println("GameMapAStarGoal.getNode(): wrong node type");
        return null;
    }

    public GameMapAStarGoal(NavPoint goalNode) {
        this.goalNode = goalNode;
    }

    public int getEstimatedDistanceToGoal(Object node) {
        NavPoint np = this.getNavPoint(node);
        assert (np != null);
        return (int)Math.round(Triple.distanceInSpace(np.location, this.goalNode.location) * 1000.0);
    }

    public int getExtraCost(Object nodeFrom, Object nodeTo) {
        return 0;
    }

    public boolean isGoalReached(Object actualNode) {
        NavPoint np = this.getNavPoint(actualNode);
        assert (np != null);
        return this.goalNode.equals(np);
    }

    public boolean isNodeOpened(Object node) {
        if (!(node instanceof NeighNav)) {
            return true;
        }
        NeighNav nn = (NeighNav)node;
        int flags = nn.flags;
        if (flags > 1023) {
            System.out.println("Big flag: " + String.valueOf(flags));
        }
        if (NeighNavFlag.FLY.isSet(flags)) {
            return false;
        }
        if (NeighNavFlag.PLAYERONLY.isSet(flags)) {
            return false;
        }
        if (NeighNavFlag.FORCED.isSet(flags)) {
            return false;
        }
        if (NeighNavFlag.JUMP.isSet(flags)) {
            return true;
        }
        if (NeighNavFlag.SPECIAL.isSet(flags)) {
            return true;
        }
        return !NeighNavFlag.LADDER.isSet(flags);
    }

    public void setCloseList(Collection closeList) {
    }

    public void setOpenList(Collection openList) {
    }
}

