/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentIterationEndEvent;
import cz.cuni.pogamut.Client.AgentIterationEndListener;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.experiments.ExperimentGlobals;
import cz.cuni.pogamut.experiments.ExperimentRules;
import cz.cuni.pogamut.experiments.ExperimentStartup;
import cz.cuni.pogamut.server.BotEnteredWorldListener;
import cz.cuni.pogamut.server.BotLeftWorldListener;
import cz.cuni.pogamut.server.UTServer;
import cz.cuni.pogamut.server.UTWorld;
import cz.cuni.utils.BotProjectsClassLoader;
import cz.cuni.utils.Flag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.drools.FactHandle;
import org.drools.StatefulSession;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.compiler.DroolsParserException;

public class Experiment
implements Runnable,
BotEnteredWorldListener,
BotLeftWorldListener,
AgentIterationEndListener {
    protected String name = "Experiment";
    protected Flag<ExperimentState> experimentState = new Flag<ExperimentState>(ExperimentState.INIT);
    private Flag<Boolean> threadAlive = new Flag<Boolean>(false);
    private Thread thread = null;
    private UTWorld utWorld = null;
    private File outputDirectory = null;
    private Logger log = Logger.getAnonymousLogger();
    private CountDownLatch waitForExperimentEnd = new CountDownLatch(1);
    private boolean experimentRunning = false;
    private int botNumber = 0;
    private HashMap<Object, FileLogHandler> logHandlers = new HashMap();
    private ExperimentGlobals globals = new ExperimentGlobals();
    private List<Agent> terminatedAgents = new ArrayList<Agent>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private WorkingMemoryFileLogger droolsLogger = null;
    private ExperimentRules rules = null;
    private StatefulSession droolsStatefulSession = null;
    private ExperimentStartup experimentStartup = new ExperimentStartup();
    private FactHandle experimentStartupFactHandle = null;
    private HashMap<Agent, FactHandle> agentFactHandles = new HashMap();
    private HashMap<Agent, FactHandle> agentMemoryFactHandles = new HashMap();
    protected ClassLoader customClassLoader = null;

    public Experiment(String name, InputStream droolsRules, UTWorld utWorld, File outputDirectory, File projectsDir) throws Exception {
        this.name = name;
        this.customClassLoader = new BotProjectsClassLoader(projectsDir, this.getClass().getClassLoader());
        this.rules = new ExperimentRules(droolsRules, this.customClassLoader);
        this.utWorld = utWorld;
        this.outputDirectory = outputDirectory;
        this.initExperiment();
    }

    public Experiment(InputStream droolsRules, UTWorld utWorld, File outputDirectory) throws Exception {
        this.rules = new ExperimentRules(droolsRules);
        this.utWorld = utWorld;
        this.outputDirectory = outputDirectory;
        this.initExperiment();
    }

    public Experiment(ExperimentRules rules, UTWorld utWorld, File outputDirectory) {
        this.rules = rules;
        this.utWorld = utWorld;
        this.outputDirectory = outputDirectory;
        this.initExperiment();
    }

    public String getName() {
        return this.name;
    }

    public Logger getLogger() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLogHandler getFileLogHandler(String name, File fileToLogTo, Object loggingFor) {
        OutputStreamWriter writer;
        FileLogHandler logHandler;
        HashMap<Object, FileLogHandler> hashMap = this.logHandlers;
        synchronized (hashMap) {
            logHandler = this.logHandlers.get(loggingFor);
        }
        if (logHandler != null) {
            return logHandler;
        }
        try {
            writer = new OutputStreamWriter(new FileOutputStream(fileToLogTo));
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't log to file '" + fileToLogTo + "' for '" + name + "'.");
            return null;
        }
        logHandler = new FileLogHandler(name, writer);
        HashMap<Object, FileLogHandler> hashMap2 = this.logHandlers;
        synchronized (hashMap2) {
            this.logHandlers.put(loggingFor, logHandler);
        }
        return logHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropFileLogHandler(Object handlerForObject) {
        FileLogHandler logHandler;
        HashMap<Object, FileLogHandler> hashMap = this.logHandlers;
        synchronized (hashMap) {
            logHandler = this.logHandlers.get(handlerForObject);
            if (logHandler == null) {
                return;
            }
            this.logHandlers.remove(handlerForObject);
        }
        logHandler.close();
    }

    private String getFileNameInOutputDirectory(String fileName) {
        return this.outputDirectory + File.separator + fileName;
    }

    private File getFileInOutputDirectory(String fileName) {
        return new File(this.outputDirectory + File.separator + fileName);
    }

    private void initExperiment() {
        FileLogHandler logHandler = this.getFileLogHandler("Experiment", this.getFileInOutputDirectory("experiment.log"), this);
        if (logHandler != null) {
            this.log.addHandler(logHandler);
        }
    }

    public Flag<Boolean> getThreadAliveFlag() {
        return this.threadAlive;
    }

    public boolean isThreadAlive() {
        return this.threadAlive.getFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread runThread() throws PogamutException {
        if (!this.utWorld.registerExperiment(this)) {
            throw new PogamutException("Some experiment is already running on the main server. Wait until it ends or terminate it.");
        }
        Flag<Boolean> flag = this.threadAlive;
        synchronized (flag) {
            if (this.threadAlive.getFlag().booleanValue()) {
                return null;
            }
            this.thread = new Thread((Runnable)this, "Experiment");
            if (this.customClassLoader != null) {
                this.thread.setContextClassLoader(this.customClassLoader);
            }
            this.threadAlive.setFlag(true);
        }
        this.thread.start();
        return this.thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void run() {
        if (this.thread == null) {
            System.out.println("Experiment.run(): wasn't called from runThread(), this.thread == null, returning");
            return;
        }
        this.log.info("Experiment thread created, starting.");
        try {
            this.runExperiment();
            this.experimentState.setFlag(ExperimentState.RUNNING);
        }
        catch (Exception e) {
            this.log.severe("Exception occured during the experiment - " + e.getMessage());
            this.experimentState.setFlag(ExperimentState.FAILED);
        }
        while (this.experimentRunning) {
            try {
                this.waitForExperimentEnd.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.info("Experiment finished.");
        this.experimentState.setFlag(ExperimentState.FINISHING);
        this.experimentCleanup();
        this.experimentState.setFlag(ExperimentState.FINISHED);
        this.threadAlive.setFlag(false);
        this.thread = null;
    }

    private void runExperiment() {
        this.init();
        this.experimentRunning = true;
        this.startDrools();
    }

    private void init() {
        this.droolsStatefulSession = this.rules.getRuleBase().newStatefulSession(true);
        ClassLoader cl = this.droolsStatefulSession.getClass().getClassLoader();
        this.droolsStatefulSession.setGlobal("utWorld", (Object)this.utWorld);
        this.droolsStatefulSession.setGlobal("experiment", (Object)this);
        this.droolsStatefulSession.setGlobal("log", (Object)this.getLogger());
        this.droolsStatefulSession.setGlobal("globals", (Object)this.globals);
        this.experimentStartupFactHandle = this.droolsStatefulSession.insert((Object)this.experimentStartup);
        this.utWorld.addBotEnteredWorldListener(this);
        this.utWorld.addBotLeftWorldListener(this);
    }

    private void startDrools() {
        this.droolsStatefulSession.fireAllRules();
        this.experimentStartup.setStartup(false);
        this.droolsStatefulSession.update(this.experimentStartupFactHandle, (Object)this.experimentStartup);
        this.droolsStatefulSession.fireAllRules();
    }

    @Override
    public void botEnteredWorld(String unrealId) {
        if (!this.experimentRunning) {
            return;
        }
    }

    @Override
    public void iterationEnds(AgentIterationEndEvent event) {
        Agent bot = event.getSource();
        this.readLock.lock();
        if (!this.experimentRunning) {
            this.readLock.unlock();
            return;
        }
        this.droolsStatefulSession.update(this.agentFactHandles.get(bot), (Object)bot);
        this.droolsStatefulSession.update(this.agentMemoryFactHandles.get(bot), (Object)bot.getMemory());
        this.readLock.unlock();
        this.droolsStatefulSession.fireAllRules();
    }

    @Override
    public void botEnteredWorld(Agent bot) {
        this.writeLock.lock();
        if (!this.experimentRunning) {
            this.writeLock.unlock();
            return;
        }
        bot.getPlatformLog().info("Agent '" + bot.getName() + "' noticed by the experiment.");
        this.agentFactHandles.put(bot, this.droolsStatefulSession.insert((Object)bot));
        this.agentMemoryFactHandles.put(bot, this.droolsStatefulSession.insert((Object)bot.getMemory()));
        this.writeLock.unlock();
        bot.addIterationEndListener(this);
        FileLogHandler logHandler = this.getFileLogHandler(bot.getName(), this.getFileInOutputDirectory(bot.getName() + "_" + this.botNumber++ + "_logic.log"), bot);
        if (logHandler != null) {
            bot.getLogger().addHandler(logHandler);
        }
        if ((logHandler = this.getFileLogHandler(bot.getName(), this.getFileInOutputDirectory(bot.getName() + "_" + (this.botNumber - 1) + "_platform.log"), bot)) != null) {
            bot.getPlatformLog().addHandler(logHandler);
        }
        this.droolsStatefulSession.fireAllRules();
    }

    @Override
    public void botLeftWorld(String unrealId) {
        if (!this.experimentRunning) {
            return;
        }
    }

    @Override
    public void botLeftWorld(Agent bot) {
        this.writeLock.lock();
        if (!this.experimentRunning) {
            this.writeLock.unlock();
            return;
        }
        FactHandle agentFactHandle = this.agentFactHandles.get(bot);
        FactHandle agentMemoryFactHandle = this.agentMemoryFactHandles.get(bot);
        this.agentFactHandles.remove(bot);
        this.agentMemoryFactHandles.remove(bot);
        this.dropFileLogHandler(bot);
        bot.removeIterationEndListener(this);
        this.writeLock.unlock();
        this.droolsStatefulSession.retract(agentFactHandle);
        this.droolsStatefulSession.retract(agentMemoryFactHandle);
        bot.getPlatformLog().info("Agent removed from the experiment.");
        this.terminatedAgents.add(bot);
        this.droolsStatefulSession.fireAllRules();
    }

    public synchronized void experimentEnd() {
        if (!this.experimentRunning) {
            return;
        }
        this.experimentRunning = false;
        this.waitForExperimentEnd.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void experimentCleanup() {
        this.writeLock.lock();
        this.utWorld.removeBotEnteredWorldListener(this);
        this.utWorld.removeBotLeftWorldListener(this);
        for (Agent agent : this.agentFactHandles.keySet()) {
            agent.removeIterationEndListener(this);
            agent.disconnect();
            try {
                agent.getLogicThread().join(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.terminatedAgents.add(agent);
        }
        for (Map.Entry entry : this.agentFactHandles.entrySet()) {
            this.droolsStatefulSession.retract((FactHandle)entry.getValue());
        }
        for (Map.Entry entry : this.agentMemoryFactHandles.entrySet()) {
            this.droolsStatefulSession.retract((FactHandle)entry.getValue());
        }
        this.agentFactHandles.clear();
        this.agentMemoryFactHandles.clear();
        HashMap<Object, FileLogHandler> hashMap = this.logHandlers;
        synchronized (hashMap) {
            FileLogHandler[] fileLogHandlerArray;
            for (FileLogHandler handler : fileLogHandlerArray = this.logHandlers.values().toArray(new FileLogHandler[0])) {
                handler.close();
            }
        }
        this.writeLock.unlock();
    }

    public static String chars(String s, int length, char c) {
        String result = "";
        for (int i = 0; i < length - s.length(); ++i) {
            result = result + c;
        }
        result = result + s;
        return result;
    }

    public static String zeros(String s, int length) {
        return Experiment.chars(s, length, '0');
    }

    public static String zeros(int i, int length) {
        return Experiment.zeros(String.valueOf(i), length);
    }

    public static void runExperiment(ExperimentRules rules, UTWorld utWorld, File outputDirectory, int numberOfRepeats) {
        int numLength = String.valueOf(numberOfRepeats).length();
        for (int i = 0; i < numberOfRepeats; ++i) {
            System.out.println(Experiment.chars("", 19 + 2 * numLength, '-'));
            System.out.println("Experiment run: " + Experiment.zeros(i + 1, numLength) + " / " + String.valueOf(numberOfRepeats));
            System.out.println(Experiment.chars("", 19 + 2 * numLength, '-'));
            System.out.println("");
            File outputDir = new File(outputDirectory.getAbsolutePath() + File.separator + "run_" + Experiment.zeros(i + 1, numLength));
            if (!outputDir.exists()) {
                System.out.println("Creating dir '" + outputDir.getAbsolutePath() + "'...");
                if (!outputDir.mkdir()) {
                    System.out.println("Error creating directory, continuing with next run.");
                    continue;
                }
            }
            System.out.println("Creating experiment object...");
            Experiment experiment = new Experiment(rules, utWorld, outputDir);
            System.out.println("Running experiment...");
            System.out.println("---------------------");
            try {
                experiment.runThread();
            }
            catch (PogamutException ex) {
                ex.printStackTrace();
                return;
            }
            while (experiment.getThreadAliveFlag().getFlag().booleanValue()) {
                try {
                    experiment.getThread().join();
                }
                catch (InterruptedException e) {}
            }
            System.out.println("--------------------");
            System.out.println("Experiment finished.");
            System.out.println("");
            System.gc();
        }
    }

    public static void error(String msg) {
        System.out.println("");
        System.out.println(msg);
        System.out.println("");
        System.exit(1);
    }

    public static void error(String msg, Exception e) {
        System.out.println("");
        System.out.println(msg);
        System.out.println("Exception message: " + e.getMessage());
        System.out.println("");
        e.printStackTrace();
        System.out.println("");
        System.exit(1);
    }

    public static void printHelp() {
        System.out.println("");
        System.out.println("==================");
        System.out.println("Pogamut Experiment");
        System.out.println("==================");
        System.out.println("");
        System.out.println("This class is meant for running experiment without gui in batch mode.");
        System.out.println("After you debug your experiment using Pogamut GUI (NetBeans) you may create a batch file");
        System.out.println("that will run the experiments using this class main method. Using batch file");
        System.out.println("you may run several experiments over night.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("    java -cp ./src;./lib cz.cuni.pogamut.experiments.Experiment -f file.drl -h server:port [ADDITIONAL OPTIONS]");
        System.out.println("");
        System.out.println("    Note that you have to specify java '-cp' flag, where you have to specify classpath for sources and libraries.");
        System.out.println("");
        System.out.println("Required options:");
        System.out.println("");
        System.out.println("    -f experiment_rules.drl      ... rules file of the experiment");
        System.out.println("    --file experiment_rules.drl");
        System.out.println("");
        System.out.println("    -h host[:port]               ... host where UT2004 with GameBots2004 is running, where to run the experiment");
        System.out.println("    --host host[:port]");
        System.out.println("");
        System.out.println("Additional options:");
        System.out.println("");
        System.out.println("    -n number_of_repeats         ... how many times to run the experiment (default 1)");
        System.out.println("    --number_of_repeats");
        System.out.println("");
        System.out.println("    -o output_directory          ... directory where to save results (default '.'), if doesn't exist, will be created");
        System.out.println("    --output output_directory");
        System.out.println("");
        System.out.println("Example:");
        System.out.println("");
        System.out.println("    java cz.cuni.pogamut.experiments.Experiment -f myExperiment.drl -h artemis.ms.mff.cuni.cz:3001 -o /tmp -n 5");
        System.out.println("");
        System.out.println("    This will run experiment defined in myExperiment.drl (Drools rule file) on host artemis.ms.mff.cuni.cz (where UT2004 GameBots server is running). ");
        System.out.println("    The experiment will be repeated 5 times and results will be saved to the /tmp directory.");
        System.out.println("    This example assumes you have your PATH set to java.");
        System.out.println("");
    }

    public static void main(String[] args) {
        ExperimentRules rules;
        URI host;
        if (args.length < 4) {
            Experiment.printHelp();
            System.exit(1);
        }
        JSAP jsap = new JSAP();
        try {
            jsap.registerParameter((Parameter)new FlaggedOption("file").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault(JSAP.NO_DEFAULT).setRequired(true).setShortFlag('f').setLongFlag("file"));
            jsap.registerParameter((Parameter)new FlaggedOption("host").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault(JSAP.NO_DEFAULT).setRequired(true).setShortFlag('h').setLongFlag("host"));
            jsap.registerParameter((Parameter)new FlaggedOption("output_directory").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault(".").setRequired(false).setShortFlag('o').setLongFlag("output_direcotry"));
            jsap.registerParameter((Parameter)new FlaggedOption("number_of_repeats").setStringParser((StringParser)JSAP.INTEGER_PARSER).setDefault("1").setRequired(false).setShortFlag('n').setLongFlag("number_of_repeats"));
        }
        catch (Exception e) {
            Experiment.error("JSAP (Java Simple Argument Parser) exception, probably misconfiguration.", e);
            return;
        }
        JSAPResult config = null;
        try {
            config = jsap.parse(args);
        }
        catch (Exception e) {
            System.out.println("");
            System.out.println("Wrong parametrs specification (" + e.getMessage() + ").");
            Experiment.printHelp();
            System.exit(1);
            return;
        }
        System.out.println("");
        System.out.println("==================");
        System.out.println("Pogamut Experiment");
        System.out.println("==================");
        int numberOfRepeats = config.getInt("number_of_repeats");
        File droolsFile = new File(config.getString("file"));
        File outputDirectory = new File(config.getString("output_directory"));
        String hostString = config.getString("host");
        if (hostString == null) {
            Experiment.error("No host specified via -h switch.");
            return;
        }
        if (hostString.indexOf("://") == -1) {
            hostString = "ut://" + hostString;
        }
        try {
            host = new URI(hostString);
        }
        catch (URISyntaxException e) {
            Experiment.error("Malformed URI '" + hostString + "'.", e);
            return;
        }
        System.out.println("");
        System.out.println("Options of the experiment:");
        System.out.println("");
        System.out.println("Drools file:   '" + droolsFile.getAbsolutePath() + "'");
        System.out.println("Host (UT2004): '" + host.toString() + "'");
        System.out.println("Output dir:    '" + outputDirectory.getAbsolutePath() + "'");
        System.out.println("Repeats:       '" + String.valueOf(numberOfRepeats) + "'");
        System.out.println("");
        System.out.println("Checking options...");
        if (host.getPort() == -1) {
            System.out.println("Host port not specified, assuming 3001 (== GameBots2004 control server)...");
            try {
                host = new URI("ut://" + host.getHost() + ":3001");
            }
            catch (URISyntaxException e) {
                Experiment.error("Error creating new URI with default port 3001.", e);
                return;
            }
        }
        if (!droolsFile.isFile()) {
            Experiment.error("Drools file (-f) is not a file (parsed as '" + config.getString("file") + "', terminating.");
            return;
        }
        if (outputDirectory.exists()) {
            if (!outputDirectory.isDirectory()) {
                Experiment.error("Output directory (-o) is not a directory (parsed as '" + config.getString("output_directory") + "', terminating.");
                return;
            }
        } else {
            System.out.println("Output directory doesn't exists, creating...");
            if (!outputDirectory.mkdir()) {
                Experiment.error("Make dir failed.");
                return;
            }
        }
        System.out.println("Checking whether the output directory is suitable for saving results...");
        int numLength = String.valueOf(numberOfRepeats).length();
        for (int i = 0; i < numberOfRepeats; ++i) {
            File dir = new File(outputDirectory.getAbsolutePath() + File.separator + "run_" + Experiment.zeros(i + 1, numLength));
            if (!dir.exists()) continue;
            Experiment.error(String.valueOf(i + 1) + ". experiment run results will be saved into '" + dir.getAbsolutePath() + "', which already exists, can't proceed - please specify output directory as empty one.");
            return;
        }
        System.out.println("Output directory OK, experiment runs will be saved to dirs '" + outputDirectory.getAbsolutePath() + File.separator + "run_" + Experiment.chars("", numLength, 'X') + "'.");
        System.out.println("Evaluating rules...");
        try {
            rules = new ExperimentRules(new FileInputStream(droolsFile), new BotProjectsClassLoader());
        }
        catch (FileNotFoundException e) {
            Experiment.error("Drools file (-f) not found at '" + droolsFile.getAbsolutePath() + "'.", e);
            return;
        }
        catch (DroolsParserException e) {
            Experiment.error("Parser error, drools file has syntax / grammer error while evaluating '" + droolsFile.getAbsolutePath() + "'.", (Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            Experiment.error("Exception occured during evaluating drools file from '" + droolsFile.getAbsolutePath() + "'.", e);
            return;
        }
        System.out.println("Rules successfuly evaluated...");
        System.out.println("Connecting to GB at '" + host.toString() + "'...");
        UTServer server = new UTServer();
        server.setServerURI(host);
        server.waitForCommunication();
        System.out.println("");
        System.out.println("ALL OK, starting experiment.");
        System.out.println("");
        Experiment.runExperiment(rules, server, outputDirectory, numberOfRepeats);
        System.out.println("Experiment runs finished.");
        System.out.println("");
        System.exit(0);
    }

    public Flag<ExperimentState> getExperimentState() {
        return this.experimentState;
    }

    public List<Agent> getTerminatedAgents() {
        return this.terminatedAgents;
    }

    private class FileLogHandler
    extends Handler {
        private String name = null;
        private OutputStreamWriter writer = null;
        private Calendar c = Calendar.getInstance();
        private Logger errorLog = null;

        public FileLogHandler(String name, OutputStreamWriter writer) {
            this.name = name;
            this.writer = writer;
            this.errorLog = this.errorLog;
        }

        private String getTime(long millis) {
            this.c.setTimeInMillis(millis);
            StringBuffer sb = new StringBuffer(19);
            sb.append(this.c.get(1) + "/" + this.c.get(2) + "/" + this.c.get(5) + " " + this.c.get(10) + ":" + this.c.get(12) + ":" + this.c.get(13));
            return sb.toString();
        }

        @Override
        public void close() throws SecurityException {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                System.out.println("Can't close the log file for '" + this.name + "'.");
            }
        }

        @Override
        public void flush() {
            try {
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void publish(LogRecord arg0) {
            try {
                this.writer.append(this.getTime(arg0.getMillis()));
                this.writer.append(" | ");
                this.writer.append(arg0.getMessage());
                this.writer.append('\n');
            }
            catch (IOException e) {
                System.out.println("IOException while trying to insert message '" + arg0.getMessage() + "' for '" + this.name + "'.");
            }
        }
    }

    public static enum ExperimentState {
        INIT,
        RUNNING,
        FINISHING,
        FINISHED,
        FAILED;

    }
}

