/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.exampleBots;

import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.BaseBot;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

public class ExpertBot
extends BaseBot {
    protected Item choosenItem = null;
    protected ArrayList<Item> choosenMedKits = null;
    private boolean useAStar = false;
    private boolean pathRestart = false;
    private ArrayList<Item> itemsToRunAround = null;
    private Player enemy = null;
    private boolean jumped;
    public boolean shouldPursue = true;
    public boolean shouldRearm = true;
    public boolean shouldCollectItems = true;
    public boolean shouldCollectHealth = true;
    public int healthLevel = 90;
    protected ArrayList<NavPoint> path = null;
    protected Item previousChoosenItem = null;
    protected int pathID = 0;
    protected int pathIDnumerator = 10000;
    protected boolean pathQuerySent = false;
    protected boolean runAlongPathInitialized = false;
    protected boolean runItemInitialized = false;

    public ExpertBot() {
        this.log.setLevel(Level.INFO);
        this.platformLog.setLevel(Level.INFO);
    }

    @Override
    protected void postPrepareAgent() {
        this.itemsToRunAround = new ArrayList();
        for (Weapon item : this.memory.getKnownWeapons()) {
            this.itemsToRunAround.add(item);
        }
        Collections.shuffle(this.itemsToRunAround);
    }

    @Override
    protected void doLogic() {
        String name = this.getName();
        System.out.println("Name: " + (name == null ? "<null>" : name));
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe("Agent was ruthlessly interrupted during the sleep!");
            e.printStackTrace();
        }
        if (!this.memory.hasSelf()) {
            return;
        }
        if (this.shouldRearm && this.memory.getSeeAnyEnemy() && this.hasBetterWeapon()) {
            this.stateChangeToBetterWeapon();
            return;
        }
        if (this.shouldPursue && this.memory.getSeeAnyEnemy() && this.memory.hasLoadedWeapon()) {
            this.statePursue();
            return;
        }
        this.enemy = null;
        if (this.memory.isShooting()) {
            this.stateStopShooting();
            return;
        }
        if (this.memory.isBeingDamaged()) {
            this.stateHit();
            return;
        }
        if (this.memory.isColliding()) {
            this.stateWalking();
            return;
        }
        if (this.shouldCollectItems && this.seeAnyReachableItemAndWantIt()) {
            this.stateSeeItem();
            return;
        }
        if (this.memory.getAgentHealth() < this.healthLevel && this.canRunAlongMedKit()) {
            this.stateMedKit();
            return;
        }
        this.stateRunAroundItems();
    }

    protected void stateChangeToBetterWeapon() {
        this.log.log(Level.INFO, "Decision is: CHANGE WEAPON");
        AddWeapon weapon = this.memory.getBetterWeapon(this.memory.getAgentLocation(), this.memory.getSeeEnemy().location);
        this.body.changeWeapon(weapon);
    }

    protected boolean hasBetterWeapon() {
        AddWeapon weapon = this.memory.getBetterWeapon(this.memory.getAgentLocation(), this.memory.getSeeEnemy().location);
        return weapon != null;
    }

    protected void statePursue() {
        double distance;
        this.log.log(Level.INFO, "Decision is: PURSUE");
        if (!this.pathRestart) {
            this.pathRestart = true;
        }
        if (this.enemy != null) {
            this.enemy = this.memory.getSeePlayer(this.enemy.ID);
            if (this.enemy == null && this.memory.isShooting()) {
                this.body.stopShoot();
            }
        }
        if (this.enemy == null) {
            this.enemy = this.memory.getSeeEnemy();
            if (this.enemy == null) {
                this.body.stop();
                this.body.stopShoot();
                return;
            }
        }
        if ((double)this.memory.getCurrentWeapon().maxDist > (distance = Triple.distanceInSpace(this.memory.getAgentLocation(), this.enemy.location)) && !this.memory.isShooting()) {
            this.body.shoot(this.enemy);
        }
        AddWeapon weapon = null;
        if (this.memory.getAgentAmmo() == 0 && this.memory.hasLoadedWeapon()) {
            weapon = this.memory.getAnyWeapon();
            this.body.changeWeapon(weapon);
        }
        int decentDistance = Math.round(this.random.nextFloat() * 800.0f) + 200;
        if (this.memory.getAgentLocation() != null && this.enemy != null && this.enemy.location != null && Triple.distanceInSpace(this.memory.getAgentLocation(), this.enemy.location) < (double)decentDistance) {
            if (this.memory.isMoving()) {
                this.body.stop();
            }
        } else {
            this.body.runToTarget(this.enemy);
            this.jumped = false;
        }
    }

    protected void stateStopShooting() {
        this.log.log(Level.INFO, "Decision is: STOP_SHOOTING");
        this.body.stopShoot();
    }

    protected void stateHit() {
        this.log.log(Level.INFO, "Decision is: HIT");
        this.body.turnHorizontal(355);
    }

    protected void stateWalking() {
        this.log.log(Level.INFO, "Decision is: WALKING");
        if (this.memory.isColliding()) {
            if (!this.jumped) {
                this.body.jump();
                this.jumped = true;
            } else {
                this.body.stop();
                this.jumped = false;
            }
        }
        if (this.memory.isFalling()) {
            this.body.sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ... oh, I am high! :-)");
        }
        if (this.memory.isBumpingToAnotherActor()) {
            this.body.stop();
        }
    }

    protected boolean canRunAlongMedKit() {
        if (this.choosenMedKits == null) {
            this.choosenMedKits = this.gameMap.nearestHealth(4, 8);
            return false;
        }
        if (this.choosenMedKits.isEmpty() || this.choosenMedKits.size() > 2) {
            return false;
        }
        if (Triple.distanceInSpace(this.choosenMedKits.get((int)0).location, this.memory.getAgentLocation()) < 40.0) {
            if (this.choosenMedKits.size() > 2) {
                this.choosenMedKits.remove(0);
            } else {
                this.choosenItem = null;
            }
            return false;
        }
        return true;
    }

    protected void stateMedKit() {
        this.log.log(Level.INFO, "Decision is: RUN_MED_KITS");
        if (!this.pathRestart) {
            this.pathRestart = true;
        }
        this.gameMap.runAroundItemsInTheMap(this.choosenMedKits, false);
    }

    private Weapon chooseWeapon() {
        ArrayList<Weapon> weapons = this.memory.getSeeReachableWeapons();
        for (Weapon weapon : weapons) {
            if (this.memory.getCurrentWeapon() == null) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee && !weapon.isMelee() && !this.memory.hasWeaponOfType(weapon.weaponType)) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee || !weapon.isMelee() || this.memory.hasWeaponOfType(weapon.weaponType)) continue;
            return weapon;
        }
        Weapon chosen = this.memory.getSeeReachableWeapon();
        if (!this.memory.hasWeaponOfType(chosen.weaponType)) {
            return chosen;
        }
        return null;
    }

    private Item chooseItem() {
        if (this.memory.getSeeAnyReachableWeapon()) {
            return this.chooseWeapon();
        }
        if (this.memory.getSeeAnyReachableArmor()) {
            return this.memory.getSeeReachableArmor();
        }
        if (this.memory.getSeeAnyReachableHealth()) {
            Health health = this.memory.getSeeReachableHealth();
            if (this.memory.getAgentHealth() < 100) {
                return health;
            }
            if (health.boostable) {
                return health;
            }
        }
        if (this.memory.getSeeAnyReachableAmmo() && this.memory.isAmmoSuitable(this.memory.getSeeReachableAmmo())) {
            return this.memory.getSeeAmmo();
        }
        return null;
    }

    private boolean seeAnyReachableItemAndWantIt() {
        if (this.memory.getSeeAnyReachableItem()) {
            this.choosenItem = this.chooseItem();
            if (this.choosenItem != null) {
                this.log.info("NEW ITEM CHOSEN: " + this.choosenItem);
            }
        } else {
            this.choosenItem = null;
        }
        if (this.choosenItem != null && !this.choosenItem.equals(this.previousChoosenItem)) {
            return true;
        }
        this.runItemInitialized = false;
        return false;
    }

    protected void runToItemRestart() {
        this.path = null;
        this.pathQuerySent = false;
        this.runAlongPathInitialized = false;
    }

    protected boolean safeRunToItem(Item item) {
        if (this.path == null) {
            if (item.navPoint == null) {
                if (this.pathQuerySent) {
                    if (this.gameMap.getPathOfID(this.pathID) == null) {
                        return true;
                    }
                    this.path = this.gameMap.getPathOfID((int)this.pathID).nodes;
                    this.pathQuerySent = false;
                    return true;
                }
                ++this.pathIDnumerator;
                if (this.pathIDnumerator == Integer.MAX_VALUE) {
                    this.pathIDnumerator = 10000;
                }
                this.pathID = this.pathIDnumerator;
                this.gameMap.sendGetPathToLocation(this.pathID, item.location);
                this.pathQuerySent = true;
                return true;
            }
            this.path = this.gameMap.getNavPointsAStar(this.gameMap.getPathAStar(item.navPoint));
            if (this.path == null) {
                return false;
            }
        } else {
            if (this.runAlongPathInitialized) {
                return this.gameMap.runAlongPath();
            }
            this.runAlongPathInitialized = true;
            this.gameMap.initializeRunAlongPath(this.path);
        }
        return false;
    }

    protected void stateSeeItem() {
        this.log.log(Level.INFO, "Decision is: SEE_ITEM --- Running for: " + this.choosenItem.toString());
        if (!this.pathRestart) {
            this.pathRestart = true;
        }
        if (this.runItemInitialized) {
            if (!this.safeRunToItem(this.choosenItem)) {
                this.previousChoosenItem = this.choosenItem;
                this.choosenItem = null;
            }
        } else {
            this.runItemInitialized = true;
            this.runToItemRestart();
        }
        this.jumped = false;
    }

    protected void stateRunAroundItems() {
        this.log.log(Level.INFO, "Decision is: RUN_AROUND_ITEMS");
        if (this.pathRestart) {
            this.gameMap.restartPathToRunAlong();
            this.pathRestart = false;
        }
        this.gameMap.runAroundItemsInTheMap(this.itemsToRunAround, this.useAStar);
    }

    public static void main(String[] Args) {
        ExpertBot bot = new ExpertBot();
        boolean localParser = true;
        URI uri = null;
        try {
            uri = new URI("ut://artemis.ms.mff.cuni.cz:3000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        AgentLauncher launcher = new AgentLauncher(bot, uri, localParser);
        launcher.setLogToScreen();
        launcher.launch("HELLO_BOT");
    }
}

