/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.io.Serializable;

public class Self
extends MessageObject
implements Cloneable,
Serializable {
    public String name = null;
    public Triple location = null;
    public Triple rotation = null;
    public Triple velocity = null;
    public int team = 0;
    public String weapon = null;
    public boolean reachable = false;
    public int health = 0;
    public int currentAmmo = 0;
    public int armor = 0;
    public int altFiring = 0;
    public boolean shooting = false;

    @Override
    public boolean hasID() {
        return true;
    }

    public Self(int ID, String UnrealID, String name, Triple location, Triple rotation, Triple velocity, int team, String weapon, boolean reachable, int health, int currentAmmo, int armor, boolean visible, boolean shooting) {
        super(MessageType.SELF, ID, UnrealID, visible);
        this.name = new String(name);
        this.location = location;
        this.rotation = rotation;
        this.velocity = velocity;
        this.team = team;
        this.weapon = weapon;
        this.reachable = reachable;
        this.health = health;
        this.currentAmmo = currentAmmo;
        this.armor = armor;
        this.shooting = shooting;
    }

    public Self() {
        super(MessageType.SELF);
    }

    @Override
    public Object clone() {
        return new Self(this.ID, this.UnrealID, this.name, this.location, this.rotation, this.velocity, this.team, this.weapon, this.reachable, this.health, this.currentAmmo, this.armor, this.visible, this.shooting);
    }

    public Triple getSelfLocation() {
        return this.location;
    }

    public Triple getSelfRotation() {
        return this.rotation;
    }

    public Triple getSelfVelocity() {
        return this.velocity;
    }

    public int getSelfTeam() {
        return this.team;
    }

    public String getSelfWeapon() {
        return this.weapon;
    }

    public boolean getSelfReachability() {
        return this.reachable;
    }

    public int getArmor() {
        return this.armor;
    }

    public int getCurrentAmmo() {
        return this.currentAmmo;
    }

    public int getHealth() {
        return this.health;
    }

    public String getSelfName() {
        return this.name;
    }

    public boolean getShooting() {
        return this.shooting;
    }

    @Override
    public boolean diff(MessageObject old) {
        int same = 0;
        Self oldSelf = (Self)old;
        if (this.UnrealID == oldSelf.UnrealID) {
            this.UnrealID = null;
            ++same;
        }
        if (this.name == oldSelf.name) {
            this.name = null;
            ++same;
        } else {
            oldSelf.name = this.name;
        }
        if (this.location.equals(oldSelf.location)) {
            this.location = null;
            ++same;
        } else {
            oldSelf.location = this.location;
        }
        if (this.rotation.equals(oldSelf.rotation)) {
            this.rotation = null;
            ++same;
        } else {
            oldSelf.rotation = this.rotation;
        }
        if (this.velocity.equals(oldSelf.velocity)) {
            this.velocity = null;
            ++same;
        } else {
            oldSelf.velocity = this.velocity;
        }
        if (this.team == oldSelf.team) {
            ++same;
        } else {
            oldSelf.team = this.team;
        }
        if (this.weapon == oldSelf.weapon) {
            ++same;
        } else {
            oldSelf.weapon = this.weapon;
        }
        if (this.reachable == oldSelf.reachable) {
            ++same;
        } else {
            oldSelf.reachable = this.reachable;
        }
        if (this.health == oldSelf.health) {
            ++same;
        } else {
            oldSelf.health = this.health;
        }
        if (this.currentAmmo == oldSelf.currentAmmo) {
            ++same;
        } else {
            oldSelf.currentAmmo = this.currentAmmo;
        }
        if (this.armor == oldSelf.armor) {
            ++same;
        } else {
            oldSelf.armor = this.armor;
        }
        if (this.altFiring == oldSelf.altFiring) {
            ++same;
        } else {
            oldSelf.altFiring = this.altFiring;
        }
        if (this.shooting == oldSelf.shooting) {
            ++same;
        } else {
            oldSelf.shooting = this.shooting;
        }
        return same != 13;
    }

    @Override
    public void update(MessageObject newMsgObj) {
        Self newSelf = (Self)newMsgObj;
        if (newMsgObj.UnrealID != null) {
            this.UnrealID = newSelf.UnrealID;
        }
        if (newSelf.location != null) {
            this.location = newSelf.location;
        }
        if (newSelf.rotation != null) {
            this.rotation = newSelf.rotation;
        }
        if (newSelf.velocity != null) {
            this.velocity = newSelf.velocity;
        }
        if (newSelf.weapon != null) {
            this.weapon = newSelf.weapon;
        }
        if (newSelf.name != null) {
            this.name = newSelf.name;
        }
        this.reachable = newSelf.reachable;
        this.armor = newSelf.armor;
        this.currentAmmo = newSelf.currentAmmo;
        this.health = newSelf.health;
        this.shooting = newSelf.shooting;
    }

    @Override
    public String toString() {
        String temp = super.toString() + "(shoot " + this.shooting + "), location: " + this.location.toString();
        temp = temp + ", rotation: " + this.rotation.toString() + ", velocity: ";
        temp = temp + this.velocity.toString() + ", weapon: " + this.weapon;
        temp = temp + ", team: " + String.valueOf(this.team);
        temp = temp + ", health: " + String.valueOf(this.health) + " , armor: ";
        temp = temp + String.valueOf(this.armor) + ", ammo: " + String.valueOf(this.currentAmmo);
        return temp;
    }
}

