/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import cz.cuni.utils.GenericLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;

public class ExperimentRules
implements Serializable {
    private Package droolsPackage = null;
    private RuleBase droolsRuleBase = null;
    private RuleBaseConfiguration droolsRuleBaseConfiguration = new RuleBaseConfiguration();
    private ClassLoader customClassLoader = null;

    public ExperimentRules(InputStream droolsRules, ClassLoader classLoader) throws Exception {
        this.init(droolsRules, classLoader);
    }

    public ExperimentRules(InputStream droolsRules) throws Exception {
        this.init(droolsRules, null);
    }

    private void init(InputStream droolsRules, ClassLoader classLoader) throws IOException, DroolsParserException, Exception {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        conf.setCompiler(0);
        conf.setJavaLanguageLevel("1.6");
        if (classLoader != null) {
            conf.setClassLoader(classLoader);
            this.customClassLoader = classLoader;
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        PackageBuilder builder = new PackageBuilder(conf);
        builder.addPackageFromDrl((Reader)new InputStreamReader(droolsRules));
        this.droolsPackage = builder.getPackage();
        this.droolsRuleBaseConfiguration = new RuleBaseConfiguration();
        this.droolsRuleBase = new ReteooRuleBase(this.droolsRuleBaseConfiguration);
        this.droolsRuleBase.addPackage(this.droolsPackage);
    }

    public Package getPackage() {
        return this.droolsPackage;
    }

    public RuleBase getRuleBase() {
        return this.droolsRuleBase;
    }

    public RuleBaseConfiguration getRuleBaseConfiguration() {
        return this.droolsRuleBaseConfiguration;
    }

    public boolean save(ObjectOutputStream out) {
        return new GenericLoader<ExperimentRules>().saveObject(this, out);
    }

    public boolean save(OutputStream out) {
        return new GenericLoader<ExperimentRules>().saveObject(this, out);
    }

    public static ExperimentRules load(ObjectInputStream in) {
        return (ExperimentRules)new GenericLoader().loadObject(in);
    }

    public static ExperimentRules load(InputStream in) {
        return (ExperimentRules)new GenericLoader().loadObject(in);
    }

    public static ExperimentRules load(File f) {
        return (ExperimentRules)new GenericLoader().loadObject(f);
    }

    public ClassLoader getCustomClassLoader() {
        return this.customClassLoader;
    }
}

