/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.communication;

import java.util.EnumSet;
import java.util.Set;

public enum CommunicationState {
    START("Agent was created."),
    MAP_RECEIVE_NFO("Agent is waiting for NFO message."),
    MAP_RECEIVE_NAVPOINTS_EXPECTED("Agent is expecting to receive the NAVLIST message."),
    MAP_RECEIVING_NAVPOINTS("Agent is receiving navpoints of current map."),
    MAP_RECEIVE_ITEMS_EXPECTED("Agent is expecting to receive ITEMLIST message"),
    MAP_RECEIVING_ITEMS("Agent is receiving items of current map."),
    AWAITING_LOGIC("Agent is waiting for postPrepareAgent() method to finish."),
    BOT_RUNNING("Agent is running on the server."),
    PAUSED("Server is paused, therefore agent is not running."),
    TERMINATED("Agent was terminated."),
    FAIL("Protocol error, the server is using incompatible wrong version of GameBots2004."),
    EXCEPTION("An exception occured, agent is terminated."),
    MAP_FINISHED("Map on the server has finished, agent is terminated.");

    private static Set<CommunicationState> endStates;
    private String helpMessage = "";

    private CommunicationState(String helpMessage) {
        this.helpMessage = helpMessage;
    }

    public String getHelpMessage() {
        return this.helpMessage;
    }

    public boolean isEndState() {
        return CommunicationState.getEndStates().contains((Object)this);
    }

    public static Set<CommunicationState> getEndStates() {
        if (endStates == null) {
            endStates = EnumSet.of(TERMINATED, FAIL, EXCEPTION, MAP_FINISHED);
        }
        return endStates;
    }

    static {
        endStates = null;
    }
}

