/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.communication;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.communication.MediatorClientInterface;
import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantReadException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class MediatorForClient
implements MediatorClientInterface {
    private BlockingQueue<MessageObject> messagesForClient = new LinkedBlockingQueue<MessageObject>();
    private Socket clientSocket = null;
    protected BufferedReader input = null;
    private ObjectOutputStream output = null;

    public MediatorForClient(Socket clientSocket) throws IOException {
        this.clientSocket = clientSocket;
        this.output = new ObjectOutputStream(this.clientSocket.getOutputStream());
        this.input = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
    }

    @Override
    public String receiveMessageFromClient() throws CantReadException {
        try {
            return this.input.readLine();
        }
        catch (IOException e) {
            throw new CantReadException("Can't read from client -> " + e.getMessage(), e);
        }
    }

    @Override
    public void sendMessageToClient(MessageObject msg) throws CantWriteException {
        try {
            this.output.writeObject(msg);
        }
        catch (IOException e) {
            throw new CantWriteException("Can't write to client -> " + e.getMessage(), e);
        }
    }

    @Override
    public void closeClient() throws CantCloseConnectionException {
        try {
            this.clientSocket.close();
        }
        catch (IOException e) {
            throw new CantCloseConnectionException("Can't close socket -> " + e.getMessage(), e);
        }
    }
}

