class ControlConnection extends GBClientClass;

//Parent server
var ControlServer Parent;

var config float UpdateTime;

var() class<pickup> tempInventory; //for inventory spawns

//Accepted connection to a socket
event Accepted()
{
	log("Control Connection established.");

	if(bDebug)
		log("Accepted ControlConnection");

	if (bNewProtocol)
		SendLine("HELLO CONTROL SERVER");
	else
		SendGameInfo();

    if (BotDeathMatch(Level.Game).bPasswordProtected)
		gotoState('checkingPassword','Waiting');
	else
		gotoState('running','Waiting');
}

//Connection closed at remote end
event Closed()
{
	Destroy();
}

event Destroyed()
{
	SendLine("FIN");
}

function PostBeginPlay()
{
	Parent = ControlServer(Owner);
	if(bDebug)
		log("Spawned ControlConnection");
}

//Handles commands for ControlServer
function ProcessAction(string cmdType)
{
	if(bDebug)
		log("comandType:"@cmdType);

	if (IsInState('checkingPassword'))
	{
		switch(cmdType)
		{
			case "PASSWORD":
				ReceivedPassword();
			break;
			case "READY":
				ReceivedReady();
			break;
		}
	}
	else
	{
		switch(cmdType)
		{
			case "ADDBOT":
				ReceivedAddBot();
			break;
			case "ADDINV":
				ReceivedAddInv();
			break;
			case "CHANGEMAP":
				ReceivedChangeMap();
			break;
			case "CHANGETEAM":
				ReceivedChangeTeam();
			break;
			case "CHATRR":
				ReceivedChAtrr();
			break;
			case "CLEAR":
				ReceivedClear();
			case "CONF":
				ReceivedConf();
			break;
			case "CONFGAME":
				ReceivedConfGame();
			break;
			case "CONSOLE":
				ReceivedConsole();
			break;
			case "ENDPLRS":
				gotoState('running','Waiting');
			break;
			case "GETINVS":
				ExportInventory();
			break;
			case "GETMAPS":
				ReceivedGetMaps();
			break;
			case "GETNAVS":
				ExportNavPoints();
			break;
			case "GETPLRS":
				ExportPlayers();
			break;
			case "PAUSE":
				ReceivedPause();
			break;
			case "PING":
				SendLine("PONG");
			break;
			case "QUIT":
				Destroy();
			break;
			case "KICK":
				ReceivedKick();
			break;
			case "READY":
				ReceivedReady();
			break;
			case "REC":
				ReceivedRec();
			break;
			case "RESPAWN":
				ReceivedRespawn();
			break;
			case "SETGAMESPEED":
				ReceivedSetGameSpeed();
			break;
			case "SETLOCK":
				ReceivedSetLock();
			break;
			case "SETPASS":
				ReceivedSetPass();
			break;
			case "STARTPLRS":
				ReceivedStartPlrs();
			break;
			case "STOPREC":
				ReceivedStopRec();
			break;
		}//end switch
	}//end if
}

function ReceivedAddBot()
{
	local string target;
	local vector vector1;
	local rotator rotator1;
	local float floatNumber;
	local int intNumber;

	target = GetArgVal("Name");
	ParseVector(vector1,"StartLocation");
	ParseRot(rotator1,"StartRotation");
	floatNumber = float(GetArgVal("Skill"));
	intNumber = int(GetArgVal("Team"));
	if( Level.Game.isA('BotDeathMatch'))
	{
		BotDeathMatch(Level.Game).AddEpicBot(target, intNumber, vector1, rotator1, floatNumber);
	}
}

function ReceivedAddInv()
{
	local string target, string1;
	local Controller C;

	target = GetArgVal("Id");

	if (target == "") {
		return;
	}
	string1 = GetArgVal("Class");
	string1 = "class'"$string1$"'";
	setPropertyText("tempInventory",string1);
	//log("Added inventory will be "$tempInventory);
	if (tempInventory != None)
		for(C = Level.ControllerList; C != None; C = C.NextController )
		{
			if( (C$C.PlayerReplicationInfo.PlayerID) == target )
			{
				RemoteBot(C).SpawnInventory(tempInventory);

			}

		}

}

function ReceivedChangeMap()
{
	local string target;
	local bool bResult;
	local GBClientClass G;
	local Controller C;
	local int i;

	target = GetArgVal("MapName");
	if (target != "")
	{
		//Check if the map exists in current map list
		bResult = false;
		for (i=0; i < BotDeathMatch(Level.Game).Maps.Length; i++ )
		{
			if (target==BotDeathMatch(Level.Game).Maps[i])
			{
			 	bResult = true;
			 	break;
			}
		}
    	//Change just when the map is in MapList
		if (bResult)
		{
						//SendLine("MAPCHANGE"$ib$as$"MapName"$ib$target$ae);
			for(C = Level.ControllerList; C != None; C = C.NextController )
			{
				if (C.isA('RemoteBot'))
				{
					RemoteBot(C).myConnection.SendLine("MAPCHANGE"$ib$as$"MapName"$ib$target$ae);
					RemoteBot(C).myConnection.SendLine("FIN");
				}

			}
			for (G = Parent.ChildList; G != None; G = G.Next )
			{
				G.SendLine("MAPCHANGE"$ib$as$"MapName"$ib$target$ae);
				G.SendLine("FIN");
			}
    		//We refuse another connections when changing map
			BotDeathMatch(Level.Game).theBotServer.bClosed = true;
			BotDeathMatch(Level.Game).theBotServer.Close();

			BotDeathMatch(Level.Game).theControlServer.bClosed = true;
			BotDeathMatch(Level.Game).theControlServer.Close();

			Level.ServerTravel(target,false);
		}
	}
}

function ReceivedChangeTeam()
{
	local string temp, target;
	local Controller C;

	if (!Level.Game.IsA('BotTeamGame'))
		return;

	target = GetArgVal("Id");

	if (target == "")
		return;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( (C$C.PlayerReplicationInfo.PlayerID) == target )
		{
			if (C.IsA('RemoteBot'))
				break;
			else
				return;
		}

	}

	if (C != none)
	{

		temp = GetArgVal("Team");
		if (temp != "")
		{
	    	if (BotTeamGame(Level.Game).ChangeTeam(C, int(temp), true))
			{
				RemoteBot(C).myConnection.SendLine("TEAMCHANGE"$ib$as$"Success"$ib$"True"$ae$ib$as$"DesiredTeam"$ib$temp$ae);
				GlobalSendLine("TEAMCHANGE"$ib$as$"Id"$ib$C$C.PlayerReplicationInfo.PlayerID$ae$ib$as$"Success"$ib$"True"$ae$ib$as$"DesiredTeam"$ib$temp$ae,true,false);
			}
			else
			{
			    RemoteBot(C).myConnection.SendLine("TEAMCHANGE"$ib$as$"Success"$ib$"False"$ae$ib$as$"DesiredTeam"$ib$temp$ae);
				GlobalSendLine("TEAMCHANGE"$ib$as$"Id"$ib$C$C.PlayerReplicationInfo.PlayerID$ae$ib$as$"Success"$ib$"False"$ae$ib$as$"DesiredTeam"$ib$temp$ae,true,false);
			}
	    }
	}
}

// this will do a dirty clear, sometimes bots remain on the server after disconnect
// this delete all actors that are pawns or controllers on the server
//
function ReceivedClear()
{
	local GBxPawn P;
	local RemoteBot R;
	local BotConnection C;
	//local Controller C;

    foreach AllActors (class 'BotAPI.BotConnection', C, )
	{
		C.Destroy();
	}

	foreach AllActors (class 'BotAPI.RemoteBot', R, )
	{
		R.Destroy();
	}

	foreach AllActors (class 'BotAPI.GBxPawn', P, )
	{
		P.Destroy();
	}


}

function ReceivedChAtrr()
{
	local string target;
	local Controller C;

	target = GetArgVal("Id");
	if (target == "")
		return;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( (C$C.PlayerReplicationInfo.PlayerID) == target )
		{
			break;
		}

	}
	if (C == none)
		return;

	target = GetArgVal("Health");
	if (target != "")
	{
		RemoteBot(C).SetHealth(int(target));
	}

}

function ReceivedConf()
{
	local string target, string1;
	local float floatNumber;
	local Controller C;

	target = GetArgVal("Id");
	if (target == "")
		return;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( (C$C.PlayerReplicationInfo.PlayerID) == target )
		{
			break;
		}

	}
	if (C == none)
		return;

	if (GetArgVal("AutoTrace") != "")
		RemoteBot(C).bAutoTrace = bool(GetArgVal("AutoTrace"));
	if (GetArgVal("ManualSpawn") != "")
		RemoteBot(C).bAutoSpawn = !bool(GetArgVal("ManualSpawn"));
	if (GetArgVal("ShowFocalPoint")!="")
		RemoteBot(C).bShowFocalPoint = bool(GetArgVal("ShowFocalPoint"));
	if (GetArgVal("ShowDebug")!="")
		RemoteBot(C).bDebug = bool(GetArgVal("ShowDebug"));
	if (GetArgVal("Name") != "")
	{
		string1 = GetArgVal("Name");
    	C.PlayerReplicationInfo.PlayerName = string1;
		Level.Game.changeName( C, string1, true );
	}
	if (GetArgVal("Invulnerable") != "")
		RemoteBot(C).bGodMode = bool(GetArgVal("Invulnerable"));
	if (GetArgVal("DrawTraceLines") != "")
		RemoteBot(C).bDrawTraceLines = bool(GetArgVal("DrawTraceLines"));
	if (GetArgVal("VisionTime") != "")
	{
		floatNumber = float(GetArgVal("VisionTime"));
		if ((floatNumber >= 0.1) && (floatNumber <= 2))
			RemoteBot(C).myConnection.visionTime = floatNumber;
	}
	if (GetArgVal("SynchronousOff") != "")
	{
		RemoteBot(C).myConnection.bSynchronousMessagesOff = bool(GetArgVal("SynchronousOff"));
	}
	SendNotifyConf(RemoteBot(C));

}

function ReceivedConfGame()
{
	local int intNumber;

	if (GetArgVal("WeaponStay") != "")
	{
		Level.Game.bWeaponStay = bool(GetArgVal("WeaponStay"));
	}
	if (GetArgVal("WeaponThrowing") != "")
	{
		Level.Game.bAllowWeaponThrowing = bool(GetArgVal("WeaponThrowing"));
	}
	if (GetArgVal("GoalScore") != "")
	{
		intNumber = int(GetArgVal("GoalScore"));
		if (intNumber >= 1)
			Level.Game.GoalScore = intNumber;
	}
	if (GetArgVal("TimeLimit") != "")
	{
		intNumber = int(GetArgVal("TimeLimit"));
		if (intNumber >= 1)
			Level.Game.TimeLimit = intNumber;
	}
	if (GetArgVal("MaxLives") != "")
	{
		intNumber = int(GetArgVal("MaxLives"));
		if (intNumber >= 1)
			Level.Game.MaxLives = intNumber;
	}
	Level.Game.SaveConfig();
	Level.Game.GameReplicationInfo.SaveConfig();

}

function ReceivedConsole()
{
	local string target;

	target = GetArgVal("Command");

	ConsoleCommand(target, True);

}

function ReceivedGetMaps()
{
	local int i;

	SendLine("SMAP");
	for (i=0; i < BotDeathMatch(Level.Game).Maps.Length; i++ ) {
		SendLine("IMAP"$ib$as$"Name"$ib$BotDeathMatch(Level.Game).Maps[i]$ae);

	}
	SendLine("EMAP");
}


function ReceivedKick()
{
	local string target;
	local Controller C;
	local Bot b;

	target = GetArgVal("Id");
	if (target == "")
		return;
    for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( (C$C.PlayerReplicationInfo.PlayerID) == target )
		{
			if (C.isA('RemoteBot'))
			{
				//TODO: Send "Kicked"?
				RemoteBot(C).myConnection.SendLine("FIN");
				RemoteBot(C).myConnection.Closed();
			}
			else if (C.isA('Bot'))
			{
				b = Bot(C);

				//probably wont need this line with decreasing number of min players...
				UnrealMPGameInfo(Level.Game).MinPlayers = Max(UnrealMPGameInfo(Level.Game).MinPlayers - 1, UnrealMPGameInfo(Level.Game).NumPlayers + UnrealMPGameInfo(Level.Game).NumBots - 1);
				if ( (Vehicle(b.Pawn) != None) && (Vehicle(b.Pawn).Driver != None) )
					Vehicle(b.Pawn).Driver.KilledBy(Vehicle(b.Pawn).Driver);
				else if (b.Pawn != None)
					b.Pawn.KilledBy( b.Pawn );
				if (b != None)
				b.Destroy();
			}
			break;

		}

	}

}

function ReceivedPause()
{
	local bool bWasPaused;

	if (!bAllowPause)
		return;
	if ((Level.bPlayersOnly == true) || (Level.Pauser != none))
		bWasPaused = true;
	else
		bWasPaused = false;


	if (GetArgVal("PauseBots")!="")
	{
		Level.bPlayersOnly = bool(GetArgVal("PauseBots"));
	}
	if (GetArgVal("PauseAll")!="")
	{
		if (bool(GetArgVal("PauseAll")))
		{
			if (Level.Pauser == None)
			{
				Level.Pauser = BotDeathMatch(Level.Game).LevelPauserFeed;
			}
		}
		else
		{
			Level.Pauser = None;
		}
	}

	if (bWasPaused == true)
	{
		if ((Level.bPlayersOnly == false) && (Level.Pauser == none))
			SendNotifyPause(false); //send resume message
	}
	else
	{
		if ((Level.bPlayersOnly == true) || (Level.Pauser != none))
			SendNotifyPause(true); //send pause message
	}

}

function ReceivedPassword()
{
	local string target;

	target = GetArgVal("Password");

	if (target == BotDeathMatch(Level.Game).Password)
	{
		SendLine("PASSWDOK");
		SendGameInfo();
		gotoState('running','Waiting');
	}
	else
	{
		SendLine("PASSWDWRONG");
		Closed();
	}
}

function ReceivedReady()
{

	if ( IsInState('checkingPassword') )
		SendLine("PASSWORD"$ib$as$
			"BlockedByIP" $ib$ BotDeathMatch(Level.Game).PasswordByIP $ae);
	else
		SendGameInfo();

}

function ReceivedRec()
{
	local string target;

	target = GetArgVal("FileName");
	ConsoleCommand("demorec "$target, True);
	sendLine("RECSTART");
}

function ReceivedRespawn()
{
	local string target;
	local vector vector1;
	local rotator rotator1;
	local Controller C;

	target = GetArgVal("Id");

	if (target == "") {
		return;
	}
	ParseVector(vector1,"Location");
	ParseRot(rotator1,"Rotation");
	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( (C$C.PlayerReplicationInfo.PlayerID) == target )
		{
			if (C.IsA('RemoteBot'))
				RemoteBot(C).RespawnPlayer(vector1,rotator1);
		    if (C.IsA('GBxPlayer'))
   				GBxPlayer(C).RespawnPlayer(vector1,rotator1);
		}

	}

}

function ReceivedSetGameSpeed()
{
	local float floatNumber;

	floatNumber = float(GetArgVal("Speed"));
	if ( (floatNumber >= 0.01) && (floatNumber <= 50 ) )
	{
		Level.Game.bAllowMPGameSpeed = true;
		Level.Game.SetGameSpeed(floatNumber);
		Level.Game.SaveConfig();
		Level.Game.GameReplicationInfo.SaveConfig();
	}
}

function ReceivedSetLock()
{
	local string target;

	target = GetArgVal("BotServer");
	if (target != "")
	{
		if (bool(target))
		{
			if (BotDeathMatch(Level.Game).theBotServer.LinkState == STATE_Listening)
			{
				BotDeathMatch(Level.Game).theBotServer.bClosed = true;
				BotDeathMatch(Level.Game).theBotServer.Close();
			}
		}
		else
		{
			if (BotDeathMatch(Level.Game).theBotServer.LinkState != STATE_Listening)
			{
				BotDeathMatch(Level.Game).theBotServer.bClosed = false;
				BotDeathMatch(Level.Game).theBotServer.Listen();
			}
		}
	}

	target = GetArgVal("ControlServer");
	if (target != "")
	{
		if (bool(target))
		{
			if (BotDeathMatch(Level.Game).theControlServer.LinkState == STATE_Listening)
			{
				BotDeathMatch(Level.Game).theControlServer.bClosed = true;
				BotDeathMatch(Level.Game).theControlServer.Close();
			}
		}
		else
		{
			if (BotDeathMatch(Level.Game).theControlServer.LinkState != STATE_Listening)
			{
				BotDeathMatch(Level.Game).theControlServer.bClosed = false;
				BotDeathMatch(Level.Game).theControlServer.Listen();
			}
		}
	}

}

function ReceivedSetPass()
{
	local string target;

	target = GetArgVal("Password");

	if (target != "")
	{
		BotDeathMatch(Level.Game).bPasswordProtected = true;
		BotDeathMatch(Level.Game).PasswordByIP = string(RemoteAddr.Addr)$":"$string(RemoteAddr.Port);
		BotDeathMatch(Level.Game).Password = target;
	}
	else
	{
		BotDeathMatch(Level.Game).bPasswordProtected = false;
		BotDeathMatch(Level.Game).PasswordByIP = "";
		BotDeathMatch(Level.Game).Password = "";
	}

}

function ReceivedStartPlrs()
{
	local string tmp;

	tmp = GetArgVal("Humans");
	if (tmp != "")
	{
		bExportHumanPlayers = bool(tmp);
	}
	tmp = GetArgVal("GBBots");
	if (tmp != "")
	{
		bExportRemoteBots = bool(tmp);
	}
	tmp = GetArgVal("UnrealBots");
	if (tmp != "")
	{
		bExportUnrealBots = bool(tmp);
	}
	gotoState('running','Running');
}

function ReceivedStopRec()
{
	ConsoleCommand("stopdemo", True);
	sendLine("RECEND");
}

function SendNotifyConf(RemoteBot theBot)
{
	local string outstring;

	outstring="CONFCH"$ib$as$
			"Id" $ib$ theBot $ theBot.PlayerReplicationInfo.PlayerID $ae$ib$as$
			"ManualSpawn" $ib$ !theBot.bAutoSpawn $ae$ib$as$
			"AutoTrace" $ib$ theBot.bAutoTrace $ae$ib$as$
			"Invulnerable" $ib$ theBot.bGodMode $ae$ib$as$
			"Name" $ib$ theBot.PlayerReplicationInfo.PlayerName $ae$ib$as$
			"VisionTime" $ib$ theBot.myConnection.VisionTime $ae$ib$as$
			"ShowDebug" $ib$ theBot.bDebug $ae$ib$as$
			"ShowFocalPoint" $ib$ theBot.bShowFocalPoint $ae$ib$as$
			"DrawTraceLines" $ib$ theBot.bDrawTraceLines $ae$ib$as$
			"SynchronousOff" $ib$ theBot.myConnection.bSynchronousMessagesOff $ae;


	//Notify bot about his variables changing
	theBot.myConnection.SendLine(outstring);

	//Notify all control servers about bot variables chaning
	GlobalSendLine(outstring,true,false);
}

function SendNotifyPause ( bool bGamePaused )
{
	local Controller C;
	local GBClientClass G;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( C.IsA('RemoteBot') )
		{
			if (bGamePaused)
				RemoteBot(C).myConnection.SendLine("PAUSED");
			else
				RemoteBot(C).myConnection.SendLine("RESUMED");
		}
	}

	for (G = Parent.ChildList; G != None; G = G.Next )
	{
		if (bGamePaused)
			G.SendLine("PAUSED");
		else
			G.SendLine("RESUMED");
	}

}

//from CheatManager class - for inspiration
/*
function Summon( string ClassName )
{
	local class<actor> NewClass;
	local vector SpawnLoc;

	//if (!areCheatsEnabled()) return;

	log( "Fabricate " $ ClassName );
	NewClass = class<actor>( DynamicLoadObject( ClassName, class'Class' ) );
	if( NewClass!=None )
	{
		if ( Pawn != None )
			SpawnLoc = Pawn.Location;
		else
			SpawnLoc = Location;
		Spawn( NewClass,,,SpawnLoc + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
	}
	ReportCheat("Summon");
}
*/

//Default State for receiving commands
auto state running
{
Begin:
Waiting:
	sleep(1.0);
	SendLine("ALIVE" $ib$as$ "Time" $ib$ Level.TimeSeconds $ae);
	goto 'Waiting';
Running:
	SendLine("ALIVE" $ib$as$ "Time" $ib$ Level.TimeSeconds $ae);
	ExportPlayers();
	sleep(UpdateTime);
	goto 'Running';
}

state checkingPassword
{
Begin:
Waiting:
	sleep(5.0);
	goto 'Waiting';
}

defaultproperties
{
	UpdateTime=0.3
    bAllowPause=True
    as="{"
    ae="}"
    ib=" "
}
