/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.utils.HashCode;
import java.io.Serializable;

public class Triple
implements Cloneable,
Serializable {
    public static final double EPSILON = 1.0E-9;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    private final int hashCode;

    public Triple(double[] triple) {
        this.x = triple[0];
        this.y = triple[1];
        this.z = triple[2];
        this.hashCode = this.getHashCode();
    }

    private int getHashCode() {
        HashCode hc = new HashCode();
        hc.add(this.x);
        hc.add(this.y);
        hc.add(this.z);
        return hc.getHash();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Triple() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.hashCode = this.getHashCode();
    }

    public Triple(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.hashCode = this.getHashCode();
    }

    public Triple(Triple t) {
        this.x = t.x;
        this.y = t.y;
        this.z = t.z;
        this.hashCode = this.getHashCode();
    }

    public Object clone() {
        return new Triple(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple sec = (Triple)obj;
        return sec.x == this.x && sec.y == this.y && sec.z == this.z;
    }

    public Double dot(Triple t) {
        return this.x * t.x + this.y * t.y + this.z * t.z;
    }

    public String toString() {
        String temp = String.valueOf(this.x) + ',' + String.valueOf(this.y) + ',' + String.valueOf(this.z);
        return temp;
    }

    public void setTriple(Triple newTriple) {
        this.x = newTriple.x;
        this.y = newTriple.y;
        this.z = newTriple.z;
    }

    public static Triple add(Triple a, Triple b) {
        Triple sum = new Triple();
        sum.x = a.x + b.x;
        sum.y = a.y + b.y;
        sum.z = a.z + b.z;
        return sum;
    }

    public Triple normalize() {
        return Triple.multiplyByNumber(this, 1.0 / this.vectorSize());
    }

    public static Triple subtract(Triple a, Triple b) {
        Triple difference = new Triple();
        difference.x = a.x - b.x;
        difference.y = a.y - b.y;
        difference.z = a.z - b.z;
        return difference;
    }

    public static Triple multiplyByNumber(Triple a, Double b) {
        return new Triple(a.x * b, a.y * b, a.z * b);
    }

    public static double distanceInSpace(Triple a, Triple b) {
        double distance = 0.0;
        distance = Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0);
        distance = Math.sqrt(distance);
        return distance;
    }

    public static double distanceInPlane(Triple a, Triple b) {
        double distance = 0.0;
        distance = Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0);
        distance = Math.sqrt(distance);
        return distance;
    }

    public static double vectorSize(Triple a) {
        double distance = 0.0;
        distance = a.x * a.x + a.y * a.y + a.z * a.z;
        distance = Math.sqrt(distance);
        return distance;
    }

    public double vectorSize() {
        return Triple.vectorSize(this);
    }

    public boolean zero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public static double utAngleToRad(double angle) {
        return angle / 65536.0 * 2.0 * Math.PI;
    }

    public static double radToUTAngle(double angle) {
        return angle / (Math.PI * 2) * 65536.0;
    }

    public static Triple rotateYawPitchRoll(Triple a, double yawRad, double pitchRad, double rollRad) {
        return new Triple(Math.cos(pitchRad) * Math.cos(yawRad) * a.x + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) - Math.cos(rollRad) * Math.sin(yawRad)) * a.y + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) + Math.sin(rollRad) * Math.sin(yawRad)) * a.z, Math.cos(pitchRad) * Math.sin(yawRad) * a.x + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) + Math.cos(rollRad) * Math.cos(yawRad)) * a.y + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) - Math.sin(rollRad) * Math.cos(yawRad)) * a.z, -Math.sin(pitchRad) * a.x + Math.cos(pitchRad) * Math.sin(rollRad) * a.y + Math.cos(pitchRad) * Math.cos(rollRad) * a.z);
    }

    public static Triple rotationAsVector(Triple rotationInRad) {
        return Triple.rotateYawPitchRoll(new Triple(1.0, 0.0, 0.0), rotationInRad.y, rotationInRad.x, rotationInRad.z);
    }

    public static Triple rotationAsVectorUTUnits(Triple rotationInUTUnits) {
        return Triple.rotateYawPitchRoll(new Triple(1.0, 0.0, 0.0), Triple.utAngleToRad(rotationInUTUnits.y), Triple.utAngleToRad(rotationInUTUnits.x), Triple.utAngleToRad(rotationInUTUnits.z));
    }

    public Triple inverse() {
        return new Triple(-this.x, -this.y, -this.z);
    }

    public static double multiScalar(Triple a, Triple b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public boolean epsilonEquals(Triple a, double epsilon) {
        return Math.abs(this.x - a.x) < epsilon && Math.abs(this.y - a.y) < epsilon && Math.abs(this.z - a.z) < epsilon;
    }

    public boolean epsilonEquals(Triple a) {
        return this.epsilonEquals(a, 1.0E-9);
    }

    public static double angle(Triple a, Triple b) {
        Triple normalizedB;
        Triple normalizedA = new Triple(a).normalize();
        if (normalizedA.epsilonEquals(normalizedB = new Triple(b).normalize())) {
            return 0.0;
        }
        if (normalizedA.epsilonEquals(normalizedB.inverse())) {
            return Math.PI;
        }
        return Math.acos(Triple.multiScalar(a, b) / (a.vectorSize() * b.vectorSize()));
    }

    public static double degToRad(double deg) {
        return deg / 180.0 * Math.PI;
    }

    public static double radToDeg(double rad) {
        return rad / Math.PI * 180.0;
    }
}

