class GBServerClass extends TcpLink
	config(BotAPI);

//Port we want to connect to
var int DesiredPort;

//Port we are connected to
var int ListenPort;

var config int MaxConnections;

var bool bBound;
var config bool bDebug;

var int ConnectionCount;

/// configurable delimeters for strings sent to clients
// currently of form (with multiple possible attributes):
// "type"$ib$"identifier"$ib$as$"attrname1"$ib$"attrvalue1"$ae
// as = identifies the start of an attribute
var string as;
// ae = attribute end
var string ae;
// ib = item break
var string ib;

var GBClientClass ChildList;

var bool bClosed;

//shouldn't happen
event ReceivedText( string Text )
{
    if(bDebug)
    	log("RecievedTest in Server - "$Text);
}

//should never happen - accepted connections should be forwarded to a botconnection
event Accepted()
{
    if(bDebug)
    	log("Accepted connection in BotServer");
}

//called everytime a new botconnection is spawneds
event GainedChild( Actor C )
{
	local GBClientClass NewChild;
	local GBClientClass IteratorChild;

	if (bDebug)
		log("We are in gained child 1, it is "$ C);

	Super.GainedChild(C);

	log("We are in gained child 2, it is "$ C);

	if (C.IsA('GBClientClass')) {
		NewChild = GBClientClass(C);

	}else {
		log("This should never happen. In ChainedChild event 1");
		return;
	}

	if (ConnectionCount == 0) {
		ChildList = NewChild;

	}else {
		IteratorChild = ChildList;
		while (IteratorChild.Next != None) { //add child to the end of the list
			IteratorChild = IteratorChild.Next;
		}
		IteratorChild.Next = NewChild;
	}

	ConnectionCount++;

	// if too many connections, close down listen.
	if(MaxConnections > 0 && ConnectionCount >= MaxConnections && LinkState == STATE_Listening)
	{
		if(bDebug)
			Log("BotServer: Too many connections - closing down Listen.");
		Close();
	}
}

event LostChild( Actor C )
{
	local GBClientClass LostedChild;
	local GBClientClass IteratorChild, Previous;

	Super.LostChild(C);

	if (C.IsA('GBClientClass')) {
		LostedChild = GBClientClass(C);

	}
	else
	{
		log("This should never happen. In LostChild event 0");
		return;
	}

	if (ConnectionCount == 0)
	{
		log("This should never happen. 1 in event LostChild");
		return;
	}

	if (ConnectionCount == 1) {
		ChildList = None;
	}else {
		IteratorChild = ChildList;
		Previous = None;

		while (IteratorChild != LostedChild) {
			Previous = IteratorChild;
			IteratorChild = IteratorChild.Next;
		}
		if (IteratorChild == None)
		{
			log("This should never happen. 2 in event LostChild");
			return;
		}
		else {
			if (Previous == None) {
				ChildList = IteratorChild.Next;
			}else {
				Previous.Next = IteratorChild.Next;
			}

		}

	}

	ConnectionCount--;

	log("Lost Child "$C);
	// if closed due to too many connections, start listening again.
	if (ConnectionCount < MaxConnections && LinkState != STATE_Listening)
	{
		if (!bClosed)
		{
			Listen();
			if (bDebug)
				log("Start listening again LinkState: "$LinkState$"ConnectionCount: "$ConnectionCount);
		}
	}

}

function Initiate()
{
	log("GBServerClass - Initate() should not be called");
}

function BeginPlay()
{
	Super.BeginPlay();
}

defaultproperties
{
	MaxConnections=3
	bClosed=false
	AS="{"
	ae="}"
	ib=" "
	AcceptClass=BotAPI.ControlConnection
}
