//This mutator disables weapons in GameBots game.
class GBNoWeaponMutator extends Mutator;

var bool bInited;

simulated function BeginPlay()
{

    if(!bInited)
    {
        bInited = true;

        if (Level.Game.IsA('BotDeathMatch'))
        {
			BotDeathMatch(Level.Game).bShouldEraseAllWeapons = true;
		}

    }
    Super.BeginPlay();
}

function Class<Weapon> GetDefaultWeapon()
{
	return None;
}

function ModifyPlayer(Pawn Other)
{
	if(Other.Weapon != None)
	{
		Other.Weapon.Destroy();
		Other.Weapon = None;
	}
	Super.ModifyPlayer(Other);
}


function ServerTraveling(string URL, bool bItems)
{
	bInited = false;
	super.ServerTraveling(URL,bItems);

}


defaultproperties
{

     RemoteRole=ROLE_SimulatedProxy
     bAlwaysRelevant=true
     Description="Will remove all weapons from the GameBots game."
}
