// this is the scanner transition from gamebot message to object message 
// Search for XXX FIXME TODO
package cz.cuni.pogamut.Parser;

import cz.cuni.pogamut.MessageObjects.*;
import java.util.*;

%%

%{
	protected NeighNav neighNav  = null;
	protected ArrayList<NeighNav> neighList = null;
	
	protected boolean navList = false;

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntIDDouble = null;

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntDouble = null;
	
	/** parser reference, this parser will be used for translation of UnrealID to IntID */
	protected Parser parser = null;

	/**
	 * Return an integer from num token in txt
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with integer starting from zero
	 */
	protected int getInt( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {}");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
        	return (new Integer(st.nextToken()).intValue());
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return -1;
        }
	}

	
	/**
	 * Return a double from num token in txt
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with double starting from zero
	 */
	protected double getDouble( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {}");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
        	return (new Double(st.nextToken()).doubleValue());
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return -1.0;
        }
	}

	
	/**
	 * Return a string from num token in txt. 
	 * String ends after encountering "{" or " " or "}"
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with string starting from zero
	 */
	protected String getIdent( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {}");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
        	return st.nextToken();
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return "";
        }
	}
	

	/**
	 * Return text from first after space number num. 
	 * Text will continue untill first occurance of }
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of spaces that can preceder text
	 */
	protected String getText( String txt, int num  ) {
		int index = -1;
		int i = 0; // number of ' ' encountered
		
		while (i < num && (index = txt.indexOf(' ',index+1)) !=-1)
			i++;

		if (index == -1)
			return new String();
		else {
                    int lastBracket =  txt.lastIndexOf("}");
                    if (lastBracket < 0)
                        return txt.substring(index+1);	
                    else
                        return txt.substring(index+1, lastBracket);
                }
	
	}
	
	
    /**
	 * Return a triple starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with double starting from zero
	 */
	protected Triple getTriple( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {},");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
			double t1,t2,t3;
			t1 = new Double(st.nextToken()).doubleValue();
			t2 = new Double(st.nextToken()).doubleValue();
			t3 = new Double(st.nextToken()).doubleValue();
        	return new Triple(t1,t2,t3);
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return new Triple(0,0,0);
        }
	}
	
	/**
	 * Return a boolean of this parameter. If error, write an exception and return false.
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with double starting from zero. Tokens are separated by " {},"
	 */
	protected boolean getBoolean( String txt, int num)  {
		StringTokenizer st = new StringTokenizer(txt," {},");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		try {
		    // OLD CODE:
		    //   if (st.nextToken() == "True")
		    // REPLACED WITH:
		    //   if (st.nextToken().equals("True")
		    //
		    // Jakub Gemrot, 22.2.2007, 10:58
			if (st.nextToken().equals("True"))
				return true;
			else 
				return false;
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return false;
        }
	
	
	}
			
	/**
	 * Set parser translating UnrealID to IntID.
	 * This function should be called after constructor, I dont know how to define constructor, so this will do.
	 */
	public void setParser(Parser p) {
		parser = p;
	}
	
	/**
	 * Translate UnrealID to IntID
	 * @see Parser
	 */
	protected int unrealID2intID(String unrealID) {
		return parser.translateUnrealID2IntID(unrealID);
	}
	
	
    // this is stack with static size, so it can overflow... teoreticly... No.
    private int[] stack = new int[10];
    private int stack_pos = 0;
    private String tempStr = null;
  
  	protected Object actObj;
  
    /**
     * Change state to state and push original state to stack, so parser can return in state_return
     */
    private void state_go(int state)
    {
  	    stack[stack_pos++] = yystate();
  	    yybegin(state);
    }
  
    /**
     * Return to previous state.
     */
    private void state_return()
    {
  	    yybegin(stack[--stack_pos]);
    }
%} 

%line
%char
%state MSG_HELLO_BOT, MSG_HELLO_CONTROL_SERVER, MSG_MAPCHANGE, MSG_INAV, MSG_MAP, MSG_BEG, MSG_ALIVE, MSG_SLF, MSG_NFO, MSG_PLR, MSG_NAV, MSG_MOV, MSG_AIN, MSG_VMS, MSG_VMT, MSG_INV, MSG_END, MSG_GAM, MSG_ZCF, MSG_ZCH, MSG_ZCB, MSG_CWP, MSG_WAL, MSG_FAL, MSG_BMP, MSG_HRP, MSG_HRN, MSG_SEE, MSG_PRJ, MSG_KIL, MSG_DIE, MSG_DAM, MSG_HIT, MSG_PTH, MSG_RCH, MSG_FIN, MSG_FAL, LIST_UNREALID_DOUBLE, LIST_INT_DOUBLE, LIST_NAV, NEIGH_LIST, IINV, MSG_IINV, EINV, SINV, MSG_TRC, MSG_FTR, MSG_ATR, MSG_DOM, MSG_FLG, MSG_LEFT, MSG_JOIN, MSG_CONFCH, GAM_DOM_POINTS, MSG_ADG
%full
%type MessageObject

%standalone



ALPHA=[A-Za-z]
ALPHA_NUMERIC={ALPHA}|{DIGIT}
SEP=[_\-.]
ALPHA_NUMERIC_SEP = {ALPHA}|{DIGIT}|{SEP}
IDENT={ALPHA_NUMERIC_SEP}+
TEXT=[^}]+
DIGIT=[0-9]
NONNEWLINE_WHITE_SPACE_CHAR=[\ \t\b\012]
NEWLINE=\r|\n|\r\n
WHITE_SPACE_CHAR=[\n\r\ \t\b\012]
UINT = {DIGIT}+
INT = \-? {UINT}

FLOAT    = \-?({FLit1}|{FLit2}|{FLit3})
FLit1    = {DIGIT}+ \. {DIGIT}* 
FLit2    = \. {DIGIT}+ 
FLit3    = {DIGIT}+ 
TRIPLE = {FLOAT} \, {FLOAT} \, {FLOAT}

BOOLEAN = "True" | "False"
%% 

<YYINITIAL> {
	/* INIT messages */
	"HELLO BOT" {
		actObj = new HelloBotHandshake();
	}
	
	"HELLO CONTROL SERVER" {
		actObj = new HelloControlServerHandshake();
	}
	
	"HELLO MAP SERVER" {
		actObj = new HelloMap();
	}

	"SNAV" {
		actObj = new NavList(true);
		navList = true;
		parser.pushIntoBatch = false;		
	}
	"INAV" {		
		actObj = new NavPoint();		
		state_go(MSG_INAV);
	}	
	"ENAV" {
		actObj = new NavList(false);
		navList = false;
		parser.pushIntoBatch = true;		
	}
	"SINV" {
		actObj = new ItemList(true);
		navList = true;
		parser.pushIntoBatch = false;		
	}
	"IINV" {
		actObj = new Item();		
		((Item)actObj).event = "See";
		state_go(MSG_IINV);
	}
	"EINV" {
		actObj = new ItemList(false);
		navList = false;
		parser.pushIntoBatch = true;		
	}
	
	
    /* batch messages */
    "BEG" { // begin of a synchronous batch
    		actObj = new BeginMessage();
    		state_go(MSG_BEG);
    		// yybegin();
			//  o Time - timestamp from the game
    }
    
    "ALIVE" { // ControlServer message, that is used for measuring server lag
    		actObj = new AliveMessage();
    		state_go(MSG_ALIVE);
    		// yybegin();
			//  o Time - timestamp from the game
    }
    
    "SLF" { // information about your bot's state. 
			//  o Id - a unique id, assigned by the game 
			//  o Rotation - which direction the player is facing in absolute terms
			//  o Location - an absolute location
			//  o Velocity - absolute velocity in UT units 
			//  o Name - players human readable name 
			//  o Team - what team the player is on. 255 is no team. 0-3 are red, blue, green, gold in that order
			//  o Health - how much health the bot has left. Starts at 100, ranges from 0 to 200
			//  o Weapon - weapon the player is holding. Weapon strings to look for include: "ImpactHammer", "Enforcer", "Translocator", "GESBioRifle", "ShockRifle", "PulseGun", "Minigun2", "UT_FlakCannon", "UT_Eightball", "WarheadLauncher"
			//  o CurrentAmmo - How much ammo the bot has left for current weapon
			//  o Armor - how much armor the bot is wearing. Starts at 0, can range up to 200. 
    		actObj = new Self();
    		state_go(MSG_SLF);
			
    }
    
    "PLR" { // Another character (bot or human) in the game. Only reports those players that are visible. (within field of view and not occluded). 
			//  o Id - a unique id for this player, assigned by the game 
			//  o Rotation - which direction the player is facing in absolute terms 
			//  o Location - an absolute location for the player 
			//  o Velocity - absolute velocity in UT units 
			//  o Team - what team the player is on. 
			//  o Reachable - true if the bot can run to this other player directly, false otherwise. Possible reasons for false: pit or obstacle between the two characters 
			//  o Weapon - what class of weapon the character is holding. 
    		actObj = new Player();
    		state_go(MSG_PLR);
	}
    

    "GAM" { // information about the game 
			//  o PlayerScores - player score will have a list of values - one for each player in the game. Each value will be a list with two values. The first is the id of the player and the second that player's score. ( e.g. "GAM {PlayerScore {player1 2} {player2 5}..." ) 
			//  o TeamScores - like PlayerScore, but for teams. Team is identified by the team index (same number used to describe team for PLR and SLF messages. Not sent in normal deathmatch. 
			//  o DomPoints - like the previous two, this is a multivalued message. This will have one item for each domination point in a Domination game. First value will be Id of the DOM point, the second will be the index of the team that owns the domination point. 
			//  o MyFlag - sent in CTF games. State of our flag - can be "Home", "Held" and "Dropped".
			//  o EnemyFlag - sent in CTF games. State of enemy flag - can be "Home", "Held" and "Dropped". 
			actObj = new GameStatus();
			state_go(MSG_GAM);
	}

    "NAV" { // a path node in the game. Pathnodes are invisible (at least to humans) objects placed around a level to define paths for the built in bots to follow. They provide a totally connecteed graph that spans almost all of the level. Note the Mutator called "Path Markers" that, when added to a game makes the path nodes visible to human players as a debugging aid. 
			//  o Id - a unique id for this pathnode, assigned by the game 
			//  o Location - an absolute location 
			//  o Reachable - true if the bot can run here directly, false otherwise 
			actObj = new NavPoint();
			state_go(MSG_NAV);
	}

    "MOV" { // a "mover". These can be doors, elevators, or any other chunk of architecture that can move. They generally need to be either run into, or activated by shooting or pressing a button. We are working on ways to provide bots with more of the information they need to deal with movers appropriately. 
			//  o Id - a unique id for this mover, assigned by the game 
			//  o Location - an absolute location 
			//  o Reachable - true if the bot can run here mover, false otherwise 
			//  o DamageTrig - true if the mover needs to be shot to activated. 
			//  o Class - Class of the mover. 
			//  o IsMoving - does mover more right now?
			//  o Velocity - velocity vector 
			actObj = new Mover();
			state_go(MSG_MOV);
	}
			
    "INV" { // an object on the ground that can be picked up 
			//  o Id - a unique id for this inventory item, assigned by the game. 
			//  o Location - an absolute location 
			//  o Reachable - true if the bot can run here directly, false otherwise 
			//  o Class - a string representing type of object 
    		actObj = new Item();
    		state_go(MSG_INV);
	}
	
    "END" { // end of a synchronous batch 
			//  o Time - timestamp from the game
    		actObj = new EndMessage();
    		state_go(MSG_END);
    }
  
    // asynchro message
    "NFO" { // helpful info about the game provided right after connection made to server. Your client should wait for this message BEFORE trying to send "init" back to the server. 
			//  o Gametype - What you are playing (BotDeathMatchPlus, BotTeamGame, BotDomination) 
			//  o Level - name of map in play 
			//  o TimeLimit - maximum time game will last (if tied at end, goes into sudden death overtime) 
			//  o FragLimit - number of kills needed to win game (BotDeathMatchPlus only) 
			//  o GoalTeamScore - number of points a team needs to win game (BotTeamGame,BotDomination) 
			//  o MaxTeams - max number of teams. valid team range will be 0 to (MaxTeams - 1)(BotTeamGame, BotDomination) 
			//  o MaxTeamSize - Max number of players per side (BotTeamGame, BotDomination) 
			//  o GamePaused 
			//  o BotsPaused
    		actObj = new GameInfo();
    		state_go(MSG_NFO);
    }

    "AIN" { // added inventory. Bot got new inventory item 
			//  o Id - a unique id for this inventory item, assigned by the game. Unique, but based on a string describing the item type. 
			//  o Class - a string representing type of object 
			actObj = new AddItem();
			state_go(MSG_AIN);
    }
          			
    "VMS" { // recieved message from global chat channel 
			//  o String - a human readable message sent by another player in the game on the global channel
			actObj = new GlobalChat();
			state_go(MSG_VMS);
    }

    "VMT" { // recieved message from global chat channel 
            //  o String - a human readable message sent by a team mate in the game on the private team channel
            actObj = new TeamChat();
            state_go(MSG_VMT);
    }
/*
    "VMG" { // recieved tokenized message from another player. If you want to use these, enter the game as a player and use the voice menu (by default press the key "V" while playing). Send the messages you want to use to use and have a client log the incoming messages to figure out Types and Ids.       
            // o Sender - unique id of player who sent message 
            // o Type - type of message (e.g. Command, Taunt, etc...) 
            // o Id - message id. specifies which message is being sent 
    }
*/
    "ZCF" { // foot changed zones. Feet of bot changed from one artificial area in the game to another (can tell you when entered water or lava or some such) 
            // o Id - unique id of zone entered 
            actObj = new ZoneChangedFoot();
            state_go(MSG_ZCF);
    }
    
    "ZCH" { // head changed zones. Its ok if feet are under water, but having your head under can mean trouble... 
			//  o Id - unique id of zone entered 
            actObj = new ZoneChangedHead();
            state_go(MSG_ZCH);
    }

    "ZCB" { // bot changed zones. Entire bot now in new zone 
			//  o Id - unique id of zone entered 
            actObj = new ZoneChangedBot();
            state_go(MSG_ZCB);
    }

    "CWP" { // bot changed weapons. Possibly as a result of a command sent by you, maybe just because it ran out of ammo in its old gun. (bots autoswitch when empty, just like human players) 
			//  o Id - unique id of new weapon, based on the weapon's name 
			//  o Class - a string representing type of weapon 
			actObj = new ChangedWeapon();
			state_go(MSG_CWP);
    }

    "WAL" { // collided with a wall. Note it is common to get a bunch of these when you try to run through a wall (or are pushed into one by gunfire or something). 
			//  o Id - unique id of wall hit 
			//  o Normal - normal of the angle bot colided at. 
			//  o Location - absolute location of bot at time of impact 
			actObj = new WallCollision();
			state_go(MSG_WAL);
    }

    "FAL" { // bot just hit a ledge. If walking, will not fall. If running, you are already falling by the time you get this. 
			actObj = new FallEdge();
			state_go(MSG_FAL);
    }

    "BMP" { // bumped another actor 
			//  o Id - unique id of actor (actors include other players and other physical objects that can block your path.) 
			//  o Location - location of thing you rammed 
			actObj = new Bumped();
			state_go(MSG_BMP);
    }

    "HRP" { // hear pickup. You head someone pick up an object from the ground 
			//  o Player - unique ID of player how picked up the object
			actObj = new HearPickup();
			state_go(MSG_HRP);
    }

    "HRN" { // hear noise. Maybe another player walking or shooting, maybe a bullet hitting the floor, or just a nearby lift going up or down. 
            //  o Source - unique ID of actor making the noise
			actObj = new HearNoise();
			state_go(MSG_HRN);
    }

    "SEE" { // see player. A message generated by the engine periodically (on the order of 1 or 2 times a second) when another player is visible by you. Possibly usefull if you have the delay between synchronous updates very long. In that case, this can prevent someone from walking by unseen. May be depricated. 
            //  o Id - a unique id for this player, assigned by the game 
            //  o Rotation - which direction the player is facing in absolute terms 
            //  o Location - an absolute location for the player 
            //  o Velocity - absolute velocity in UT units 
            //  o Team - what team the player is on. 
            //  o Reachable - true if the bot can run to this other player directly, false otherwise. Possible reasons for false: pit or obstacle between the two characters 
            //  o Weapon - what weapon the character is holding. 
            actObj = new SeePlayer();
            state_go(MSG_SEE);
    }

    "PRJ" { // incoming projectile likely to hit you. May give you a chance to dodge. 
           //  o Time - estimated time till impact 
           actObj = new IncommingProjectile();
           state_go(MSG_PRJ);
    }


    "KIL" { // some other player died 
            //  o Id - unique ID of player 
            //  o Killer - unique ID of player that killed them if any (may have walked off a ledge) 
            //  o DamageType - a string describing what kind of damage killed them 
            actObj = new PlayerKilled();
            state_go(MSG_KIL);
    }

    "DIE" { // this bot died 
            //  o Killer - unique ID of player that killed them if any (may have walked off a ledge) 
            //  o DamageType - a string describing what kind of damage killed them 
            actObj = new BotKilled();
            state_go(MSG_DIE);
    }

    "DAM" { // took damage 
            //  o Damage - amount of damage taken 
            //  o DamageType - a string describing what kind of damage 
            actObj = new BotDamaged();
            state_go(MSG_DAM);
    }

    "HIT" { // hurt another player. Hit them with a shot. 
            //  o Id - unique ID of player hit 
            //  o Damage - amount of damage done 
            //  o DamageType - a string describing what kind of damage 
            actObj = new PlayerDamaged();
            state_go(MSG_HIT);
    }

    "PTH" { // a series of pathnodes in response to a getpath call from client 
            //  o Id - an id matching the one sent by client. Allows bot to match answer with right querry. 
            //  o Multiple pathnodes: A variable number of attr items will be returned, one for each pathnode that needs to be taken. They will be listed in the order in which they should be travled to. Each one is of form "{0 id 3,4,5}", with the number of the node (starting with 0) followed by a space, then a unique id for the node (will never have a space) then a location of that node. 
			actObj = new Path();
			state_go(MSG_PTH);
    }

    "RCH" { // a boolean result of a checkreach call.
            //  o Id - an id matching the one sent by client. Allows bot to match answer with right querry. 
            //  o Reachable - true if the bot can run here directly, false otherwise 
            actObj = new Reachable();
            state_go(MSG_RCH);
    }
    
    "TRC" { 
    	   actObj = new Trace();
    	   state_go(MSG_TRC);
    }

    "FTR" {
    	   actObj = new FastTrace();
    	   state_go(MSG_FTR);
    }
    	 
    "SPW" {
    		actObj = new Spawn();
    }	 

	"PONG" {
    		actObj = new Pong();
    }

    "FIN" { // no attributes. Sent when game is over.
    	actObj = new MapFinished(); 
    }
    
    "ATR" {
    	actObj = new AutoTraceRay();
    	state_go(MSG_ATR);
    }
    
    "LEFT" {
   		// some player has left the game
    	actObj = new PlayerLeft();
    	state_go(MSG_LEFT);
    }
    
    "JOIN" {
   		// some player has left the game
    	actObj = new PlayerJoinsGame();
    	state_go(MSG_JOIN);
    }
    
    "DOM" {
        // identical attributes to NAV above except for Controller (see below). A domination point in a domination game. 
	    //  o Controller - which team controls this point 
    	actObj = new DominationPoint();
    	state_go(MSG_DOM);
    }
    
    "FLG" {
    	// a flag. (Only for CTF games). 
		//  o Id - a unique id for this flag, assigned by the game 
		//  o Location - an absolute location of the flag 
		//  o Holder - the identity of player/bot holding the flag (only sent if flag is being carried). 
		//  o Team - the team whose flag this is 
		//  o Reachable - true if the bot can run here directly, false otherwise 
		//  o State - whether the flag is "Held" "Droped" or "Home" 
    	actObj = new FlagInfo();
    	state_go(MSG_FLG);
    }
    
    "RECSTART" { // RECORD HAS BEGUN message
        actObj = null; // we don't need to receive this message in Agent        
    }
    
    "REC" { // RECORD HAS STOPPED message
        actObj = null; // we don't need to receive this message in Agent               
    }
    
    "THROWN" { // Weapon has been thrown    
        actObj = new Thrown();
    }
    
    "PAUSED" { // game has been paused
    	actObj = new GamePaused();
    }
    
    "RESUMED" { // game has been resumed
    	actObj = new GameResumed();
    }

   	"SMAP" {
		actObj = new MapListStart();
	}

   	"IMAP" {
		actObj = new UTMap();
		state_go(MSG_MAP);
	}
   	"EMAP" {
		actObj = new MapListEnd();
	}
	
   	"SPLR" {
		actObj = new PlayerListStart();
	}
   	"IPLR" {
		actObj = new Player();
		state_go(MSG_PLR);
	}
   	"EPLR" {
		actObj = new PlayerListEnd();
	}

	"MAPCHANGE" {
		actObj = new MapChange();
		state_go(MSG_MAPCHANGE);
	}
	
	"CONFCH" {
		actObj = new ConfigChange();
		state_go(MSG_CONFCH);
	}
	
	"ADG" {
		actObj = new AdrenalineGained();
		state_go(MSG_ADG);
	}
    
  . {System.out.println("No match at the start of line, probably undefined message " + yytext());}
}


<MSG_MAPCHANGE> {
  "{MapName " {TEXT} "}" { ((MapChange)actObj).mapName = getText(yytext(),1); }
}

<MSG_BEG> {
  "{Time " {FLOAT} "}" { ((BeginMessage)actObj).time = getDouble(yytext(),1); }
}

<MSG_ALIVE> {
  "{Time " {FLOAT} "}" { ((AliveMessage)actObj).time = getDouble(yytext(),1); }
}

<MSG_MAP> {
  "{Name " {TEXT} "}" { ((UTMap)actObj).mapName = getText(yytext(),1); }
}

<MSG_PLR> {
  "{Id " {IDENT} "}"           {
				    			((Player)actObj).UnrealID   = getIdent(yytext(),1); 
				    			((Player)actObj).ID         = unrealID2intID(((Player)actObj).UnrealID); 
  }
  "{Name " {TEXT} "}"             {((Player)actObj).name       = getText(yytext(),1);}
  "{Rotation " {TRIPLE} "}"       {((Player)actObj).rotation   = getTriple(yytext(),1);} 
  "{Location " {TRIPLE} "}"       {((Player)actObj).location   = getTriple(yytext(),1);}
  "{Velocity " {TRIPLE} "}"       {((Player)actObj).velocity   = getTriple(yytext(),1);}
  "{Team " {INT} "}"              {((Player)actObj).team       = getInt(yytext(),1);}
  "{Reachable " {BOOLEAN} "}"     {((Player)actObj).reachable  = getBoolean(yytext(),1);}
  "{Weapon " {IDENT} "}"          {((Player)actObj).weapon     = getIdent(yytext(),1);}
  "{Firing " {INT} "}"            {((Player)actObj).shooting   = getInt(yytext(),1);}
  "{AutoTrace " {BOOLEAN} "}"     {((Player)actObj).autoTrace  = getBoolean(yytext(),1);}
  "{ManualSpawn " {BOOLEAN} "}"   {((Player)actObj).manualSpawn   = getBoolean(yytext(),1);}
  "{Invulnerable " {BOOLEAN} "}"  {((Player)actObj).invulnerable  = getBoolean(yytext(),1);}
  "{VisionTime " {FLOAT} "}"      {((Player)actObj).visionTime    = getDouble(yytext(),1);}
  "{ShowDebug " {BOOLEAN} "}"     {((Player)actObj).showDebug     = getBoolean(yytext(),1);}
  "{DrawTraceLines " {BOOLEAN} "}" {((Player)actObj).drawTraceLines = getBoolean(yytext(),1);}
  "{ShowFocalPoint " {BOOLEAN} "}" {((Player)actObj).showFocalPoint = getBoolean(yytext(),1);}
}



<MSG_NFO> {
  "{Gametype " {IDENT} "}"       {((GameInfo)actObj).gameType      = getIdent(yytext(),1);}
  "{Level " {IDENT} "}"          {((GameInfo)actObj).level         = getIdent(yytext(),1);}
  "{TimeLimit " {FLOAT} "}"      {((GameInfo)actObj).timeLimit     = getDouble(yytext(),1);}
  "{FragLimit " {INT} "}"        {((GameInfo)actObj).fragLimit     = getInt(yytext(),1);}
  "{GoalTeamScore " {FLOAT} "}"  {((GameInfo)actObj).goalTeamScore = getDouble(yytext(),1);}
  "{MaxTeams " {INT} "}"         {((GameInfo)actObj).maxTeams      = getInt(yytext(),1);}
  "{MaxTeamSize " {INT} "}"      {((GameInfo)actObj).maxTeamSize   = getInt(yytext(),1);}
  "{RemainingTime " {INT} "}"    {((GameInfo)actObj).remainingTime = getInt(yytext(),1);}
  "{GamePaused " {BOOLEAN} "}"   {((GameInfo)actObj).gamePaused    = getBoolean(yytext(),1);}
  "{BotsPaused " {BOOLEAN} "}"   {((GameInfo)actObj).botsPaused    = getBoolean(yytext(),1);}
}

<MSG_CONFCH> {
  "{SynchronousOff " {BOOLEAN} "}" {((ConfigChange)actObj).synchronousOff = getBoolean(yytext(),1);}
  "{ManualSpawn " {BOOLEAN} "}"    {((ConfigChange)actObj).manualSpawn    = getBoolean(yytext(),1);}
  "{AutoTrace " {BOOLEAN} "}"      {((ConfigChange)actObj).autoTrace      = getBoolean(yytext(),1);}
  "{Invulnerable " {BOOLEAN} "}"   {((ConfigChange)actObj).invulnerable   = getBoolean(yytext(),1);}
  "{Name " {TEXT} "}"              {((ConfigChange)actObj).name           = getText(yytext(),1);}
  "{VisionTime " {FLOAT} "}"       {((ConfigChange)actObj).visionTime     = getDouble(yytext(),1);}
  "{ShowDebug " {BOOLEAN} "}"      {((ConfigChange)actObj).showDebug      = getBoolean(yytext(),1);}
  "{ShowFocalPoint " {BOOLEAN} "}" {((ConfigChange)actObj).showFocalPoint = getBoolean(yytext(),1);}
  "{DrawTraceLines " {BOOLEAN} "}" {((ConfigChange)actObj).drawTraceLines = getBoolean(yytext(),1);}
  "{Id " {IDENT} "}"               {((ConfigChange)actObj).UnrealID       = getIdent(yytext(),1);
  									((ConfigChange)actObj).ID             = unrealID2intID(((ConfigChange)actObj).UnrealID);
                                   } 
}

<MSG_SLF> {
  "{Id " {IDENT} "}"            {((Self)actObj).UnrealID      = getIdent(yytext(),1);
                                 ((Self)actObj).ID            = unrealID2intID(((Self)actObj).UnrealID);
  }
  "{Rotation " {TRIPLE} "}"     {((Self)actObj).rotation      = getTriple(yytext(),1);} 
  "{Location " {TRIPLE} "}"     {((Self)actObj).location      = getTriple(yytext(),1);}
  "{Velocity " {TRIPLE} "}"     {((Self)actObj).velocity      = getTriple(yytext(),1);}
  "{Name " {TEXT} "}"           {((Self)actObj).name           = getText(yytext(),1);}
  "{Team " {INT} "}"            {((Self)actObj).team          = getInt(yytext(),1);}
  "{Health " {INT} "}"          {((Self)actObj).health        = getInt(yytext(),1);}
  "{Weapon " {IDENT} "}"        {((Self)actObj).weapon        = getIdent(yytext(),1);}
  "{CurrentAmmo " {INT} "}"     {((Self)actObj).currentAmmo   = getInt(yytext(),1);}
  "{Armor " {INT} "}"           {((Self)actObj).armor         = getInt(yytext(),1);} 
  "{AltFiring " {INT} "}"       {((Self)actObj).altFiring     = getInt(yytext(),1);}
  "{Shooting " {BOOLEAN} "}"    {((Self)actObj).shooting      = getBoolean(yytext(),1);}
  "{Adrenaline " {FLOAT} "}"    {((Self)actObj).adrenaline    = getDouble(yytext(),1);}
  "{CurrentAltAmmo " {INT} "}"  {((Self)actObj).currentAltAmmo = getInt(yytext(),1);}  
}

<MSG_INV> {
  "{Id " {IDENT} "}"           {((Item)actObj).UnrealID  = getIdent(yytext(),1);
                                ((Item)actObj).ID        = unrealID2intID(((Item)actObj).UnrealID);
  }
  "{Location " {TRIPLE} "}"    {((Item)actObj).location  = getTriple(yytext(),1);}
  "{Reachable " {BOOLEAN} "}"  {((Item)actObj).reachable = getBoolean(yytext(),1);}
  "{Class " {IDENT} "}"        {((Item)actObj).cls       = getIdent(yytext(),1);}
  "{Event " {TEXT} "}"         {((Item)actObj).event     = getText(yytext(),1);}
}

<MSG_END> {
  "{Time " {FLOAT} "}"  {((EndMessage)actObj).time = getDouble(yytext(),1);}
}


<MSG_GAM> {
  "{PlayerScores " { // FIXME: I dont have yet CTF and other
  					 ((GameStatus)actObj).playerScores = new HashMap<Integer, Double>();
  					 mapIntIDDouble = ((GameStatus)actObj).playerScores;
  					 state_go(LIST_UNREALID_DOUBLE);
  }
  "{TeamScores "   { ((GameStatus)actObj).teamScores = new HashMap<Integer, Double>();
  					 mapIntDouble = ((GameStatus)actObj).teamScores;
  					 state_go(LIST_INT_DOUBLE);
  }
  "{DomPoints " { 
      ((GameStatus)actObj).domPoints = new HashMap<Integer, Integer>();
      state_go(GAM_DOM_POINTS);      
  }
  "{MyFlag "     {TEXT} "}" { ((GameStatus)actObj).myFlag = getText(yytext(),1); }
  "{EnemyFlag "  {TEXT} "}" { ((GameStatus)actObj).enemyFlag = getText(yytext(),1); }  
}

<GAM_DOM_POINTS> {
  "{" {IDENT} " " {INT} "}" { 
					((GameStatus)actObj).domPoints.put(unrealID2intID(getIdent(yytext(),0)),getInt(yytext(),1)); 
	}
	" " {}
	"}" {state_return();}
}

<MSG_AIN> {
  "{Id " {IDENT} "}"                 {((AddItem)actObj).UnrealID  = getIdent(yytext(),1);
                                      ((AddItem)actObj).itemID    = unrealID2intID(((AddItem)actObj).UnrealID); }
  "{Class " {IDENT} "}"              {((AddItem)actObj).cls       = getIdent(yytext(),1);}
  "{Sniping " {BOOLEAN} "}"          { /* silently ignores ... will be in new version */ }
  "{Melee " {BOOLEAN} "}"            { /* silently ignores ... will be in new version */ }
  "{PrimaryInitialAmmo " {INT} "}"   { /* silently ignores ... will be in new version */ }
  "{MaxPrimaryAmmo " {INT} "}"       { /* silently ignores ... will be in new version */ }
  "{SecondaryInitialAmmo " {INT} "}" { /* silently ignores ... will be in new version */ }
  "{MaxSecondaryAmmo " {INT} "}"     { /* silently ignores ... will be in new version */ }
}


<MSG_VMS> { 
  "{String " {TEXT} "}" {((GlobalChat)actObj).string       = getText(yytext(),1);}
  "{Name " {TEXT} "}"   {((GlobalChat)actObj).name       = getText(yytext(),1);}
}


<MSG_VMT> { 
  "{String " {TEXT} "}" {((TeamChat)actObj).string       = getText(yytext(),1);}
}


<MSG_NAV> {
  "{Id " {IDENT} "}"           {((NavPoint)actObj).UnrealID  = getIdent(yytext(),1);
                                ((NavPoint)actObj).ID        = unrealID2intID(((NavPoint)actObj).UnrealID);
  }
  "{Location " {TRIPLE} "}"    {((NavPoint)actObj).location  = getTriple(yytext(),1);}
  "{Flag " {TEXT} "}"          {((NavPoint)actObj).flag  = getText(yytext(),1); }
  "{Item " {IDENT} "}"         { ((NavPoint)actObj).itemUnrealID = getIdent(yytext(),1);
  								 if (!((NavPoint)actObj).itemUnrealID.equals("None"))
	                                 ((NavPoint)actObj).itemID = unrealID2intID(((NavPoint)actObj).itemUnrealID); 
  }
  "{ItemClass " {TEXT} "}"          {((NavPoint)actObj).itemClass  = getText(yytext(),1); }
  "{Reachable " {BOOLEAN} "}"  {((NavPoint)actObj).reachable = getBoolean(yytext(),1);}
  "{Visible " {BOOLEAN} "}"    {((NavPoint)actObj).visible = getBoolean(yytext(),1);}
  "{Rotation " {TRIPLE} "}"    {((NavPoint)actObj).rotation = getTriple(yytext(),1);} 
  "{RoamingSpot " {BOOLEAN} "}"  {((NavPoint)actObj).roamingSpot = getBoolean(yytext(),1);} 
  "{SnipingSpot " {BOOLEAN} "}"  {((NavPoint)actObj).snipingSpot = getBoolean(yytext(),1);} 
  "{PreferedWeapon " {TEXT} "}"  {((NavPoint)actObj).classOfPreferedWeapon  = getText(yytext(),1); }
}

<MSG_DOM> {
  "{Id " {IDENT} "}"           {((DominationPoint)actObj).UnrealID = getIdent(yytext(),1);
                                ((DominationPoint)actObj).ID        = unrealID2intID(((DominationPoint)actObj).UnrealID);
  }
  "{Location " {TRIPLE} "}"    {((DominationPoint)actObj).location   = getTriple(yytext(),1);}
  "{Reachable " {BOOLEAN} "}"  {((DominationPoint)actObj).reachable  = getBoolean(yytext(),1);}
  "{Visible " {BOOLEAN} "}"    {((DominationPoint)actObj).visible 	  = getBoolean(yytext(),1);}
  "{Controller " {INT} "}"     {((DominationPoint)actObj).controller = getInt(yytext(),1);}

}

<MSG_FLG> {
  "{Id " {IDENT} "}"           {((FlagInfo)actObj).UnrealID  = getIdent(yytext(),1);
                                ((FlagInfo)actObj).ID        = unrealID2intID(((FlagInfo)actObj).UnrealID);
  }
  "{Location " {TRIPLE} "}"    {((FlagInfo)actObj).location   = getTriple(yytext(),1);}
  "{Reachable " {BOOLEAN} "}"  {((FlagInfo)actObj).reachable  = getBoolean(yytext(),1);}
  "{Visible " {BOOLEAN} "}"    {((FlagInfo)actObj).visible    = getBoolean(yytext(),1);}  
  "{Holder " {IDENT} "}"       {((FlagInfo)actObj).holderUnrealID   = getIdent(yytext(),1);
                                ((FlagInfo)actObj).holderID   = unrealID2intID(((FlagInfo)actObj).holderUnrealID);
  }
  "{Team " {INT} "}"           {((FlagInfo)actObj).team       = getInt(yytext(),1);}
  "{State " {TEXT} "}"         {((FlagInfo)actObj).state      = getText(yytext(),1);}

}
	
<MSG_MOV> {
  "{Id " {IDENT} "}"           {((Mover)actObj).UnrealID   = getIdent(yytext(),1);
                                ((Mover)actObj).ID  = unrealID2intID(((Mover)actObj).UnrealID);
  }
  "{Location " {TRIPLE} "}"    {((Mover)actObj).location   = getTriple(yytext(),1);}
  "{Reachable " {BOOLEAN} "}"  {((Mover)actObj).reachable  = getBoolean(yytext(),1);}
  "{DamageTrig " {BOOLEAN} "}" {((Mover)actObj).damageTrig = getBoolean(yytext(),1);}
  "{Class " {IDENT} "}"        {((Mover)actObj).cls        = getIdent(yytext(),1);}
  "{IsMoving " {BOOLEAN} "}"   {((Mover)actObj).isMoving   = getBoolean(yytext(),1);}
  "{Velocity " {TRIPLE} "}"    {((Mover)actObj).velocity   = getTriple(yytext(),1);}
}


<MSG_ZCF> {
  "{Id " {IDENT} "}" {((ZoneChangedFoot)actObj).zoneID = unrealID2intID(getIdent(yytext(),1)); /* XXX: Should I join ZoneChanged* to one?*/}
  "{Pain " {BOOLEAN} "}" {((ZoneChangedFoot)actObj).pain = getBoolean(yytext(),1);}
}    

<MSG_ZCH> {
  "{Id " {IDENT} "}" {((ZoneChangedHead)actObj).zoneID = unrealID2intID(getIdent(yytext(),1));}
  "{Pain " {BOOLEAN} "}" {((ZoneChangedHead)actObj).pain = getBoolean(yytext(),1);}
}

<MSG_ZCB> {
  "{Id " {IDENT} "}" {((ZoneChangedBot)actObj).zoneID = unrealID2intID(getIdent(yytext(),1));}
  "{Pain " {BOOLEAN} "}" {((ZoneChangedBot)actObj).pain = getBoolean(yytext(),1);}  
}

<MSG_CWP> {
  "{Id " {IDENT} "}"    {((ChangedWeapon)actObj).weaponID = unrealID2intID(getIdent(yytext(),1));}
  "{Class " {IDENT} "}" {((ChangedWeapon)actObj).cls      = getIdent(yytext(),1);}
}


<MSG_WAL> {
  "{Id " {IDENT} "}"        {((WallCollision)actObj).collisionID       = unrealID2intID(getIdent(yytext(),1)); }
  "{Normal " {TRIPLE} "}"   {((WallCollision)actObj).normal   = getTriple(yytext(),1);}
  "{Location " {TRIPLE} "}" {((WallCollision)actObj).location = getTriple(yytext(),1);}
}


<MSG_BMP> {
  "{Id " {IDENT} "}"        {((Bumped)actObj).actorID = unrealID2intID(getIdent(yytext(),1));}
  "{Location " {TRIPLE} "}" {((Bumped)actObj).location = getTriple(yytext(),1);}
}


<MSG_HRP> {
  "{Player " {IDENT} "}"       {((HearPickup)actObj).playerID = unrealID2intID(getIdent(yytext(),1));}
  "{SourceClass " {IDENT} "}"  {((HearPickup)actObj).sourceClass = getIdent(yytext(),1);}
  "{Source " {IDENT} "}"       {((HearPickup)actObj).sourceClass = getIdent(yytext(),1);}
  "{Name " {TEXT} "}"          {((HearPickup)actObj).name = getText(yytext(),1);}
  "{Rotation " {TRIPLE} "}"    {((HearPickup)actObj).rotation = getTriple(yytext(),1);}
}

<MSG_HRN> {
  "{Source " {IDENT} "}"       {((HearNoise)actObj).sourceID = unrealID2intID(getIdent(yytext(),1));}
  "{Rotation " {TRIPLE} "}"    {((HearNoise)actObj).rotation = getTriple(yytext(),1);}
}


<MSG_SEE> {
  "{Id " {IDENT} "}"           {((SeePlayer)actObj).UnrealID  = getIdent(yytext(),1);
                                ((SeePlayer)actObj).ID        = unrealID2intID(((SeePlayer)actObj).UnrealID);
                               }
  "{Name " {IDENT} "}"         {((SeePlayer)actObj).name  = getIdent(yytext(),1);     }
  "{Rotation " {TRIPLE} "}"    {((SeePlayer)actObj).rotation  = getTriple(yytext(),1);}
  "{Location " {TRIPLE} "}"    {((SeePlayer)actObj).location  = getTriple(yytext(),1);}
  "{Velocity " {TRIPLE} "}"    {((SeePlayer)actObj).velocity  = getTriple(yytext(),1);}
  "{Team " {IDENT} "}"         {((SeePlayer)actObj).team      = getIdent(yytext(),1);}
  "{Reachable " {BOOLEAN} "}"  {((SeePlayer)actObj).reachable = getBoolean(yytext(),1);}
  "{Weapon " {IDENT} "}"       {((SeePlayer)actObj).weapon    = getIdent(yytext(),1);}
  "{Firing " {INT} "}"         {((SeePlayer)actObj).shooting  = getInt(yytext(),1);}
}


<MSG_PRJ> {
  "{Time " {FLOAT} "}"         {((IncommingProjectile)actObj).time = getDouble(yytext(),1);}
  "{Direction " {TRIPLE} "}"   {((IncommingProjectile)actObj).direction  = getTriple(yytext(),1);} 
  "{Origin " {TRIPLE} "}"      {((IncommingProjectile)actObj).origin  = getTriple(yytext(),1);} 
  "{DamageRadius " {FLOAT} "}" {((IncommingProjectile)actObj).damageRadius  = getDouble(yytext(),1);} 
  "{Class " {IDENT} "}"        {((IncommingProjectile)actObj).cls  = getIdent(yytext(),1);} 
}


<MSG_KIL> {
  "{Id " {IDENT} "}"       {((PlayerKilled)actObj).playerID   = unrealID2intID(getIdent(yytext(),1));}
  "{Killer " {IDENT} "}"   {((PlayerKilled)actObj).killerID   = unrealID2intID(getIdent(yytext(),1));}
  "{DamageType " {TEXT} "}" {((PlayerKilled)actObj).damageType = getText(yytext(),1);}    /* FIXME: je to opravdu text? */
}


<MSG_DIE> {
  "{Killer " {IDENT} "}"   {((BotKilled)actObj).killerID   = unrealID2intID(getIdent(yytext(),1));}
  "{DamageType " {TEXT} "}" {((BotKilled)actObj).damageType = getText(yytext(),1);}    /* FIXME: je to opravdu text? */
}
    
    
<MSG_DAM> {
  "{Damage " {INT} "}"      {((BotDamaged)actObj).damage = getInt(yytext(),1);}
  "{DamageType " {TEXT} "}" {((BotDamaged)actObj).damageType = getText(yytext(),1);}
  "{Instigator " {IDENT} "}"  {// this is ID of the bot who is damaging the agent
							   ((BotDamaged)actObj).idInstigator = unrealID2intID(getIdent(yytext(),1));
							  }
}


<MSG_HIT> {
  "{Id " {IDENT} "}"        {// this is ID of hit
                             ((PlayerDamaged)actObj).hitID = unrealID2intID(getIdent(yytext(),1));
  } 
  "{Damage " {INT} "}"      {((PlayerDamaged)actObj).damage = getInt(yytext(),1);}
  "{DamageType " {TEXT} "}" {((PlayerDamaged)actObj).damageType = getText(yytext(),1);}
}


<MSG_PTH> { 
  "{Id " {IDENT} "}" { 
               ((Path)actObj).pongID = getIdent(yytext(),1);
  }
  "{ID " {IDENT} "}" { 
               ((Path)actObj).pongID = getIdent(yytext(),1);
  }
  "{" {INT} " " {IDENT} " " {TRIPLE} "}"  {
  				NavPoint nv = new NavPoint();
  				nv.UnrealID = getIdent(yytext(),1);
  				nv.ID       = unrealID2intID(nv.UnrealID);
  				nv.location = getTriple(yytext(),2);
  				nv.reachable = false;
               ((Path)actObj).nodes.add(nv);
  }
}

<MSG_TRC> {
  "{Id " {IDENT} "}"           {((Trace)actObj).ID          = unrealID2intID(getIdent(yytext(),1)); }
  "{From " {TRIPLE} "}"        {((Trace)actObj).from        = getTriple(yytext(),1);} 
  "{To " {TRIPLE} "}"          {((Trace)actObj).to          = getTriple(yytext(),1);}
  "{Result " {BOOLEAN} "}"     {((Trace)actObj).result      = getBoolean(yytext(),1);}
  "{HitNormal " {TRIPLE} "}"   {((Trace)actObj).hitNormal   = getTriple(yytext(),1);}
  "{HitId " {IDENT} "}"        { tempStr = getIdent(yytext(),1);
                                 ((Trace)actObj).hitId    = unrealID2intID(tempStr); ; 
                               }
  "{HitLocation " {TRIPLE} "}" {((Trace)actObj).hitLocation = getTriple(yytext(),1);}
}

<MSG_FTR> {
  "{Id " {IDENT} "}"           {((Trace)actObj).ID          = unrealID2intID(getIdent(yytext(),1)); }
  "{From " {TRIPLE} "}"        {((Trace)actObj).from        = getTriple(yytext(),1);} 
  "{To " {TRIPLE} "}"          {((Trace)actObj).to          = getTriple(yytext(),1);}
  "{Result " {BOOLEAN} "}"     {((Trace)actObj).result      = getBoolean(yytext(),1);}
}

<MSG_INAV> {
  "{Id " {IDENT} "}"           { ((NavPoint)actObj).UnrealID = getIdent(yytext(),1); 
                                 ((NavPoint)actObj).ID = unrealID2intID(((NavPoint)actObj).UnrealID); 
  }
  "{Location " {TRIPLE} "}"    { ((NavPoint)actObj).location  = getTriple(yytext(),1); }
  "{Flag " {TEXT} "}"          { ((NavPoint)actObj).flag  = getText(yytext(),1); }
  "{Item " {IDENT} "}"         { ((NavPoint)actObj).itemUnrealID = getIdent(yytext(),1);
  								 if (!((NavPoint)actObj).itemUnrealID.equals("None"))
	                                 ((NavPoint)actObj).itemID = unrealID2intID(((NavPoint)actObj).itemUnrealID); 
  }
  "{Neigh" {INT}              {
  				neighNav = new NeighNav();
  				NavPoint nv = (NavPoint)actObj;
  				if (nv.neighbours == null)
  					nv.neighbours = new ArrayList<NeighNav>();
  				neighList = nv.neighbours;
  				state_go(NEIGH_LIST);
  }
  "{Rotation "    {TRIPLE}  "}"    {((NavPoint)actObj).rotation = getTriple(yytext(),1);} 
  "{RoamingSpot " {BOOLEAN} "}"    {((NavPoint)actObj).roamingSpot = getBoolean(yytext(),1);} 
  "{SnipingSpot " {BOOLEAN} "}"    {((NavPoint)actObj).snipingSpot = getBoolean(yytext(),1);} 
  "{PreferedWeapon " {TEXT} "}"    {((NavPoint)actObj).classOfPreferedWeapon = getText(yytext(),1);} 
  "{ItemClass " {TEXT}      "}"    {((NavPoint)actObj).itemClass = getText(yytext(),1);} 
}

<MSG_IINV> {
  "{Id " {IDENT} "}"           { ((Item)actObj).UnrealID = getIdent(yytext(),1); 
                                 ((Item)actObj).ID = unrealID2intID(((Item)actObj).UnrealID); 
  }
  "{Location " {TRIPLE} "}"    { ((Item)actObj).location  = getTriple(yytext(),1); }
  "{Class " {IDENT} "}"        { ((Item)actObj).cls = getIdent(yytext(),1); }
}

<MSG_ATR> {
  "{Id " {IDENT} "}"            { ((AutoTraceRay)actObj).UnrealID = getIdent(yytext(),1);
                                  ((AutoTraceRay)actObj).ID = unrealID2intID(((AutoTraceRay)actObj).UnrealID);   
                                }
  "{From " {TRIPLE} "}"         { ((AutoTraceRay)actObj).from  = getTriple(yytext(),1); }
  "{To " {TRIPLE} "}"           { ((AutoTraceRay)actObj).to = getTriple(yytext(),1); }
  "{FastTrace " {BOOLEAN} "}"   { ((AutoTraceRay)actObj).fastTrace = getBoolean(yytext(),1); }  
  "{Result " {BOOLEAN} "}"      { ((AutoTraceRay)actObj).result = getBoolean(yytext(),1); }    
  "{HitNormal " {TRIPLE} "}"    { ((AutoTraceRay)actObj).hitNormal = getTriple(yytext(),1); }
  "{HitLocation " {TRIPLE} "}"  { ((AutoTraceRay)actObj).hitLocation = getTriple(yytext(),1); }  
  "{TraceActors " {BOOLEAN} "}" { ((AutoTraceRay)actObj).traceActors = getBoolean(yytext(),1); }    
  "{HitId " {IDENT} "}"         { ((AutoTraceRay)actObj).hitId = unrealID2intID(getIdent(yytext(),1)); }
}


<NEIGH_LIST> { 
  "{Id " {IDENT} "}" {
  			neighNav.UnrealID = getIdent(yytext(),1); 
  			neighNav.ID       = unrealID2intID(neighNav.UnrealID);
  }
  "{Flags " {INT} "}"         { neighNav.flags = getInt(yytext(),1); }
  "{CollisionR " {INT} "}"    { neighNav.collisionR = getInt(yytext(),1);}
  "{CollisionH " {INT} "}"    { neighNav.collisionH = getInt(yytext(),1);}
  "}" {
  			neighList.add(neighNav);
  			neighNav = null;
  			state_return();
  }
}

<MSG_RCH> {
  "{Id " {IDENT} "}"          {((Reachable)actObj).pongID = getIdent(yytext(),1);}
  "{Reachable " {BOOLEAN} "}" {((Reachable)actObj).reachable = getBoolean(yytext(),1);}
}

<MSG_FAL> {
  "{Fell " {BOOLEAN} "}"      {((FallEdge)actObj).fell     = getBoolean(yytext(),1);}
  "{Location " {TRIPLE} "}"   {((FallEdge)actObj).location = getTriple(yytext(),1);}
}

<MSG_LEFT> {
  "{Id " {IDENT} "}"        {// this is ID of hit
  							 ((PlayerLeft)actObj).UnrealID = getIdent(yytext(),1);
                             ((PlayerLeft)actObj).ID = unrealID2intID(((PlayerLeft)actObj).UnrealID);
  }
  "{Name " {TEXT} "}"	    { ((PlayerLeft)actObj).name = getText(yytext(),1);; } 
}

<MSG_JOIN> {
  "{Id " {IDENT} "}"        {// this is ID of hit
  							 ((PlayerJoinsGame)actObj).UnrealID = getIdent(yytext(),1);
                             ((PlayerJoinsGame)actObj).ID = unrealID2intID(((PlayerJoinsGame)actObj).UnrealID);
  }
  "{Name " {TEXT} "}"	    { ((PlayerJoinsGame)actObj).name = getText(yytext(),1);; } 
}

<MSG_ADG> {
  "{Amount " {FLOAT} "}"   {((AdrenalineGained)actObj).amount = getDouble(yytext(),1); }
}

/********************/

<LIST_UNREALID_DOUBLE> {
	"{" {IDENT} " " {FLOAT} "}" { 
					mapIntIDDouble.put(unrealID2intID(getIdent(yytext(),0)),getDouble(yytext(),1)); 
	}
	" " {}
	"}" {state_return();}
}



<LIST_INT_DOUBLE> {
	"{" {INT} " " {FLOAT} "}" { 
					mapIntDouble.put(getInt(yytext(),0),getDouble(yytext(),1)); }
	" " {}
	"}" {state_return();}
}



{WHITE_SPACE_CHAR} { }

{NEWLINE} { 
		// reset scanning
		stack_pos = 0;
 		yybegin(YYINITIAL);
 		if (actObj != null)
 		{
 			MessageObject obj = (MessageObject) actObj;
 			actObj = null;
 			return obj;
 		}
}


. {
  System.out.println("Illegal character: <" + yytext() + "> + currentstate "+ yystate());
}

