/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerJoinsGame;
import cz.cuni.pogamut.MessageObjects.PlayerLeft;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.server.UTServerConnection;
import cz.cuni.pogamut.server.UTServerConnectionInterface;
import cz.cuni.pogamut.server.UTServerInfoSnapshot;
import cz.cuni.pogamut.server.UTServerState;
import cz.cuni.pogamut.server.UTWorld;
import cz.cuni.pogamut.server.requests.UTServerRequestNavPoints;
import cz.cuni.pogamut.server.requests.UTServerRequestTermination;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVisualizationPanel
extends JPanel
implements UTServerConnectionInterface,
RcvMsgListener,
FlagListener<UTServerState> {
    private static final int MIN_X = 0;
    private static final int MAX_X = 3;
    private static final int MIN_Y = 1;
    private static final int MAX_Y = 4;
    private static final int MIN_Z = 2;
    private static final int MAX_Z = 5;
    private UTWorld ut = null;
    private Logger log = Logger.getAnonymousLogger();
    private Logger rawGBLog = Logger.getAnonymousLogger();
    private boolean initialized = false;
    private URI serverURI = null;
    private UTServerConnection connection = null;
    private UTServerInfoSnapshot info = new UTServerInfoSnapshot();
    private GameInfo gameInfo = new GameInfo();
    private Flag<UTServerState> serverState = new Flag<UTServerState>(UTServerState.NONE);
    private Map<String, Player> players = new HashMap<String, Player>();
    private List<NavPoint> navPoints = new ArrayList<NavPoint>();
    private Map<String, NavPoint> navPointsMap = new HashMap<String, NavPoint>();
    private CountDownLatch waitNavPoints = null;
    private double[] mapExtens = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double xLength = 0.0;
    private double yLength = 0.0;
    private double zLength = 0.0;
    private double xScale = 0.0;
    private double yScale = 0.0;
    private double zScale = 0.0;
    private int xSize = 400;
    private int ySize = 400;
    private int zSize = 10;
    private int xBorder = 5;
    private int yBorder = 5;
    private boolean mapsExtensCounted = false;
    private boolean serverUp = false;

    public MapVisualizationPanel(URI serverURI) {
        this.serverURI = serverURI;
        this.init();
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.log.setLevel(Level.ALL);
        this.rawGBLog.setLevel(Level.ALL);
        this.serverState.addListener(this);
        this.connection = new UTServerConnection(this);
        this.connection.addRcvMsgListener(this);
        this.requestNavPoints();
        this.initialized = true;
    }

    private void processNavPoints(List<NavPoint> navPoints) {
        if (navPoints == null) {
            return;
        }
        HashMap<String, NavPoint> nps = new HashMap<String, NavPoint>();
        for (NavPoint np : navPoints) {
            nps.put(np.UnrealID, np);
        }
        this.navPointsMap = nps;
    }

    private void requestNavPoints() {
        new Thread(new Runnable(){

            public void run() {
                MapVisualizationPanel.this.getNavPointsBlocking();
                MapVisualizationPanel.this.processNavPoints(MapVisualizationPanel.this.navPoints);
                MapVisualizationPanel.this.log.info("Navpoints received (count == " + MapVisualizationPanel.this.navPoints.size() + ").");
                MapVisualizationPanel.this.mapsExtensCounted = false;
            }
        }, "requestNavPoints()").start();
    }

    public void terminate() {
        this.connection.request(new UTServerRequestTermination());
    }

    @Override
    public int getAutoReconnectMillis() {
        return 2000;
    }

    @Override
    public boolean waitForNFOMessageInHandshake() {
        return true;
    }

    @Override
    public MessageType getExpectedWelcomeMessage() {
        return MessageType.HELLO_CONTROL_SERVER;
    }

    @Override
    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    @Override
    public UTServerInfoSnapshot getInfo() {
        return this.info;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public int getPongTimeoutMillis() {
        return 4000;
    }

    @Override
    public Logger getRawGBLog() {
        return this.rawGBLog;
    }

    @Override
    public UTServerState getServerState() {
        return this.serverState.getFlag();
    }

    @Override
    public Flag<UTServerState> getServerStateFlag() {
        return this.serverState;
    }

    @Override
    public URI getGamebotsControlConnectionURI() {
        return this.serverURI;
    }

    @Override
    public CountDownLatch getWaitInventoryLatch() {
        return null;
    }

    @Override
    public CountDownLatch getWaitItemsLatch() {
        return null;
    }

    @Override
    public CountDownLatch getWaitMapsLatch() {
        return null;
    }

    @Override
    public CountDownLatch getWaitNavPointsLatch() {
        return this.waitNavPoints;
    }

    @Override
    public CountDownLatch getWaitRefreshInfoLatch() {
        return null;
    }

    @Override
    public boolean isAutomaticallyReconnect() {
        return true;
    }

    @Override
    public boolean isPingPong() {
        return true;
    }

    @Override
    public void setGameInfo(GameInfo info) {
        this.gameInfo = info;
    }

    public synchronized List<NavPoint> getNavPointsBlocking() {
        if (!this.serverUp) {
            this.log.info("Server is not UP, can't load navpoints to the map.");
            return null;
        }
        this.log.info("getNavPointsBlocking() called...");
        this.waitNavPoints = new CountDownLatch(1);
        this.connection.request(new UTServerRequestNavPoints());
        try {
            this.waitNavPoints.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.navPoints = this.info.navPoints;
        this.mapsExtensCounted = false;
        this.log.info("getNavPointsBlocking() ended...");
        return this.navPoints;
    }

    public void tryToRefresh() {
        this.updateUI();
        this.invalidate();
        this.repaint();
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        switch (e.getMessage().type) {
            case PLAYER: {
                this.updatePlayer((Player)e.getMessage());
                this.tryToRefresh();
                break;
            }
            case PLAYER_LEFT: {
                this.removePlayer((PlayerLeft)e.getMessage());
                this.tryToRefresh();
                break;
            }
            case PLAYER_JOIN: {
                this.addPlayer((PlayerJoinsGame)e.getMessage());
                this.tryToRefresh();
            }
        }
    }

    private void addPlayer(PlayerJoinsGame p) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlayer(PlayerLeft p) {
        Map<String, Player> map = this.players;
        synchronized (map) {
            this.players.remove(p.UnrealID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlayer(Player p) {
        Map<String, Player> map = this.players;
        synchronized (map) {
            this.players.put(p.UnrealID, p);
        }
    }

    private void countMapExtens(List<NavPoint> navPoints) {
        double[] mapExtens = new double[]{9999999.0, 9999999.0, 999999.0, -9999999.0, -999999.0, -999999.0};
        this.log.info("countMapExtens() called, navPoints.size() == " + navPoints.size());
        for (NavPoint nv : navPoints) {
            if (nv.location.x < mapExtens[0]) {
                mapExtens[0] = nv.location.x;
            }
            if (nv.location.x > mapExtens[3]) {
                mapExtens[3] = nv.location.x;
            }
            if (nv.location.y < mapExtens[1]) {
                mapExtens[1] = nv.location.y;
            }
            if (nv.location.y > mapExtens[4]) {
                mapExtens[4] = nv.location.y;
            }
            if (nv.location.z < mapExtens[2]) {
                mapExtens[2] = nv.location.z;
            }
            if (!(nv.location.z > mapExtens[5])) continue;
            mapExtens[5] = nv.location.z;
        }
        this.mapExtens = mapExtens;
        this.xLength = this.mapExtens[3] - this.mapExtens[0];
        this.yLength = this.mapExtens[4] - this.mapExtens[1];
        this.zLength = this.mapExtens[5] - this.mapExtens[2];
        this.recountScales();
        this.mapsExtensCounted = true;
    }

    private void recountScales() {
        this.xScale = (double)this.xSize / this.xLength;
        this.yScale = (double)this.ySize / this.yLength;
        this.zScale = (double)this.zSize / this.zLength;
    }

    public void setMapSize(int x, int y) {
        this.xSize = x;
        this.ySize = y;
        this.recountScales();
    }

    private double[] getXYZ_UT(Triple location) {
        if (location == null) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return new double[]{location.x, location.y, location.z};
    }

    private int[] getPoint(double[] xyz) {
        return new int[]{(int)Math.round((xyz[0] - this.mapExtens[0]) * this.xScale), (int)Math.round((xyz[1] - this.mapExtens[1]) * this.yScale), (int)Math.round((xyz[2] - this.mapExtens[2]) * this.zScale)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintNavPoints(Graphics g) {
        if (this.navPoints == null) {
            this.mapsExtensCounted = false;
            return;
        }
        List<NavPoint> list = this.navPoints;
        synchronized (list) {
            if (!this.mapsExtensCounted) {
                this.countMapExtens(this.navPoints);
            }
            for (NavPoint nv : this.navPoints) {
                g.setColor(Color.BLUE);
                double[] xyzUT1 = this.getXYZ_UT(nv.location);
                int[] xyz1 = this.getPoint(xyzUT1);
                g.drawOval(xyz1[0] - xyz1[2] / 2, xyz1[1] - xyz1[2] / 2, xyz1[2], xyz1[2]);
                for (NeighNav nn : nv.neighbours) {
                    g.setColor(Color.DARK_GRAY);
                    NavPoint temp = this.navPointsMap.get(nn.UnrealID);
                    if (temp == null) continue;
                    double[] xyzUT2 = this.getXYZ_UT(temp.location);
                    int[] xyz2 = this.getPoint(xyzUT2);
                    g.drawLine(xyz1[0], xyz1[1], xyz2[0], xyz2[1]);
                }
            }
        }
    }

    private void paintPlayer(Graphics g, Player pl) {
        double[] xyzUT = this.getXYZ_UT(pl.location);
        int[] xyz = this.getPoint(xyzUT);
        int radius = 6 + xyz[2];
        int halfRadius = Math.round(radius / 2);
        g.drawOval(xyz[0] - halfRadius, xyz[1] - halfRadius, radius, radius);
        if (pl.rotation != null) {
            double rotation = (-pl.rotation.y + 16383.0) * 9.587526218325454E-5;
            g.drawLine(xyz[0], xyz[1], xyz[0] + (int)Math.round((double)halfRadius * Math.sin(rotation)), xyz[1] + (int)Math.round((double)halfRadius * Math.cos(rotation)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPlayers(Graphics g) {
        Map<String, Player> map = this.players;
        synchronized (map) {
            g.setColor(Color.RED);
            for (Player pl : this.players.values()) {
                this.paintPlayer(g, pl);
            }
        }
    }

    private void paintDebug(Graphics g) {
        Font f = Font.decode("Arial-10");
        g.setFont(f);
        g.setColor(Color.GRAY);
        int y = 40;
        g.drawString("extens = [" + this.mapExtens[0] + "," + this.mapExtens[1] + "," + this.mapExtens[2] + "," + this.mapExtens[3] + "]", 5, y);
        g.drawString("sizes(x,y,z) = " + this.xSize + " , " + this.ySize + " , " + this.zSize, 5, y += 15);
        g.drawString("len(x,y,z) = " + this.xLength + " , " + this.yLength + " , " + this.zLength, 5, y += 15);
        g.drawString("scale(x,y,z) = " + this.xScale + " , " + this.yScale + " , " + this.zScale, 5, y += 15);
        y += 15;
    }

    private void paintServerUp(Graphics g) {
        Font f = Font.decode("Arial-12");
        g.setFont(f);
        g.setColor(Color.BLACK);
        g.drawString("Connection is UP (" + this.serverURI.toString() + ")...", 5, 25);
        this.paintNavPoints(g);
        this.paintPlayers(g);
        this.paintDebug(g);
    }

    private void paintServerDown(Graphics g) {
        Font f = Font.decode("Arial-12");
        g.setFont(f);
        g.setColor(Color.BLACK);
        g.drawString("Connection is down (" + this.serverURI.toString() + ")...", 5, 25);
        g.drawString("Connection state: " + this.getServerState().toString(), 5, 45);
        g.drawString(this.getServerState().getHelpMessage(), 5, 65);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.clearRect(0, 0, this.xSize, this.ySize);
        if (this.serverUp) {
            this.paintServerUp(g);
        } else {
            this.paintServerDown(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMapInfo() {
        Object object;
        if (this.navPoints != null) {
            object = this.navPoints;
            synchronized (object) {
                this.navPoints.clear();
            }
        }
        if (this.players != null) {
            object = this.players;
            synchronized (object) {
                this.players.clear();
            }
        }
    }

    @Override
    public void flagChanged(UTServerState changedValue, int listenerParam) {
        switch (changedValue) {
            case NONE: {
                this.clearMapInfo();
                this.serverUp = false;
                this.invalidate();
                break;
            }
            case INITIALIZING: {
                this.clearMapInfo();
                this.serverUp = false;
                this.invalidate();
                break;
            }
            case HANDSHAKE: {
                this.clearMapInfo();
                this.serverUp = false;
                this.invalidate();
                break;
            }
            case UNAVAILABLE: {
                this.clearMapInfo();
                this.serverUp = false;
                this.invalidate();
                break;
            }
            case MAP_CHANGING: {
                this.clearMapInfo();
                this.serverUp = false;
                this.invalidate();
                break;
            }
            case TERMINATED: {
                this.clearMapInfo();
                this.serverUp = false;
                this.invalidate();
                break;
            }
            case RUNNING: 
            case PAUSED: {
                if (this.serverUp) break;
                this.log.info("Server brought UP, requesting nav points.");
                this.serverUp = true;
                this.requestNavPoints();
                this.updateUI();
                this.invalidate();
                this.repaint();
                this.connection.sendCommandToGB("STARTPLRS");
            }
        }
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        frame.setSize(450, 450);
        URI serverURI = null;
        try {
            serverURI = new URI("ut://artemis.ms.mff.cuni.cz:3001");
        }
        catch (URISyntaxException e) {
            System.out.println("BAD URI...");
            e.printStackTrace();
            System.exit(1);
        }
        MapVisualizationPanel panel = new MapVisualizationPanel(serverURI);
        frame.add(panel);
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                frame.setVisible(true);
            }
        });
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    frame.invalidate();
                    frame.repaint();
                }
            }
        }, "Frame repainting thread").start();
    }
}

