/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.introspection.python;

import cz.cuni.pogamut.introspection.DefaultIntrospectableProxy;
import cz.cuni.pogamut.introspection.IntrospectableProxy;
import cz.cuni.pogamut.introspection.Property;
import cz.cuni.pogamut.introspection.python.PyObjectAdapter;
import cz.cuni.pogamut.introspection.python.PyObjectPlace;
import cz.cuni.pogamut.introspection.python.PyObjectWrapper;
import cz.cuni.pogamut.introspection.python.PyUnsupportedWrapper;
import cz.cuni.pogamut.introspection.python.PythonProperty;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonInstrospectableProxy
extends DefaultIntrospectableProxy<Object> {
    private PyObjectAdapter adapter;

    public PythonInstrospectableProxy(String name, PyObjectPlace place) {
        super(place.get());
        this.adapter = new PyObjectAdapter(name, place);
    }

    public PythonInstrospectableProxy(PyObjectAdapter adapter) {
        super(adapter.getObject());
        this.adapter = adapter;
    }

    @Override
    public String getName() {
        return this.adapter.getName();
    }

    protected ArrayList<PyObjectAdapter> filterObject(Object object, boolean hasChildren) {
        ArrayList<PyObjectAdapter> children = this.adapter.getChildren();
        if (children == null) {
            return new ArrayList<PyObjectAdapter>(0);
        }
        ArrayList<PyObjectAdapter> list = new ArrayList<PyObjectAdapter>();
        Object obj = null;
        PyObjectWrapper wrapper = null;
        for (PyObjectAdapter adapter : children) {
            wrapper = adapter.getWrapper(obj = adapter.getObject());
            if (wrapper instanceof PyUnsupportedWrapper) continue;
            if (hasChildren) {
                if (!wrapper.hasChildren(obj)) continue;
                list.add(adapter);
                continue;
            }
            if (wrapper.hasChildren(obj)) continue;
            list.add(adapter);
        }
        return list;
    }

    @Override
    protected IntrospectableProxy[] computeChildren(Object object) {
        ArrayList<PyObjectAdapter> list = this.filterObject(object, true);
        IntrospectableProxy[] proxies = new IntrospectableProxy[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            proxies[i] = new PythonInstrospectableProxy(list.get(i));
        }
        return proxies;
    }

    @Override
    protected Property[] computeProperties(Object object) {
        ArrayList<PyObjectAdapter> list = this.filterObject(object, false);
        Property[] properties = new Property[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            properties[i] = new PythonProperty(list.get(i));
        }
        return properties;
    }

    @Override
    public void closeIntrospection() {
    }
}

