/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.HistoryBatch;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import java.util.HashSet;
import java.util.Iterator;

public class HistoryIterator
implements Iterator {
    private int depth;
    private int actualDepth;
    private boolean unique;
    private MessageType type;
    private HistoryBatch actualBatch;
    private Iterator<MessageObject> valueSetIterator;
    private HashSet<Integer> iteratedIDs;
    private MessageObject actualMessage;

    public HistoryIterator(int depth, MessageType type, boolean unique, HistoryBatch actualBatch) {
        this.depth = depth;
        this.type = type;
        this.unique = unique;
        this.actualBatch = actualBatch;
        this.actualMessage = null;
        this.actualDepth = 0;
        this.valueSetIterator = actualBatch.getAllObjectsOfType(type).values().iterator();
        this.iteratedIDs = new HashSet();
    }

    public boolean hasNext() {
        if (this.unique) {
            return this.hasNextUnique();
        }
        return this.hasNextNormal();
    }

    public Object next() {
        if (this.unique) {
            return this.nextUnique();
        }
        return this.nextNormal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextNormal() {
        HistoryBatch historyBatch = this.actualBatch;
        synchronized (historyBatch) {
            while (this.actualDepth < this.depth && this.actualBatch != null && !this.valueSetIterator.hasNext()) {
                this.actualBatch = this.actualBatch.getNext();
                if (this.actualBatch == null) {
                    return false;
                }
                this.valueSetIterator = this.actualBatch.getAllObjectsOfType(this.type).values().iterator();
                ++this.actualDepth;
            }
            return this.valueSetIterator.hasNext();
            {
            }
        }
    }

    public Object nextNormal() {
        if (this.hasNext()) {
            return this.valueSetIterator.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextUnique() {
        if (this.actualMessage != null) {
            return true;
        }
        while (this.valueSetIterator.hasNext()) {
            this.actualMessage = this.valueSetIterator.next();
            if (this.iteratedIDs.contains(this.actualMessage.ID)) continue;
            return true;
        }
        HistoryBatch historyBatch = this.actualBatch;
        synchronized (historyBatch) {
            while (this.actualDepth < this.depth && this.actualBatch != null && !this.valueSetIterator.hasNext()) {
                this.actualBatch = this.actualBatch.getNext();
                if (this.actualBatch == null) {
                    return false;
                }
                this.valueSetIterator = this.actualBatch.getAllObjectsOfType(this.type).values().iterator();
                ++this.actualDepth;
                while (this.valueSetIterator.hasNext()) {
                    this.actualMessage = this.valueSetIterator.next();
                    if (this.iteratedIDs.contains(this.actualMessage.ID)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object nextUnique() {
        if (this.hasNextUnique()) {
            this.iteratedIDs.add(this.actualMessage.ID);
            MessageObject temp = this.actualMessage;
            this.actualMessage = null;
            return temp;
        }
        return null;
    }

    public void remove() {
    }
}

