<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : yylex.xsl
    Created on : 14. duben 2008, 11:15
    Author     : student
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  version="2.0">
      
<xsl:output method="text"/>
    
<xsl:template match="/">
<![CDATA[
// generated by yylex.xsl from MessageObjectsList.xml, called from ant script build.xml
// file was further processed by JFlex to create class Yylex (yylex.java)
]]>
package <xsl:value-of select="/gbmessages/settings/jflexsettings/jflexpackage/@package"/>;
           
<xsl:for-each select="/gbmessages/settings/jflexsettings/javaimport">
    <xsl:text>import </xsl:text><xsl:value-of select="@package"/><xsl:text>;
    </xsl:text>
</xsl:for-each>
<![CDATA[
// beggining of the yylex definition
%%

// declare result class Yylex as public
%public

// return type of the yylex() method should be Object
%type MessageObject

// default return value should be null
%eofval{
return null;
%eofval}

// following block is containing code that will be added to the generated lexical parser yylex.java
%{
	protected NeighNav neighNav  = null;
	protected ArrayList<NeighNav> neighList = null;
	
	protected boolean navList = false;

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntIDDouble = null;

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntDouble = null;
	
	/** parser reference, this parser will be used for translation of UnrealID to IntID */
	protected Parser parser = null;

	/**
	 * Return an integer from num token in txt
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with integer starting from zero
	 */
	protected int getInt( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {}");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
        	return (new Integer(st.nextToken()).intValue());
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return -1;
        }
	}

	
	/**
	 * Return a double from num token in txt
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with double starting from zero
	 */
	protected double getDouble( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {}");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
        	return (new Double(st.nextToken()).doubleValue());
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return -1.0;
        }
	}

	
	/**
	 * Return a string from num token in txt. 
	 * String ends after encountering "{" or " " or "}"
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with string starting from zero
	 */
	protected String getIdent( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {}");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
        	return st.nextToken();
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return "";
        }
	}
	

	/**
	 * Return text from first after space number num. 
	 * Text will continue untill first occurance of }
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of spaces that can preceder text
	 */
	protected String getText( String txt, int num  ) {
		int index = -1;
		int i = 0; // number of ' ' encountered
		
		while (i < num && (index = txt.indexOf(' ',index+1)) !=-1)
			i++;

		if (index == -1)
			return new String();
		else {
                    int lastBracket =  txt.lastIndexOf("}");
                    if (lastBracket < 0)
                        return txt.substring(index+1);	
                    else
                        return txt.substring(index+1, lastBracket);
                }
	
	}
	
	
        /**
	 * Return a triple starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with double starting from zero
	 */
	protected Triple getTriple( String txt, int num  ) {
		StringTokenizer st = new StringTokenizer(txt," {},");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
			double t1,t2,t3;
			t1 = new Double(st.nextToken()).doubleValue();
			t2 = new Double(st.nextToken()).doubleValue();
			t3 = new Double(st.nextToken()).doubleValue();
        	return new Triple(t1,t2,t3);
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return new Triple(0,0,0);
        }
	}
	
	/**
	 * Return a boolean of this parameter. If error, write an exception and return false.
	 * 
	 * @param  txt  text of parameter
	 * @param  num  number of token with double starting from zero. Tokens are separated by " {},"
	 */
	protected boolean getBoolean( String txt, int num)  {
		StringTokenizer st = new StringTokenizer(txt," {},");
		
		int i = 0;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		try {
		    // OLD CODE:
		    //   if (st.nextToken() == "True")
		    // REPLACED WITH:
		    //   if (st.nextToken().equals("True")
		    //
		    // Jakub Gemrot, 22.2.2007, 10:58
			if (st.nextToken().equals("True"))
				return true;
			else 
				return false;
        } catch (Exception e)
        {
        	System.out.println("Exception: " + e.getMessage());
        	return false;
        }
	
	
	}
			
	/**
	 * Set parser translating UnrealID to IntID.
	 * This function should be called after constructor, I dont know how to define constructor, so this will do.
	 */
	public void setParser(Parser p) {
		parser = p;
	}
	
	/**
	 * Translate UnrealID to IntID
	 * @see Parser
	 */
	protected int unrealID2intID(String unrealID) {
		return parser.translateUnrealID2IntID(unrealID);
	}
	
	
    // this is stack with static size, so it can overflow... theoreticly... No.
    private int[] stack = new int[10];
    private int stack_pos = 0;
    private String tempStr = null;
  
    protected Object actObj;
  
    /**
     * Change state to state and push original state to stack, so parser can return in state_return
     */
    private void state_go(int state)
    {
  	    stack[stack_pos++] = yystate();
  	    yybegin(state);
    }
  
    /**
     * Return to previous state.
     */
    private void state_return()
    {
  	    yybegin(stack[--stack_pos]);
    }
%} 

%line
%char]]>
%state LIST_UNREALID_DOUBLE, LIST_INT_DOUBLE<xsl:for-each select="/gbmessages/gbinfomessages/messageobject/extra/code/yylex/yylexstate">, <xsl:value-of select="@name"/></xsl:for-each>
<![CDATA[%full
%standalone

ALPHA=[A-Za-z]
ALPHA_NUMERIC={ALPHA}|{DIGIT}
SEP=[_\-.]
ALPHA_NUMERIC_SEP = {ALPHA}|{DIGIT}|{SEP}
IDENT={ALPHA_NUMERIC_SEP}+
TEXT=[^}]+
DIGIT=[0-9]
NONNEWLINE_WHITE_SPACE_CHAR=[\ \t\b\012]
NEWLINE=\r|\n|\r\n
WHITE_SPACE_CHAR=[\n\r\ \t\b\012]
UINT = {DIGIT}+
INT = \-? {UINT}

FLOAT    = \-?({FLit1}|{FLit2}|{FLit3})
FLit1    = {DIGIT}+ \. {DIGIT}* 
FLit2    = \. {DIGIT}+ 
FLit3    = {DIGIT}+ 
TRIPLE = {FLOAT} \, {FLOAT} \, {FLOAT}

BOOLEAN = "True" | "False"
%% 

<YYINITIAL> {
]]>
<xsl:for-each select="/gbmessages/gbinfomessages/messageobject/extra/code/yylex/yyinitial">
  <xsl:value-of select="."/>
</xsl:for-each>
<![CDATA[
}

]]>

<xsl:for-each select="/gbmessages/gbinfomessages/messageobject/extra/code/yylex/yylexstate">
  <xsl:value-of select="."/>
</xsl:for-each>

<![CDATA[

//   /--------------------/
//  / MISC. STATES AHEAD /
// /--------------------/

<LIST_UNREALID_DOUBLE> {
	"{" {IDENT} " " {FLOAT} "}" { 
					mapIntIDDouble.put(unrealID2intID(getIdent(yytext(),0)),getDouble(yytext(),1)); 
	}
	" " {}
	"}" {state_return();}
}



<LIST_INT_DOUBLE> {
	"{" {INT} " " {FLOAT} "}" { 
					mapIntDouble.put(getInt(yytext(),0),getDouble(yytext(),1)); }
	" " {}
	"}" {state_return();}
}

{WHITE_SPACE_CHAR} { }

{NEWLINE} { 
		// reset scanning
		stack_pos = 0;
 		yybegin(YYINITIAL);
 		if (actObj != null)
 		{
 			MessageObject obj = (MessageObject) actObj;
 			actObj = null;
 			return obj;
 		}
}


. {
  System.out.println("Illegal character: <" + yytext() + "> + currentstate "+ yystate());
}
]]>

</xsl:template>

</xsl:stylesheet>
