<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : MessageTransformer.xslt.xml
    Created on : 17. březen 2008, 10:53
    Author     : student
    Description:
        Purpose of the document follows.
-->
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  version="2.0">
    <xsl:output method="text" indent="yes"/>

    <!-- target directory for java files. !-->
    <xsl:variable name="javaDir">./test
    </xsl:variable> 
        
    <!-- Template translating message objects to java files. !-->
    <xsl:template match="messageobject">
        <xsl:variable name="filename" select="concat('test/', @name,'.java')" />
        <xsl:result-document href="{$filename}" method="text">
            package <xsl:value-of select="/gbmessages/settings/javasettings/javapackage/@package"/>;
           
            <xsl:for-each select="javaimport">
                <xsl:text>import </xsl:text>
                <xsl:value-of select="@package"/>
                <xsl:text>;</xsl:text>
            </xsl:for-each>
            /** <xsl:value-of select="documentation"/> */
            public class <xsl:value-of select="@name"/>
            <xsl:apply-templates select="@extends"/>
            <xsl:apply-templates select="implements"/> {
            /////// Properties BEGIN
            <xsl:apply-templates select="property"/>
            /////// Properties END
            
            /////// Extra Java code BEGIN
            <xsl:value-of select="extra/code/java"/>    
            /////// Extra Java code END
                 <!-- toString method -->
            public String toString() {
                return super.toString() + <xsl:for-each select="property"> " <xsl:value-of select="@name"/> : " + String.valueOf(<xsl:value-of select="@name"/>) + </xsl:for-each> "";
             }
             
             public String toHtmlString() {
                return super.toString() + <xsl:for-each select="property"> " <b><xsl:value-of select="@name"/></b> : " + String.valueOf(<xsl:value-of select="@name"/>) + " <![CDATA[<br/>]]>  " + </xsl:for-each> "";
             }
             }
        </xsl:result-document>
    </xsl:template>
    <xsl:template match="@extends"> extends <xsl:value-of select="."/></xsl:template>
    <xsl:template match="implements"> implements <xsl:value-of select="@interfaces"/></xsl:template>
    <xsl:template match="property">
        /** <xsl:value-of select="documentation"/> */
        <xsl:value-of select="@type"/><xsl:text> </xsl:text><xsl:value-of select="@name"/>;
    </xsl:template>
</xsl:stylesheet>

  
  