class ControlServer extends GBServerClass;

//To prevent server being closed, when no controlserver instance is connected
event LostChild( Actor C )
{
	super.LostChild(C);
	if ((ConnectionCount == 0) && (LinkState != STATE_Listening))
	{
		bClosed = false;
		Listen();
	}
}

function BeginPlay()
{
	Super.BeginPlay();
	if(!bBound)
	{
		DesiredPort = BotDeathMatch(Owner).ControlServerPort;
		if (BotDeathMatch(Owner).bRandomPorts == true)
			ListenPort = BindPort( , true);
		else
			ListenPort = BindPort( DesiredPort, true);
		if(bDebug)
			log("ControlServer bound to port "$ListenPort);
		Listen();
		bBound = true;
    }
}

defaultproperties
{
     MaxConnections=2
     AcceptClass=BotAPI.ControlConnection
}
