/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.pogamut.Client.Agent;
import java.util.prefs.Preferences;

public class Settings {
    protected static final Preferences pref = Preferences.userNodeForPackage(Agent.class);

    public static Preferences getPrefecences() {
        return pref;
    }

    public static Object get(Setting setting) {
        Object def = setting.def;
        if (String.class.isInstance(def)) {
            return pref.get(setting.key, (String)def);
        }
        if (Integer.class.isInstance(def)) {
            return pref.getInt(setting.key, (Integer)def);
        }
        if (Float.class.isInstance(def)) {
            return Float.valueOf(pref.getFloat(setting.key, ((Float)def).floatValue()));
        }
        if (Boolean.class.isInstance(def)) {
            return pref.getBoolean(setting.key, (Boolean)def);
        }
        return null;
    }

    public static void set(Setting setting, Object val) {
        if (String.class.isInstance(val)) {
            pref.put(setting.key, (String)val);
        } else if (Integer.class.isInstance(val)) {
            pref.putInt(setting.key, (Integer)val);
        } else if (Float.class.isInstance(val)) {
            pref.putFloat(setting.key, ((Float)val).floatValue());
        } else if (Boolean.class.isInstance(val)) {
            pref.putBoolean(setting.key, (Boolean)val);
        } else {
            System.err.println("Trying to write wrong setting.");
        }
    }

    public static enum Setting {
        SERVER_UPDATE_FREQUENCY("ServerUpdateFrequency", Float.valueOf(0.5f)),
        PREFERRED_PARSER_TYPE("PreferredParserType", "REMOTE"),
        PLATFORM_DIR("PlatformDir", ""),
        LOG_WIN_BEHAVIOR("LogWinBehavior", "NEW"),
        SHOW_WELCOME("ShowWelcomeScreen", true),
        PLATFORM_DEBUG("PlatfromDebugFeatures", false),
        FORCE_SIMPLE_ON_STARTUP("ForceSimpleViewOnStartup", true);

        public String key = null;
        public Object def = null;

        private Setting(String key, Object def) {
            this.key = key;
            this.def = def;
        }
    }
}

