/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class GenericLoader<T> {
    public T loadObject(InputStream in) {
        try {
            return (T)new ObjectInputStream(in).readObject();
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public T loadObject(File file) {
        try {
            return this.loadObject(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public T loadObject(String pathAndFileName) {
        return this.loadObject(new File(pathAndFileName));
    }

    public boolean saveObject(T object, ObjectOutputStream out) {
        try {
            out.writeObject(object);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean saveObject(T object, OutputStream out) {
        try {
            return this.saveObject(object, new ObjectOutputStream(out));
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean saveObject(T object, File file) {
        try {
            return this.saveObject(object, new FileOutputStream(file));
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean saveObject(T object, String pathAndFileName) {
        return this.saveObject(object, new File(pathAndFileName));
    }
}

