/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.utils.FlagListener;
import cz.cuni.utils.ImmutableFlag;
import java.util.ArrayList;
import java.util.Iterator;

public class Flag<T> {
    private T value;
    private ArrayList<ListenerStore<T>> listeners = new ArrayList();
    protected ImmutableFlag<T> immutableWrapper = null;

    public Flag() {
        this.value = null;
    }

    public Flag(T initialValue) {
        this.value = initialValue;
    }

    public void setFlag(T newValue) {
        if (newValue == null ? this.value == null : this.value != null && newValue.equals(this.value)) {
            return;
        }
        this.value = newValue;
        ListenerStore[] listenerStoreArray = this.listeners.toArray(new ListenerStore[0]);
        int n = listenerStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerStore ls = listenerStoreArray[n2];
            ls.listener.flagChanged(newValue, ls.callListenerWithParam);
            ++n2;
        }
    }

    public ImmutableFlag<T> getImmutable() {
        if (this.immutableWrapper == null) {
            this.immutableWrapper = new ImmutableFlag(this);
        }
        return this.immutableWrapper;
    }

    public T getFlag() {
        return this.value;
    }

    public boolean addListener(FlagListener<T> listener, int callListenerWithParam) {
        if (listener == null) {
            return false;
        }
        return this.listeners.add(new ListenerStore<T>(listener, callListenerWithParam));
    }

    public boolean addListener(FlagListener<T> listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.add(new ListenerStore<T>(listener, 0));
    }

    public boolean removeListener(FlagListener<T> listener) {
        if (listener == null) {
            return false;
        }
        boolean success = false;
        Iterator<ListenerStore<T>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ListenerStore<T> ls = iter.next();
            if (!ls.listener.equals(listener)) continue;
            iter.remove();
            success = true;
        }
        return success;
    }

    public boolean removeListener(FlagListener<T> listener, int listenerParam) {
        if (listener == null) {
            return false;
        }
        boolean success = false;
        Iterator<ListenerStore<T>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ListenerStore<T> ls = iter.next();
            if (!ls.listener.equals(listener) || ls.callListenerWithParam != listenerParam) continue;
            iter.remove();
            success = true;
        }
        return success;
    }

    public boolean isListenning(FlagListener<T> listener) {
        if (listener == null) {
            return false;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get((int)i).listener.equals(listener)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isListenning(FlagListener<T> listener, int listenerParam) {
        if (listener == null) {
            return false;
        }
        for (ListenerStore<T> ls : this.listeners) {
            if (!ls.listener.equals(listener) || ls.callListenerWithParam != listenerParam) continue;
            return true;
        }
        return false;
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public static void main(String[] args) {
        Flag<Boolean> flag = new Flag<Boolean>(true);
        FlagListener<Boolean> fl1 = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue, int listenerParam) {
                System.out.println("1 FIRED, new value = " + changedValue.toString() + " param == " + listenerParam);
            }
        };
        FlagListener<Boolean> fl2 = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue, int listenerParam) {
                System.out.println("2 FIRED, new value = " + changedValue.toString() + " param == " + listenerParam);
            }
        };
        FlagListener<Boolean> fl3 = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue, int listenerParam) {
                System.out.println("3 FIRED, new value = " + changedValue.toString() + " param == " + listenerParam);
            }
        };
        System.out.println("Expecting: 1");
        flag.addListener(fl1, 1);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("");
        System.out.println("Expecting: 1,2");
        flag.addListener(fl1, 2);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Expecting: 1,2,3");
        flag.addListener(fl2, 3);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("");
        System.out.println("Expecting: 1,2,3,4");
        flag.addListener(fl2, 4);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Expecting: 1,2,3,4,5");
        flag.addListener(fl3, 5);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("");
        System.out.println("Expecting: 1,2,3,4,5,6");
        flag.addListener(fl3, 6);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Expecting: 1,2,3,4,5,6,6");
        flag.addListener(fl3, 6);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("");
        System.out.println("Expecting: 3,4,5,6,6");
        flag.removeListener(fl1);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Expecting: 3,4,5");
        flag.removeListener(fl3, 6);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("");
        System.out.println("Expecting: 3,4,5");
        flag.removeListener(fl2, 1);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Expecting: 4,5");
        flag.removeListener(fl2, 3);
        flag.setFlag(false);
        flag.setFlag(false);
    }

    class ListenerStore<T> {
        public FlagListener<T> listener;
        public int callListenerWithParam;

        public ListenerStore(FlagListener<T> listener, int callListenerWithParam) {
            this.listener = listener;
            this.callListenerWithParam = callListenerWithParam;
        }
    }
}

